/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.api.composite.map;

import aurora.ide.api.composite.map.CommentCompositeMap;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeMapParser;
import uncertain.composite.NameProcessor;

public class CommentCompositeMapParser
extends CompositeMapParser
implements LexicalHandler {
    public static final String SAX_NEWlINE = "&#xA;";
    String comment;
    public static final String INCLUDE_INSTRUCTION = "include";
    public static final String XINCLUDE_URI = "http://www.w3.org/2001/XInclude";
    public static final String KEY_HREF = "href";
    CompositeMap current_node = null;
    LinkedList node_stack = new LinkedList();
    Map uri_mapping = new HashMap();
    Map saved_uri_mapping;
    Map namespace_mapping = new HashMap();
    NameProcessor name_processor;
    CompositeLoader composite_loader;
    Locator locator;
    static SAXParserFactory parser_factory = SAXParserFactory.newInstance();

    static {
        try {
            parser_factory.setNamespaceAware(true);
            parser_factory.setValidating(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CommentCompositeMapParser(CompositeLoader composite_loader) {
        super(composite_loader);
        this.composite_loader = composite_loader;
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        if (this.composite_loader.getSupportXInclude() && localName.equals(INCLUDE_INSTRUCTION) && namespaceURI != null && namespaceURI.equals(XINCLUDE_URI)) {
            CompositeMap included;
            String href_target = atts.getValue(KEY_HREF);
            if (href_target == null) {
                throw new SAXException("No 'href' attribute set for an XInclude instruction");
            }
            try {
                included = this.getCompositeLoader().load(href_target);
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
            if (this.current_node == null) {
                this.current_node = included;
            } else {
                this.current_node.addChild(included);
            }
            return;
        }
        if (this.name_processor != null) {
            localName = this.name_processor.getElementName(localName);
        }
        CommentCompositeMap node = null;
        node = this.getCompositeLoader() != null ? (CommentCompositeMap)this.getCompositeLoader().createCompositeMap((String)this.uri_mapping.get(namespaceURI), namespaceURI, localName) : new CommentCompositeMap((String)this.uri_mapping.get(namespaceURI), namespaceURI, localName);
        this.addAttribs(node, atts);
        if (this.comment != null) {
            node.setComment(this.comment);
            this.comment = null;
        }
        if (this.current_node == null) {
            this.current_node = node;
        } else {
            this.current_node.addChild((CompositeMap)node);
            this.push(this.current_node);
            this.current_node = node;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.comment != null && this.current_node instanceof CommentCompositeMap) {
            ((CommentCompositeMap)this.current_node).setEndElementComment(this.comment);
            this.comment = null;
        }
        if (this.getCompositeLoader().getSupportXInclude() && localName.equals(INCLUDE_INSTRUCTION) && uri != null && uri.equals(XINCLUDE_URI)) {
            return;
        }
        if (this.node_stack.size() > 0) {
            this.current_node = this.pop();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (ch == null) {
            return;
        }
        if (length == 0) {
            return;
        }
        if (this.current_node != null) {
            String t = this.current_node.getText();
            t = t != null ? String.valueOf(t) + new String(ch, start, length) : new String(ch, start, length);
            t = this.handleNewLine(t);
            t = t.replaceAll(SAX_NEWlINE, "\n");
            this.current_node.setText(t);
        }
    }

    public CompositeMap parseStream(InputStream stream) throws SAXException, IOException {
        SAXParser parser = null;
        try {
            parser = parser_factory.newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("error when creating SAXParser", ex);
        }
        parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        stream = this.handleNewLineInAttribute(stream);
        parser.parse(stream, (DefaultHandler)((Object)this));
        CompositeMap root = this.getRoot();
        if (this.getCompositeLoader().getSaveNamespaceMapping()) {
            root.setNamespaceMapping(this.saved_uri_mapping);
        }
        return root;
    }

    private InputStream handleNewLineInAttribute(InputStream stream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        String content = "";
        String line = br.readLine();
        while (line != null) {
            content = String.valueOf(content) + line + "\r\n";
            line = br.readLine();
        }
        stream = new ByteArrayInputStream(CommentCompositeMapParser.convertNewLine(content, 0).getBytes("UTF-8"));
        return stream;
    }

    public static String convertNewLine(String fileContent, int index) {
        StringBuilder sb = new StringBuilder(fileContent);
        int leftIndex = sb.indexOf("\"");
        int d = SAX_NEWlINE.length() - 1;
        while (leftIndex != -1) {
            int rightIndex = sb.indexOf("\"", leftIndex + 1);
            if (rightIndex == -1) break;
            int i = leftIndex + 1;
            while (i < rightIndex) {
                if (sb.charAt(i) == '\n') {
                    sb.replace(i, i + 1, SAX_NEWlINE);
                    i += d;
                    rightIndex += d;
                }
                ++i;
            }
            leftIndex = sb.indexOf("\"", rightIndex + 1);
        }
        return sb.toString();
    }

    public static String _convertNewLine(String fileContent, int index) {
        int count;
        String text;
        String content;
        String pstr = "\"([^\"]*)\"";
        Pattern p = Pattern.compile(pstr);
        Matcher m = p.matcher(content = fileContent.substring(index));
        if (m.find()) {
            text = m.group();
            text = text.replaceAll("\n", SAX_NEWlINE);
            count = 0;
            int fromIndex = 0;
            while ((fromIndex = text.indexOf(SAX_NEWlINE, fromIndex)) != -1) {
                ++count;
                fromIndex += 5;
            }
        } else {
            return fileContent;
        }
        fileContent = String.valueOf(fileContent.substring(0, m.start() + index)) + text + fileContent.substring(m.end() + index);
        index = m.end() + index + 4 * count;
        return CommentCompositeMapParser.convertNewLine(fileContent, index);
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (ch == null) {
            return;
        }
        String separator = "-->";
        String now = new String(ch, start, length);
        now = now.replaceAll(SAX_NEWlINE, "\n");
        this.comment = this.comment != null ? String.valueOf(this.comment) + separator + now : now;
    }

    private String handleNewLine(String src) {
        if (src == null) {
            return null;
        }
        String result = src.replace("\r", "");
        result = result.replace("\n", "\r\n");
        return result;
    }

    void push(CompositeMap node) {
        this.node_stack.addFirst(node);
    }

    CompositeMap pop() {
        CompositeMap node = (CompositeMap)this.node_stack.getFirst();
        this.node_stack.removeFirst();
        return node;
    }

    void addAttribs(CompositeMap node, Attributes attribs) {
        int i = 0;
        while (i < attribs.getLength()) {
            String attrib_name = attribs.getQName(i);
            if (this.name_processor != null) {
                attrib_name = this.name_processor.getAttributeName(attrib_name);
            }
            node.put((Object)attrib_name, (Object)attribs.getValue(i));
            ++i;
        }
    }

    public void startDocument() {
        this.current_node = null;
        this.node_stack.clear();
        this.uri_mapping.clear();
        this.name_processor = this.getCompositeLoader().getNameProcessor();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix == null) {
            return;
        }
        if (prefix.length() == 0) {
            return;
        }
        this.uri_mapping.put(uri, prefix);
        this.namespace_mapping.put(prefix, uri);
        if (this.getCompositeLoader().getSaveNamespaceMapping()) {
            if (this.saved_uri_mapping == null) {
                this.saved_uri_mapping = new HashMap();
            }
            this.saved_uri_mapping.put(uri, prefix);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.uri_mapping.remove(prefix);
    }

    public CompositeMap getRoot() {
        return this.current_node;
    }

    public void setCompositeLoader(CompositeLoader loader) {
        this.composite_loader = loader;
    }

    public CompositeLoader getCompositeLoader() {
        return this.composite_loader;
    }

    public void clear() {
        this.current_node = null;
        if (this.node_stack != null) {
            this.node_stack.clear();
        }
        if (this.uri_mapping != null) {
            this.uri_mapping.clear();
        }
        this.name_processor = null;
        this.composite_loader = null;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }
}

