/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.api.composite.map;

import aurora.ide.api.composite.map.Comment;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class CommentReader {
    private String comment;

    public CommentReader(String comment) {
        this.comment = comment;
    }

    public Comment read() {
        Comment c = new Comment();
        if (this.comment == null) {
            return c;
        }
        try {
            List<String> sl = FileUtil.readStringFileToList(new ByteArrayInputStream(this.comment.getBytes("utf-8")));
            for (String s : sl) {
                this.parse(s, c);
            }
        }
        catch (UnsupportedEncodingException e) {
            DialogUtil.logErrorException(e);
            e.printStackTrace();
        }
        return c;
    }

    private void parse(String c, Comment cc) {
        int center;
        int begin = (c = c.trim()).indexOf("$");
        if (begin == 0 && (center = c.indexOf(":")) != -1) {
            String key = c.substring(begin + 1, center);
            String value = c.substring(center + 1);
            if (!this.isBlank(key) && !this.isBlank(value)) {
                cc.put(key.trim().toLowerCase(), value.trim());
            }
        }
    }

    private boolean isBlank(String s) {
        return s == null || "".equals(s.trim());
    }
}

