/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.editor;

import aurora.ide.AuroraPlugin;
import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.bm.BMUtil;
import aurora.ide.bm.editor.GridDialog;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraConstant;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.ImagesUtils;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.node.action.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;

public class AddRefFieldAction
extends ActionListener {
    private GridViewer viewer;
    private CompositeMap model;
    private static final String relations = "relations";
    private static final String refModel = "refModel";
    private static final String ref_fields = "ref-fields";
    private static final String refFieldElement = "ref-field";
    private static final String specialSeparator = "\"";
    private static final String[] gridProperties = new String[]{"name", "relationName", "ref_model"};
    private static final String[] refFieldProperties = new String[]{"sourceField", "name", "relationName"};
    private CompositeMap gridInput;

    public AddRefFieldAction(GridViewer viewer, CompositeMap model, int actionStyle) {
        this.viewer = viewer;
        this.model = model;
        this.setActionStyle(actionStyle);
    }

    public void run() {
        Object fields;
        if (this.model == null) {
            DialogUtil.showErrorMessageBox("This model is null !");
            return;
        }
        this.gridInput = new CommentCompositeMap("gridInput");
        QualifiedName modelQN = new QualifiedName(this.model.getNamespaceURI(), this.model.getName());
        Assert.isTrue((boolean)AuroraConstant.ModelQN.getLocalName().equals(modelQN.getLocalName()), (String)"This CompositeMap is not a model element!");
        CompositeMap relationsCM = this.model.getChild(relations);
        if (relationsCM == null) {
            DialogUtil.showErrorMessageBox("relations is null !");
            return;
        }
        List childList = relationsCM.getChildsNotNull();
        if (childList.size() == 0) {
            DialogUtil.showErrorMessageBox("relations have no child !");
            return;
        }
        CompositeMap refFields_array = this.viewer.getInput();
        ArrayList existRefFields = this.getExistRefFields(refFields_array);
        if (existRefFields == null) {
            existRefFields = new ArrayList();
        }
        for (CompositeMap relation : childList) {
            fields = this.makeInput(relation, existRefFields);
            if (fields == null) continue;
            this.gridInput.addChilds((Collection)fields.getChildsNotNull());
        }
        CompositeMap selectFileds = null;
        try {
            selectFileds = this.selectFileds();
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
            return;
        }
        CompositeMap refFields = this.createRefFields(selectFileds);
        if (refFields == null) {
            return;
        }
        fields = refFields.getChildsNotNull();
        if (fields.size() == 0) {
            return;
        }
        if (this.model.getChild(ref_fields) == null) {
            this.model.addChild(refFields_array);
        }
        refFields_array.addChilds((Collection)fields);
        this.viewer.refresh(true);
    }

    public ImageDescriptor getDefaultImageDescriptor() {
        return AuroraPlugin.getImageDescriptor(LocaleMessage.getString("add.icon"));
    }

    private CompositeMap makeInput(CompositeMap relation, List existRefFields) {
        String fieldName = "name";
        CommentCompositeMap input = new CommentCompositeMap("input");
        String ref_model = relation.getString((Object)refModel);
        if (ref_model == null) {
            return null;
        }
        CompositeMap fields = null;
        try {
            IResource bmFile = BMUtil.getBMResourceFromClassPath(ref_model);
            CompositeMap bmData = AuroraResourceUtil.loadFromResource(bmFile);
            fields = bmData.getChild("fields");
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
            return null;
        }
        if (fields == null) {
            return null;
        }
        List fieldList = fields.getChildsNotNull();
        if (fieldList.size() == 0) {
            return null;
        }
        for (CompositeMap field : fieldList) {
            String field_name = field.getString((Object)"name");
            if (field_name == null) {
                DialogUtil.showErrorMessageBox(String.valueOf(ref_model) + "'s " + field.toXML() + " has no 'name' property");
                continue;
            }
            String relationName = relation.getString((Object)"name");
            String fieldKey = String.valueOf(field_name) + specialSeparator + relationName;
            if (existRefFields.contains(fieldKey)) continue;
            CommentCompositeMap record = new CommentCompositeMap(this.model.getPrefix(), this.model.getNamespaceURI(), refFieldElement);
            record.put(gridProperties[0], field_name);
            record.put(gridProperties[1], relationName);
            record.put(gridProperties[2], ref_model);
            input.addChild(record);
        }
        return input;
    }

    private CompositeMap selectFileds() throws ApplicationException {
        CompositeMap selectResult = null;
        GridViewer grid = new GridViewer(2);
        grid.setData(this.gridInput);
        grid.setColumnNames(gridProperties);
        GridDialog dialog = new GridDialog(new Shell(), grid);
        if (dialog.open() == 0) {
            selectResult = dialog.getSelected();
        }
        return selectResult;
    }

    private CompositeMap createRefFields(CompositeMap selectResult) {
        CommentCompositeMap refFields = new CommentCompositeMap("refFileds");
        if (selectResult == null) {
            return null;
        }
        for (CompositeMap record : selectResult.getChildsNotNull()) {
            record.put((Object)refFieldProperties[0], (Object)record.getString((Object)"name"));
            record.remove((Object)gridProperties[2]);
            refFields.addChild(record);
        }
        return refFields;
    }

    private List getExistRefFields(CompositeMap refFields) {
        if (refFields == null) {
            return null;
        }
        ArrayList<String> existRefFields = new ArrayList<String>();
        List childs = refFields.getChildsNotNull();
        if (childs.size() == 0) {
            return null;
        }
        for (CompositeMap child : childs) {
            String fieldKey = this.getFieldKey(child);
            if (fieldKey == null) continue;
            existRefFields.add(fieldKey);
        }
        return existRefFields;
    }

    private String getFieldKey(CompositeMap field) {
        if (field == null) {
            return null;
        }
        String sourceField = field.getString((Object)refFieldProperties[0]);
        String relationName = field.getString((Object)refFieldProperties[2]);
        if (sourceField == null || relationName == null) {
            return null;
        }
        String fieldKey = String.valueOf(sourceField) + specialSeparator + relationName;
        return fieldKey;
    }

    public Image getDefaultImage() {
        return ImagesUtils.getImage("add.gif");
    }
}

