/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.bm.wizard.procedure;

import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.bm.wizard.procedure.BMFromProcedurePage;
import aurora.ide.bm.wizard.procedure.OracleProcedureObject;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.ProjectUtil;
import aurora.ide.helpers.SystemException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.ide.IDE;
import uncertain.composite.CompositeMap;

public class BMFromProcedure
extends Wizard
implements INewWizard {
    private BMFromProcedurePage mainPage;
    private IProject project;
    private boolean isOverwrite;

    public BMFromProcedure() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.mainPage = new BMFromProcedurePage(this.project);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        CompositeMap selection = this.mainPage.getSelection();
        this.isOverwrite = this.mainPage.isOverwrite();
        if (selection == null || selection.getChilds() == null && selection.getChilds().size() < 1) {
            return true;
        }
        Iterator it = selection.getChildIterator();
        while (it.hasNext()) {
            final CompositeMap record = (CompositeMap)it.next();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            BMFromProcedure.this.doFinish(record, monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                this.getContainer().run(true, false, op);
            }
            catch (Throwable e) {
                DialogUtil.showExceptionMessageBox(e);
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doFinish(CompositeMap record, IProgressMonitor monitor) throws CoreException {
        String fileName = this.getFullFilePath(record);
        monitor.beginTask("Creating " + fileName, 2);
        String bmHome = "";
        try {
            bmHome = ProjectUtil.getBMHome(this.project);
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
            return;
        }
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(String.valueOf(bmHome) + File.separator + fileName));
        try {
            InputStream stream = this.openContentStream(record);
            if (file.exists()) {
                if (!this.isOverwrite) {
                    stream.close();
                    return;
                }
                file.setContents(stream, true, true, monitor);
            } else {
                this.createParentFolder(file.getParent());
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            DialogUtil.logErrorException(e);
        }
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(1);
    }

    private String getFullFilePath(CompositeMap record) {
        String overload;
        String fullPath = "db" + File.separator;
        String object_name = record.getString((Object)"object_name");
        String procedure_name = record.getString((Object)"procedure_name");
        fullPath = String.valueOf(fullPath) + object_name;
        if (procedure_name != null && !"".equals(procedure_name)) {
            fullPath = String.valueOf(fullPath) + File.separator + procedure_name;
        }
        if ((overload = record.getString((Object)"overload")) != null && !"".equals(overload)) {
            fullPath = String.valueOf(fullPath) + "_" + overload;
        }
        fullPath = String.valueOf(fullPath) + ".bm";
        return fullPath.toLowerCase();
    }

    private void createParentFolder(IContainer foler) throws CoreException {
        IContainer parent = foler.getParent();
        if (parent != null && !parent.exists()) {
            this.createParentFolder(parent);
        }
        if (!foler.exists()) {
            ((IFolder)foler).create(0, true, null);
        }
    }

    private InputStream openContentStream(CompositeMap record) throws ApplicationException {
        String xmlHint = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        OracleProcedureObject Object2 = new OracleProcedureObject(record.getString((Object)"object_name"), record.getString((Object)"procedure_name"), record.getInt((Object)"subprogram_id"), record.getString((Object)"object_type"));
        String contents = String.valueOf(xmlHint) + AuroraResourceUtil.LineSeparator + AuroraResourceUtil.getSign() + CommentXMLOutputter.defaultInstance().toXML(Object2.toCompositeMap(), true);
        try {
            return new ByteArrayInputStream(contents.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException(e);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object[] result;
        ContainerSelectionDialog dialog;
        this.project = ProjectUtil.getIProjectFromSelection();
        if (this.project == null && (dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, LocaleMessage.getString("select.new.file.container"))).open() == 0 && (result = dialog.getResult()).length == 1) {
            this.project = ResourcesPlugin.getWorkspace().getRoot().findMember(((Path)result[0]).toString()).getProject();
        }
    }
}

