/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.builder.processor;

import aurora.ide.builder.AuroraBuilder;
import aurora.ide.builder.BuildContext;
import aurora.ide.builder.BuildMessages;
import aurora.ide.builder.ResourceUtil;
import aurora.ide.builder.SxsdUtil;
import aurora.ide.builder.processor.AbstractProcessor;
import aurora.ide.builder.processor.LocalFieldCollector;
import aurora.ide.preferencepages.BuildLevelPage;
import aurora.ide.search.core.Util;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import uncertain.composite.CompositeMap;
import uncertain.schema.Attribute;

public class ForeignFieldProcessor
extends AbstractProcessor {
    private int level;

    public void processMap(BuildContext bc) {
        String ext = "_" + bc.file.getFileExtension().toUpperCase();
        this.level = BuildLevelPage.getBuildLevel("aurora.ide.undefinedForeignField" + ext);
        if (this.level == 0) {
            return;
        }
        this.processAttribute(bc);
    }

    public void visitAttribute(Attribute a, BuildContext bc) {
        if (!SxsdUtil.isForeignFieldReference(a.getAttributeType())) {
            return;
        }
        String name = a.getName();
        String value = bc.map.getString((Object)name);
        IRegion region = bc.info.getAttrValueRegion2(name);
        int line = bc.info.getLineOfRegion(region);
        CompositeMap refModelDeclearMap = bc.map.getParent();
        String refModel = (String)Util.getReferenceModelPKG(refModelDeclearMap);
        if (refModel == null) {
            refModelDeclearMap = refModelDeclearMap.getParent();
            refModel = (String)Util.getReferenceModelPKG(refModelDeclearMap);
        }
        if (refModel == null) {
            return;
        }
        IFile bmfile = ResourceUtil.getBMFile(bc.file.getProject(), refModel);
        if (bmfile != null) {
            Set<String> locFields = new LocalFieldCollector(bmfile).collect();
            if (locFields.contains(value)) {
                return;
            }
            String msg = String.format(BuildMessages.get("build.foreignfield.undefined"), a.getName(), value, refModel);
            AuroraBuilder.addMarker(bc.file, msg, line + 1, region, this.level, "aurora.ide.undefinedForeignField");
        }
    }

    public void processComplete(IFile file, CompositeMap map, IDocument doc) {
    }
}

