/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.celleditor;

import aurora.ide.AuroraPlugin;
import aurora.ide.celleditor.CellInfo;
import aurora.ide.celleditor.ICellEditor;
import aurora.ide.helpers.LocaleMessage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class AbstractTextCellEditor
extends TextCellEditor
implements ICellEditor {
    protected CellInfo cellProperties;
    protected String oldInput;
    protected boolean isRebuilding;

    public AbstractTextCellEditor(CellInfo cellProperties) {
        this.cellProperties = cellProperties;
    }

    public boolean validValue(String value) {
        if (this.cellProperties.isRequired() && (value == null || value.equals(""))) {
            String message = "<" + this.cellProperties.getColumnName() + "> " + LocaleMessage.getString("field") + LocaleMessage.getString("is.required");
            this.setErrorMessage(message);
            this.getCellControl().forceFocus();
            return false;
        }
        return true;
    }

    public Control getCellControl() {
        return super.getControl();
    }

    public String getSelection() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Object valueToShow(String value) {
        return value;
    }

    public void SetSelection(String value) {
        if (value != null) {
            super.setValue((Object)value);
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void init() {
        if (this.getCellControl() != null) {
            return;
        }
        Color bg = Display.getDefault().getSystemColor(7);
        Table parent = this.cellProperties.getTable();
        this.createCellEditor((Composite)parent);
        if (this.cellProperties.isRequired()) {
            this.getCellControl().setBackground(bg);
        }
        if (this.isTableItemEditor()) {
            this.SetSelection(this.cellProperties.getRecord().getString((Object)this.cellProperties.getColumnName()));
        }
        this.addCellListener();
        this.oldInput = this.getSelection();
    }

    protected void addCellListener() {
        if (!this.isTableItemEditor()) {
            return;
        }
        this.addListener(new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void cancelEditor() {
            }

            public void applyEditorValue() {
                String dataValue = AbstractTextCellEditor.this.getSelection();
                if (AbstractTextCellEditor.this.validValue(dataValue)) {
                    AbstractTextCellEditor.this.oldInput = dataValue;
                    AuroraPlugin.logToStatusLine(null, true);
                } else {
                    AuroraPlugin.logToStatusLine(AbstractTextCellEditor.this.getErrorMessage(), true);
                }
                if (dataValue == null || "".equals(dataValue)) {
                    AbstractTextCellEditor.this.cellProperties.getRecord().remove((Object)AbstractTextCellEditor.this.cellProperties.getColumnName());
                } else {
                    AbstractTextCellEditor.this.cellProperties.getRecord().put((Object)AbstractTextCellEditor.this.cellProperties.getColumnName(), (Object)dataValue);
                }
            }
        });
        this.getCellControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (AbstractTextCellEditor.this.isTableItemEditor()) {
                    AbstractTextCellEditor.this.rebuildCellEditor(AbstractTextCellEditor.this.cellProperties.getTableItem());
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    protected void rebuildCellEditor(TableItem item) {
        TableEditor editor = new TableEditor(item.getParent());
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.setEditor(this.getCellControl(), item, 1);
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }

    public CellEditor getCellEditor() {
        return this;
    }

    private boolean isTableItemEditor() {
        return this.cellProperties.getTableItem() != null;
    }
}

