/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.celleditor;

import aurora.ide.celleditor.AbstractTextCellEditor;
import aurora.ide.celleditor.CellInfo;
import aurora.ide.helpers.LocaleMessage;
import org.eclipse.swt.widgets.Composite;
import uncertain.composite.QualifiedName;
import uncertain.datatype.ConvertionException;
import uncertain.datatype.DataType;
import uncertain.datatype.DataTypeRegistry;

public class NumberTextCellEditor
extends AbstractTextCellEditor {
    public NumberTextCellEditor(CellInfo cellProperties) {
        super(cellProperties);
    }

    public boolean validValue(String value) {
        String errorMessage = "";
        QualifiedName typeQname = this.cellProperties.getTypeQname();
        String typeLocalName = typeQname.getLocalName();
        DataType dt = DataTypeRegistry.getInstance().getDataType(typeLocalName);
        try {
            if (dt != null && value != null) {
                dt.convert((Object)value);
            }
        }
        catch (ConvertionException e) {
            errorMessage = String.valueOf(LocaleMessage.getString("this.value")) + "'" + value + "' can not for this field <" + this.cellProperties.getColumnName() + "> !  " + e.getLocalizedMessage();
            this.setErrorMessage(errorMessage);
            this.getCellControl().setFocus();
            return false;
        }
        return super.validValue(value);
    }

    public void createCellEditor(Composite parent) {
        this.setStyle(0x4000000);
        super.create(parent);
    }
}

