/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.component.wizard;

import aurora.ide.AuroraPlugin;
import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.bm.BMUtil;
import aurora.ide.bm.editor.GridDialog;
import aurora.ide.celleditor.BoolCellEditor;
import aurora.ide.celleditor.CellInfo;
import aurora.ide.editor.core.IViewer;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.editor.widgets.PropertyHashViewer;
import aurora.ide.editor.widgets.WizardPageRefreshable;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraConstant;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.node.action.AddElementAction;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;

public class CreateComboBoxFromBMAction
extends AddElementAction {
    static final String title = "\u521b\u5efaComboBox";

    public CreateComboBoxFromBMAction(IViewer viewer, CompositeMap currentNode, QualifiedName childQN, int actionStyle) {
        super(viewer, currentNode, childQN, actionStyle);
    }

    public ImageDescriptor getDefaultImageDescriptor() {
        return AuroraPlugin.getImageDescriptor(LocaleMessage.getString("wizard.icon"));
    }

    public void run() {
        if (this.currentNode == null || !AuroraConstant.FieldsQN.equals((Object)this.currentNode.getQName())) {
            DialogUtil.showErrorMessageBox("\u5f53\u524d\u9009\u4e2d\u7684\u4e0d\u662fFields\u8282\u70b9!");
            return;
        }
        ComboBoxWizard wizard = new ComboBoxWizard(this.currentNode);
        WizardDialog dialog = new WizardDialog(new Shell(), (IWizard)wizard);
        dialog.open();
        boolean successful = wizard.isSuccessful();
        if (this.viewer != null && successful) {
            this.viewer.refresh(true);
        }
    }

    private CompositeMap getDataSets(CompositeMap currentNode) {
        if (currentNode == null) {
            return null;
        }
        CompositeMap childNode = currentNode;
        CompositeMap parentNode = null;
        while ((parentNode = childNode.getParent()) != null) {
            if (AuroraConstant.DataSetSQN.equals((Object)parentNode.getQName())) break;
            childNode = parentNode;
        }
        return parentNode;
    }

    private String[] getFieldNames(CompositeMap fieldsNode) {
        if (fieldsNode == null || fieldsNode.getChildIterator() == null) {
            return null;
        }
        String[] fileds = new String[fieldsNode.getChilds().size()];
        int index = 0;
        Iterator it = fieldsNode.getChildIterator();
        while (it.hasNext()) {
            CompositeMap filed = (CompositeMap)it.next();
            fileds[index++] = filed.getString((Object)"name");
        }
        return fileds;
    }

    class ComboBoxWizard
    extends Wizard
    implements IViewer {
        private boolean successful;
        private MainConfigPage mainConfigPage;
        private FieldPage fieldPage;
        private CompositeMap fieldsNode;

        public ComboBoxWizard(CompositeMap fieldsNode) {
            CreateComboBoxFromBMAction.this.setText(CreateComboBoxFromBMAction.title);
            this.fieldsNode = fieldsNode;
        }

        public void addPages() {
            this.mainConfigPage = new MainConfigPage(this, this.fieldsNode);
            this.mainConfigPage.setPageComplete(false);
            this.addPage((IWizardPage)this.mainConfigPage);
            this.fieldPage = new FieldPage(this);
            this.addPage((IWizardPage)this.fieldPage);
        }

        public boolean performFinish() {
            String prefix = CompositeMapUtil.getContextPrefix(this.fieldsNode, CreateComboBoxFromBMAction.this.childQN);
            CreateComboBoxFromBMAction.this.childQN.setPrefix(prefix);
            CommentCompositeMap fieldNode = new CommentCompositeMap(CreateComboBoxFromBMAction.this.childQN.getPrefix(), CreateComboBoxFromBMAction.this.childQN.getNameSpace(), CreateComboBoxFromBMAction.this.childQN.getLocalName());
            fieldNode.put("name", this.mainConfigPage.getFieldNameText().getText());
            fieldNode.put("options", this.mainConfigPage.getDataSetText().getText());
            String[] fields = this.mainConfigPage.getFields();
            fieldNode.put("displayField", fields[this.mainConfigPage.getDisplayFieldCombo().getSelectionIndex()]);
            fieldNode.put("valueField", fields[this.mainConfigPage.getValueFieldCombo().getSelectionIndex()]);
            fieldNode.put("returnField", fields[this.mainConfigPage.getReturnFieldCombo().getSelectionIndex()]);
            CommentCompositeMap mappingNode = new CommentCompositeMap(CreateComboBoxFromBMAction.this.childQN.getPrefix(), CreateComboBoxFromBMAction.this.childQN.getNameSpace(), "mapping");
            CompositeMap fieldsSelection = this.fieldPage.getSelection();
            if (fieldsSelection != null && fieldsSelection.getChildIterator() != null) {
                Iterator it = fieldsSelection.getChildIterator();
                while (it.hasNext()) {
                    CompositeMap field = (CompositeMap)it.next();
                    CommentCompositeMap mapNode = new CommentCompositeMap(CreateComboBoxFromBMAction.this.childQN.getPrefix(), CreateComboBoxFromBMAction.this.childQN.getNameSpace(), "map");
                    String fieldName = field.getString((Object)"name");
                    mapNode.put("from", fieldName);
                    mapNode.put("to", fieldName);
                    mappingNode.addChild(mapNode);
                }
                fieldNode.addChild(mappingNode);
            }
            CompositeMapUtil.addElement(this.fieldsNode, fieldNode);
            this.successful = true;
            return true;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public void createPageControls(Composite pageContainer) {
        }

        public void refresh(boolean isDirty) {
        }

        public CompositeMap getDataSetFields() {
            return this.mainConfigPage.getDataSetFields();
        }
    }

    class FieldPage
    extends WizardPageRefreshable {
        public static final String PAGE_NAME = "FiledPage";
        private ComboBoxWizard wizard;
        private GridViewer gridViewer;
        PropertyHashViewer hashViewer;
        HashMap field_properties;

        protected FieldPage(ComboBoxWizard wizard) {
            super(PAGE_NAME);
            this.field_properties = new HashMap();
            this.setTitle("\u521b\u5efaComboBox--" + LocaleMessage.getString("filed.page"));
            this.wizard = wizard;
        }

        public void createControl(Composite parent) {
            Composite content = new Composite(parent, 0);
            content.setLayout((Layout)new GridLayout());
            String[] columnNames = new String[]{"name"};
            String[] columnTitles = new String[]{"\u5b57\u6bb5"};
            this.gridViewer = new GridViewer(columnNames, 450);
            this.gridViewer.setColumnTitles(columnTitles);
            try {
                this.gridViewer.createViewer(content);
                CellEditor[] celleditors = new CellEditor[columnNames.length];
                int i = 1;
                while (i < columnNames.length) {
                    CellInfo cellProperties = new CellInfo(this.gridViewer, columnNames[i], false);
                    BoolCellEditor cellEditor = new BoolCellEditor(cellProperties);
                    cellEditor.init();
                    celleditors[i] = cellEditor.getCellEditor();
                    this.gridViewer.addEditor(columnNames[i], cellEditor);
                    ++i;
                }
                this.gridViewer.setCellEditors(celleditors);
                this.gridViewer.setData(this.wizard.getDataSetFields());
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
            this.setPageComplete(true);
            this.initPageValues();
            this.checkPageValues();
            this.setControl((Control)content);
        }

        public void refreshPage() {
            if (!this.isInit()) {
                return;
            }
        }

        public CompositeMap getSelection() {
            if (this.gridViewer == null) {
                return null;
            }
            return this.gridViewer.getSelection();
        }

        public void checkPageValues() {
        }
    }

    class MainConfigPage
    extends WizardPageRefreshable {
        public static final String PAGE_NAME = "mainPage";
        private CompositeMap dataSetFields;
        private Text dataSetText;
        private Text fieldNameText;
        private Combo displayFieldCombo;
        private Combo valueFieldCombo;
        private Combo returnFieldCombo;
        private CompositeMap srcDataSet;
        private String[] fileds;

        public String[] getFields() {
            return this.fileds;
        }

        public CompositeMap getDataSetFields() {
            return this.dataSetFields;
        }

        public Text getDataSetText() {
            return this.dataSetText;
        }

        public Text getFieldNameText() {
            return this.fieldNameText;
        }

        public Combo getDisplayFieldCombo() {
            return this.displayFieldCombo;
        }

        public Combo getValueFieldCombo() {
            return this.valueFieldCombo;
        }

        public Combo getReturnFieldCombo() {
            return this.returnFieldCombo;
        }

        public CompositeMap getSrcDataSet() {
            return this.srcDataSet;
        }

        protected MainConfigPage(IViewer parent, CompositeMap fieldsNode) {
            super(PAGE_NAME);
            this.setTitle("\u521b\u5efaComboBox--" + LocaleMessage.getString("mainpage"));
        }

        public boolean canFlipToNextPage() {
            if (this.dataSetText != null && !"".equals(this.dataSetText.getText()) && this.dataSetFields == null) {
                DialogUtil.showErrorMessageBox("\u6b64dataSet\u6ca1\u6709\u53ef\u7528\u5b57\u6bb5.");
                return false;
            }
            return super.canFlipToNextPage();
        }

        public void checkPageValues() {
            String dateSetId = this.dataSetText.getText();
            if (dateSetId == null || "".equals(dateSetId)) {
                this.updatePageStatus("\u5fc5\u987b\u6307\u5b9aDataSet!");
                return;
            }
            try {
                this.dataSetFields = BMUtil.getFieldsFromDS(this.srcDataSet);
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
            if (this.dataSetFields == null) {
                this.updatePageStatus("\u6b64DataSet\u6ca1\u6709\u5b9a\u4e49field\u5b57\u6bb5.");
                return;
            }
            if (this.dataSetFields == null) {
                this.updatePageStatus("\u6b64BM\u6ca1\u6709\u5b9a\u4e49field\u5b57\u6bb5.");
                return;
            }
            this.fileds = CreateComboBoxFromBMAction.this.getFieldNames(this.dataSetFields);
            if (this.fileds == null) {
                this.updatePageStatus("\u6b64BM\u6ca1\u6709\u5b9a\u4e49field\u5b57\u6bb5.");
                return;
            }
            String fieldName = this.fieldNameText.getText();
            if (fieldName == null || fieldName.equals("")) {
                this.updatePageStatus("\u8bf7\u8f93\u5165\u5b57\u6bb5\u540d");
                return;
            }
            if (this.displayFieldCombo.getSelectionIndex() == -1) {
                this.updatePageStatus("\u663e\u793a\u5b57\u6bb5\u5fc5\u8f93.");
                return;
            }
            if (this.valueFieldCombo.getSelectionIndex() == -1) {
                this.updatePageStatus("\u503c\u5b57\u6bb5\u5fc5\u8f93.");
                return;
            }
            if (this.returnFieldCombo.getSelectionIndex() == -1) {
                this.updatePageStatus("\u8fd4\u56de\u5b57\u6bb5\u5fc5\u8f93.");
                return;
            }
            this.updatePageStatus(null);
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(3, false));
            GridData gd = new GridData(768);
            Label label = new Label(container, 0);
            label.setText("\u9009\u62e9DataSet");
            this.dataSetText = new Text(container, 2052);
            this.dataSetText.setLayoutData((Object)gd);
            this.dataSetText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MainConfigPage.this.checkPageValues();
                    if (MainConfigPage.this.fileds != null) {
                        MainConfigPage.this.displayFieldCombo.clearSelection();
                        MainConfigPage.this.displayFieldCombo.setItems(MainConfigPage.this.fileds);
                        MainConfigPage.this.valueFieldCombo.clearSelection();
                        MainConfigPage.this.valueFieldCombo.setItems(MainConfigPage.this.fileds);
                        MainConfigPage.this.returnFieldCombo.clearSelection();
                        MainConfigPage.this.returnFieldCombo.setItems(MainConfigPage.this.fileds);
                    }
                }
            });
            Button pickBMButton = new Button(container, 8);
            pickBMButton.setText(LocaleMessage.getString("openBrowse"));
            pickBMButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        this.pickDataSet();
                    }
                    catch (ApplicationException e) {
                        DialogUtil.showExceptionMessageBox(e);
                    }
                }

                private void pickDataSet() throws ApplicationException {
                    CompositeMap dataSets = CreateComboBoxFromBMAction.this.getDataSets(CreateComboBoxFromBMAction.this.currentNode);
                    GridViewer grid = new GridViewer(null, 48);
                    grid.setData(dataSets);
                    grid.setFilterColumn("id");
                    grid.setColumnNames(new String[]{"id"});
                    GridDialog dialog = new GridDialog(new Shell(), grid);
                    if (dialog.open() == 0) {
                        MainConfigPage.this.srcDataSet = dialog.getSelected();
                        if (MainConfigPage.this.srcDataSet != null && MainConfigPage.this.srcDataSet.getString((Object)"id") != null) {
                            MainConfigPage.this.dataSetText.setText(MainConfigPage.this.srcDataSet.getString((Object)"id"));
                        }
                    }
                }
            });
            label = new Label(container, 0);
            label.setText("\u5b57\u6bb5\u540d");
            this.fieldNameText = new Text(container, 2052);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.fieldNameText.setLayoutData((Object)gd);
            this.fieldNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MainConfigPage.this.checkPageValues();
                }
            });
            label = new Label(container, 0);
            label.setText("\u663e\u793a\u5b57\u6bb5");
            this.displayFieldCombo = new Combo(container, 18436);
            this.displayFieldCombo.setLayoutData((Object)gd);
            this.displayFieldCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MainConfigPage.this.checkPageValues();
                }
            });
            label = new Label(container, 0);
            label.setText("\u503c\u5b57\u6bb5");
            this.valueFieldCombo = new Combo(container, 18436);
            this.valueFieldCombo.setLayoutData((Object)gd);
            this.valueFieldCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MainConfigPage.this.checkPageValues();
                }
            });
            label = new Label(container, 0);
            label.setText("\u8fd4\u56de\u5b57\u6bb5");
            this.returnFieldCombo = new Combo(container, 18436);
            this.returnFieldCombo.setLayoutData((Object)gd);
            this.returnFieldCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MainConfigPage.this.checkPageValues();
                }
            });
            this.setControl((Control)container);
        }
    }
}

