/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.component.wizard;

import aurora.ide.AuroraPlugin;
import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.bm.BMUtil;
import aurora.ide.bm.editor.GridDialog;
import aurora.ide.celleditor.AuroraCellEditor;
import aurora.ide.celleditor.CellInfo;
import aurora.ide.celleditor.ComboxCellEditor;
import aurora.ide.editor.core.IViewer;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.editor.widgets.PropertyHashViewer;
import aurora.ide.editor.widgets.core.ICellModifierListener;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraConstant;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LoadSchemaManager;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.node.action.AddElementAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.schema.ComplexType;
import uncertain.schema.Element;
import uncertain.schema.IType;
import uncertain.schema.editor.AttributeValue;
import uncertain.schema.editor.CompositeMapEditor;

public class CreateFormFromDataSetAction
extends AddElementAction {
    static final String idColumn = "id";
    static final String modelColumn = "model";
    static final String queryDataSetColumn = "queryDataSet";
    static final String title = LocaleMessage.getString("create.form.from.dataset");
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String screenBodyColumn = "screenBody";

    public CreateFormFromDataSetAction(IViewer viewer, CompositeMap parentCM, QualifiedName qName, int actionStyle) {
        super(viewer, parentCM, qName, actionStyle);
    }

    public ImageDescriptor getDefaultImageDescriptor() {
        return AuroraPlugin.getImageDescriptor(LocaleMessage.getString("wizard.icon"));
    }

    public void run() {
        if (this.currentNode == null || !AuroraConstant.DataSetQN.equals((Object)this.currentNode.getQName())) {
            DialogUtil.showErrorMessageBox("It is not a dataSet element!");
            return;
        }
        if (this.currentNode.getString((Object)idColumn) == null) {
            DialogUtil.showErrorMessageBox("\u8bf7\u5148\u8bbe\u7f6eID\u5c5e\u6027.");
            return;
        }
        try {
            if (BMUtil.getFieldsFromDS(this.currentNode) == null) {
                DialogUtil.showErrorMessageBox("\u6b64dataSet\u6ca1\u6709\u53ef\u7528\u5b57\u6bb5.");
                return;
            }
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
            return;
        }
        CompositeMap view = this.currentNode.getParent().getParent();
        if (view == null || !AuroraConstant.ViewQN.equals((Object)view.getQName())) {
            DialogUtil.showErrorMessageBox("Its parent's parent is not a view element!");
            return;
        }
        boolean successful = this.createForm(this.currentNode);
        if (this.viewer != null && successful) {
            this.viewer.refresh(true);
        }
    }

    private boolean createForm(CompositeMap dataSet) {
        FormWizard wizard = new FormWizard(dataSet);
        WizardDialog dialog = new WizardDialog(new Shell(), (IWizard)wizard);
        dialog.open();
        return wizard.isSuccessful();
    }

    class FieldPage
    extends WizardPage
    implements IViewer {
        public static final String PAGE_NAME = "FiledPage";
        public static final String uri = "http://www.aurora-framework.org/application";
        private FormWizard wizard;
        private GridViewer grid;
        ModifyCompositeMapListener newCompositeMap;
        GridColumnSEQSorter sorter;
        PropertyHashViewer hashViewer;
        HashMap field_properties;

        protected FieldPage(FormWizard wizard) {
            super(PAGE_NAME);
            this.field_properties = new HashMap();
            this.setTitle(String.valueOf(title) + "--" + LocaleMessage.getString("filed.page"));
            this.wizard = wizard;
        }

        public void createControl(Composite parent) {
            Composite content = new Composite(parent, 0);
            content.setLayout((Layout)new FillLayout());
            SashForm sashForm = new SashForm(content, 512);
            try {
                this.createGridViewer((Composite)sashForm);
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
                return;
            }
            this.createHashViewer((Composite)sashForm);
            this.grid.addSelectionChangedListener(new ElementSelectionListener());
            sashForm.setWeights(new int[]{5, 5});
            this.setControl((Control)content);
        }

        private void createHashViewer(Composite content) {
            this.hashViewer = new PropertyHashViewer(this, content);
            this.hashViewer.createEditor();
        }

        public CompositeMap getSelection() {
            return this.grid.getSelection();
        }

        private void createGridViewer(Composite parent) throws ApplicationException {
            Composite content = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            content.setLayout((Layout)gridLayout);
            CompositeMap fields = this.wizard.getFields();
            CommentCompositeMap filedNames = new CommentCompositeMap();
            for (CompositeMap child : fields.getChildsNotNull()) {
                String targetNode = child.getString((Object)"name");
                if (targetNode == null) continue;
                CommentCompositeMap newChild = new CommentCompositeMap();
                newChild.put("name", targetNode);
                newChild.put("prompt", child.getString((Object)"prompt"));
                newChild.put("editor", AuroraCellEditor.getInstance().getEditorName(child));
                newChild.put("columnIndex", "1");
                filedNames.addChild(newChild);
            }
            String[] columnProperties = new String[]{"name", "prompt", "editor", "columnIndex"};
            this.grid = new GridViewer(columnProperties, 386);
            this.grid.setParent(this);
            this.grid.createViewer(content);
            int columnCount = this.wizard.getColumnCount();
            this.sorter = new GridColumnSEQSorter(this, columnCount, filedNames);
            this.grid.setTableSorter(this.sorter);
            TableViewer tableView = this.grid.getViewer();
            CellEditor[] celleditors = new CellEditor[columnProperties.length];
            int i = 0;
            while (i < columnProperties.length) {
                celleditors[i] = new TextCellEditor((Composite)tableView.getTable());
                ++i;
            }
            QualifiedName qn = new QualifiedName(uri, "Field");
            ComplexType type = LoadSchemaManager.getSchemaManager().getComplexType(qn);
            List editors = LoadSchemaManager.getSchemaManager().getElementsOfType((IType)type);
            Iterator editorIt = editors.iterator();
            String[] items = new String[editors.size()];
            int i2 = 0;
            while (editorIt.hasNext()) {
                Element editor = (Element)editorIt.next();
                items[i2] = editor.getLocalName();
                ++i2;
            }
            CellInfo cellProperties = new CellInfo(this.grid, "editor", false);
            cellProperties.setItems(items);
            ComboxCellEditor cellEditor = new ComboxCellEditor(cellProperties);
            cellEditor.init();
            celleditors[columnProperties.length - 2] = cellEditor.getCellEditor();
            this.grid.addEditor("editor", cellEditor);
            this.grid.setCellEditors(celleditors);
            this.grid.setData(filedNames);
            this.newCompositeMap = new ModifyCompositeMapListener();
            this.grid.addCellModifierListener(this.newCompositeMap);
            Composite buttonGroup = new Composite(content, 0);
            GridData gridData = new GridData(4, 4, true, true);
            buttonGroup.setLayoutData((Object)gridData);
            RowLayout rowLayout = new RowLayout();
            rowLayout.type = 512;
            rowLayout.marginTop = 30;
            rowLayout.pack = false;
            buttonGroup.setLayout((Layout)rowLayout);
            Button add = new Button(buttonGroup, 8);
            add.setText(LocaleMessage.getString("up"));
            add.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FieldPage.this.sorter.up(FieldPage.this.grid.getFocus());
                }
            });
            Button edit = new Button(buttonGroup, 8);
            edit.setText(LocaleMessage.getString("down"));
            edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FieldPage.this.sorter.down(FieldPage.this.grid.getFocus());
                }
            });
        }

        public HashMap getChangeData() {
            return this.newCompositeMap.getChangeData();
        }

        public HashMap getFieldProperties() {
            return this.field_properties;
        }

        public void refresh(boolean isDirty) {
            this.grid.refresh(false);
        }

        public void repaint() throws ApplicationException {
            if (this.newCompositeMap == null) {
                return;
            }
            CompositeMap fields = this.wizard.getFields();
            CommentCompositeMap filedNames = new CommentCompositeMap();
            for (CompositeMap child : fields.getChildsNotNull()) {
                String targetNode = child.getString((Object)"name");
                if (targetNode == null) continue;
                CommentCompositeMap newChild = new CommentCompositeMap();
                newChild.put("name", targetNode);
                newChild.put("prompt", child.getString((Object)"prompt"));
                newChild.put("editor", AuroraCellEditor.getInstance().getEditorName(child));
                newChild.put("columnIndex", "1");
                filedNames.addChild(newChild);
            }
            int columnCount = this.wizard.getColumnCount();
            this.sorter = new GridColumnSEQSorter(this, columnCount, filedNames);
            this.grid.setTableSorter(this.sorter);
            this.grid.setData(filedNames);
            this.newCompositeMap.clear();
            this.field_properties.clear();
        }

        public HashMap getColumnFields() {
            return this.sorter.getColumnFields();
        }

        class ElementSelectionListener
        implements ISelectionChangedListener {
            private boolean validError = false;

            ElementSelectionListener() {
            }

            public void selectionChanged(SelectionChangedEvent event) {
                if (this.validError) {
                    this.validError = false;
                    return;
                }
                String errorMessage = FieldPage.this.hashViewer.clear(true);
                if (errorMessage != null) {
                    this.validError = true;
                    FieldPage.this.grid.getViewer().setSelection((ISelection)new StructuredSelection((Object)FieldPage.this.grid.getFocus()));
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                CompositeMap data = (CompositeMap)selection.getFirstElement();
                if (data == null) {
                    return;
                }
                FieldPage.this.grid.setFocus(data);
                try {
                    FieldPage.this.hashViewer.setData(this.getEditorData(data));
                }
                catch (ApplicationException e) {
                    DialogUtil.showExceptionMessageBox(e);
                }
            }

            private CompositeMap getEditorData(CompositeMap data) {
                String field = data.getString((Object)"name");
                Object proObject = FieldPage.this.field_properties.get(field);
                if (proObject != null) {
                    return (CompositeMap)proObject;
                }
                QualifiedName editorQualified = new QualifiedName(FieldPage.uri, data.getString((Object)"editor"));
                String prefix = CompositeMapUtil.getContextPrefix(data, editorQualified);
                CommentCompositeMap editor = new CommentCompositeMap(prefix, editorQualified.getNameSpace(), editorQualified.getLocalName());
                FieldPage.this.field_properties.put(field, editor);
                return editor;
            }
        }

        class GridColumnSEQSorter
        extends ViewerSorter {
            private HashMap field_column = new HashMap();
            private HashMap column_fields = new HashMap();
            private IViewer viewer;
            private int columnCount;

            public GridColumnSEQSorter(IViewer viewer, int columnCount, CompositeMap allFields) {
                this.viewer = viewer;
                this.columnCount = columnCount;
                this.initArrays(allFields);
            }

            public int getColumnCount() {
                return this.columnCount;
            }

            private void initArrays(CompositeMap allFields) {
                int i = 0;
                while (i < this.columnCount) {
                    this.column_fields.put(new Integer(i + 1), new ArrayList());
                    ++i;
                }
                ArrayList list = (ArrayList)this.column_fields.get(new Integer(1));
                for (CompositeMap field : allFields.getChildsNotNull()) {
                    String fieldName = field.getString((Object)"name");
                    list.add(fieldName);
                    this.field_column.put(fieldName, new Integer(1));
                }
            }

            public void up(CompositeMap field) {
                String fieldName = field.getString((Object)"name");
                Integer columnIndex = (Integer)this.field_column.get(fieldName);
                ArrayList list = (ArrayList)this.column_fields.get(columnIndex);
                int index = list.indexOf(fieldName);
                if (index <= 0) {
                    return;
                }
                list.remove(index);
                list.add(index - 1, fieldName);
                this.viewer.refresh(true);
            }

            public void down(CompositeMap field) {
                String fieldName = field.getString((Object)"name");
                Integer columnIndex = (Integer)this.field_column.get(fieldName);
                ArrayList list = (ArrayList)this.column_fields.get(columnIndex);
                int index = list.indexOf(fieldName);
                if (index == list.size() - 1) {
                    return;
                }
                list.remove(index);
                list.add(index + 1, fieldName);
                this.viewer.refresh(true);
            }

            public void changeColumn(CompositeMap field, int targetColumn) {
                String fieldName = field.getString((Object)"name");
                Integer columnIndex = (Integer)this.field_column.get(fieldName);
                if (columnIndex == targetColumn) {
                    return;
                }
                ArrayList list = (ArrayList)this.column_fields.get(columnIndex);
                list.remove(fieldName);
                ArrayList moveTo = (ArrayList)this.column_fields.get(new Integer(targetColumn));
                moveTo.add(fieldName);
                this.field_column.put(fieldName, new Integer(targetColumn));
            }

            public int category(Object element) {
                CompositeMap field = (CompositeMap)element;
                String fieldName = field.getString((Object)"name");
                Object object = this.field_column.get(fieldName);
                if (object == null) {
                    return this.columnCount + 1;
                }
                return (Integer)object;
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                int index2;
                int cat2;
                int cat1 = this.category(e1);
                if (cat1 != (cat2 = this.category(e2))) {
                    return cat1 - cat2;
                }
                String field1 = ((CompositeMap)e1).getString((Object)"name");
                String field2 = ((CompositeMap)e2).getString((Object)"name");
                ArrayList list = (ArrayList)this.column_fields.get(new Integer(cat2));
                int index1 = list.indexOf(field1);
                if (index1 != (index2 = list.indexOf(field2))) {
                    if (index2 == -1) {
                        return -1;
                    }
                    return index1 - index2;
                }
                int result = this.getComparator().compare(field1, field2);
                return result;
            }

            public HashMap getColumnFields() {
                return this.column_fields;
            }
        }

        class ModifyCompositeMapListener
        implements ICellModifierListener {
            HashMap records = new HashMap();

            ModifyCompositeMapListener() {
            }

            public void modify(CompositeMap record, String property, String value) {
                String name = record.getString((Object)"name");
                CommentCompositeMap newRecord = null;
                if (this.records.get(name) == null) {
                    newRecord = new CommentCompositeMap("column");
                    newRecord.put("name", name);
                    this.records.put(name, newRecord);
                } else {
                    newRecord = (CompositeMap)this.records.get(name);
                }
                if ("columnIndex".equals(property)) {
                    int column = 0;
                    if (value != null && !value.equals("")) {
                        try {
                            column = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e2) {
                            DialogUtil.showErrorMessageBox("please.input.number");
                            return;
                        }
                        if (column > FieldPage.this.sorter.getColumnCount() || column < 1) {
                            DialogUtil.showErrorMessageBox(String.valueOf(LocaleMessage.getString("column.number.warning")) + FieldPage.this.sorter.getColumnCount() + LocaleMessage.getString("between"));
                            return;
                        }
                    }
                    if (column == 0) {
                        column = 1;
                    }
                    FieldPage.this.sorter.changeColumn(record, column);
                } else if ("editor".equals(property)) {
                    CompositeMap editor;
                    String field = record.getString((Object)"name");
                    Object proObject = FieldPage.this.field_properties.get(field);
                    if (proObject != null && value.equals((editor = (CompositeMap)proObject).getName())) {
                        return;
                    }
                    try {
                        FieldPage.this.hashViewer.setData(this.getEditorData(record, value));
                    }
                    catch (ApplicationException e) {
                        DialogUtil.showExceptionMessageBox(e);
                    }
                }
                newRecord.put(property, value);
            }

            private CompositeMap getEditorData(CompositeMap data, String editorName) {
                String field = data.getString((Object)"name");
                QualifiedName editorQualified = new QualifiedName(FieldPage.uri, editorName);
                String prefix = CompositeMapUtil.getContextPrefix(data, editorQualified);
                CommentCompositeMap editor = new CommentCompositeMap(prefix, editorQualified.getNameSpace(), editorQualified.getLocalName());
                FieldPage.this.field_properties.put(field, editor);
                return editor;
            }

            public HashMap getChangeData() {
                return this.records;
            }

            public void clear() {
                this.records.clear();
            }
        }
    }

    class FormWizard
    extends Wizard
    implements IViewer {
        private boolean successful;
        private MainConfigPage mainConfigPage;
        private FieldPage fieldPage;
        private CompositeMap dataSet;

        public FormWizard(CompositeMap dataSet) {
            CreateFormFromDataSetAction.this.setText(title);
            this.dataSet = dataSet;
        }

        public void addPages() {
            this.mainConfigPage = new MainConfigPage(this, this.dataSet);
            this.mainConfigPage.setPageComplete(false);
            this.addPage((IWizardPage)this.mainConfigPage);
            this.fieldPage = new FieldPage(this);
            this.addPage((IWizardPage)this.fieldPage);
        }

        public boolean performFinish() {
            String prefix = this.dataSet.getPrefix();
            String uri = this.dataSet.getNamespaceURI();
            CommentCompositeMap form = new CommentCompositeMap(prefix, uri, "form");
            int columnCount = this.mainConfigPage.getColumnCount();
            form.put("column", new Integer(columnCount));
            form.put(CreateFormFromDataSetAction.idColumn, this.mainConfigPage.getId());
            HashMap columnFields = this.fieldPage.getColumnFields();
            HashMap changeData = this.fieldPage.getChangeData();
            HashMap allfields = this.getAllFields();
            HashMap fieldProperties = this.fieldPage.getFieldProperties();
            CompositeMap selectedDataSet = this.mainConfigPage.getDataSet();
            Set names = allfields.keySet();
            if (names.size() == 0) {
                return true;
            }
            CompositeMap view = this.dataSet.getParent().getParent();
            this.addToScreenBody(form);
            int i = 0;
            while (i < columnCount) {
                CommentCompositeMap vBox = new CommentCompositeMap(prefix, uri, "vBox");
                ArrayList fields = (ArrayList)columnFields.get(new Integer(i + 1));
                for (String field : fields) {
                    if (!names.contains(field)) continue;
                    CompositeMap record = (CompositeMap)allfields.get(field);
                    String editorString = record.getString((Object)"editor");
                    CommentCompositeMap editorMap = new CommentCompositeMap(prefix, uri, editorString);
                    if (changeData.get(field) != null) {
                        record = (CompositeMap)changeData.get(field);
                    }
                    editorMap.put("name", record.getString((Object)"name"));
                    editorMap.put("bindTarget", selectedDataSet.getString((Object)CreateFormFromDataSetAction.idColumn));
                    editorMap.put("prompt", record.getString((Object)"prompt"));
                    CompositeMap editorProperties = (CompositeMap)fieldProperties.get(field);
                    if (editorProperties != null) {
                        CompositeMapEditor cmEditor = new CompositeMapEditor(LoadSchemaManager.getSchemaManager(), editorProperties);
                        AttributeValue[] abvs = cmEditor.getAttributeList();
                        int k = 0;
                        while (k < abvs.length) {
                            AttributeValue abv = abvs[k];
                            if (abv.getValue() != null) {
                                editorMap.put(abv.getAttribute().getName(), abv.getValue());
                            }
                            ++k;
                        }
                    }
                    vBox.addChild(editorMap);
                }
                form.addChild(vBox);
                ++i;
            }
            if (this.mainConfigPage.isCreateButton()) {
                String jsString;
                String type = this.mainConfigPage.getType();
                CompositeMap js = view.getChild("script");
                if (js == null) {
                    js = new CommentCompositeMap("script");
                    view.addChild(0, js);
                }
                if ((jsString = js.getText()) == null) {
                    jsString = "";
                }
                String functionName = String.valueOf(selectedDataSet.getString((Object)CreateFormFromDataSetAction.idColumn)) + "_" + type;
                int jsLevel = 3;
                String functionIndent = "";
                int i2 = 0;
                while (i2 < 3) {
                    functionIndent = String.valueOf(functionIndent) + "    ";
                    ++i2;
                }
                jsString = String.valueOf(jsString) + lineSeparator + functionIndent + "function  " + functionName + "()" + "{" + lineSeparator;
                if ("query".equals(type)) {
                    Object[] objs = this.getQueryDataSets(view, selectedDataSet.getString((Object)CreateFormFromDataSetAction.idColumn));
                    if (objs != null) {
                        int i3 = 0;
                        while (i3 < objs.length) {
                            jsString = String.valueOf(jsString) + functionIndent + "    " + "$('" + (String)objs[i3] + "').query();" + lineSeparator;
                            ++i3;
                        }
                    } else {
                        jsString = null;
                    }
                } else {
                    jsString = String.valueOf(jsString) + functionIndent + "    " + " $('" + selectedDataSet.getString((Object)CreateFormFromDataSetAction.idColumn) + "').submit();" + lineSeparator;
                }
                if (jsString != null) {
                    jsString = String.valueOf(jsString) + functionIndent + "}";
                    js.setText(jsString);
                    CommentCompositeMap buttons = new CommentCompositeMap(prefix, uri, "hBox");
                    CommentCompositeMap button = new CommentCompositeMap(prefix, uri, "button");
                    button.put("click", functionName);
                    buttons.addChild(button);
                    this.addToScreenBody(buttons);
                }
            }
            this.successful = true;
            return true;
        }

        private void addToScreenBody(CompositeMap grid) {
            CompositeMap view = CreateFormFromDataSetAction.this.currentNode.getParent().getParent();
            CompositeMap screenBody = view.getChild(CreateFormFromDataSetAction.screenBodyColumn);
            if (screenBody == null) {
                screenBody = new CommentCompositeMap(CreateFormFromDataSetAction.this.currentNode.getPrefix(), CreateFormFromDataSetAction.this.currentNode.getNamespaceURI(), CreateFormFromDataSetAction.screenBodyColumn);
                view.addChild(screenBody);
            }
            screenBody.addChild(grid);
        }

        private Object[] getQueryDataSets(CompositeMap viewer, String dataSetId) {
            ArrayList<String> dataSetUsed = new ArrayList<String>();
            CompositeMap dataSets = viewer.getChild("dataSets");
            if (dataSets == null || dataSets.getChildsNotNull().size() == 0) {
                return null;
            }
            for (CompositeMap child : dataSets.getChildsNotNull()) {
                if (!dataSetId.equals(child.getString((Object)CreateFormFromDataSetAction.queryDataSetColumn))) continue;
                dataSetUsed.add(child.getString((Object)CreateFormFromDataSetAction.idColumn));
            }
            return dataSetUsed.toArray();
        }

        public HashMap getAllFields() {
            HashMap<String, CompositeMap> allFields = new HashMap<String, CompositeMap>();
            CompositeMap selection = this.fieldPage.getSelection();
            Iterator iterator = selection.getChildIterator();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    CompositeMap record = (CompositeMap)iterator.next();
                    allFields.put(record.getString((Object)"name"), record);
                }
            }
            return allFields;
        }

        public CompositeMap getFields() {
            return this.mainConfigPage.getFields();
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public void createPageControls(Composite pageContainer) {
        }

        public void refresh(boolean isDirty) {
            try {
                this.fieldPage.repaint();
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
        }

        public int getColumnCount() {
            return this.mainConfigPage.getColumnCount();
        }
    }

    class MainConfigPage
    extends WizardPage {
        public static final String PAGE_NAME = "mainPage";
        private CompositeMap dataSets;
        private String bindTarget;
        private String id;
        private boolean submit;
        private Set idSet;
        private IViewer parentViewer;
        private CompositeMap fields;
        private int columnCount;
        private String type;
        private CompositeMap dataSet;

        protected MainConfigPage(IViewer parent, CompositeMap dataSet) {
            super(PAGE_NAME);
            this.setTitle(String.valueOf(title) + "--" + LocaleMessage.getString("mainpage"));
            this.parentViewer = parent;
            this.dataSet = dataSet;
        }

        public String getType() {
            return this.type;
        }

        public boolean canFlipToNextPage() {
            try {
                this.fields = BMUtil.getFieldsFromDS(this.dataSet);
                if (this.fields == null) {
                    DialogUtil.showErrorMessageBox("\u6b64dataSet\u6ca1\u6709\u53ef\u7528\u5b57\u6bb5.");
                    return false;
                }
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
                return false;
            }
            return super.canFlipToNextPage();
        }

        public void createControl(Composite parent) {
            final Composite content = new Composite(parent, 0);
            content.setLayout((Layout)new GridLayout(4, false));
            GridData gridData = new GridData(768);
            Group dataSetGroup = new Group(content, 0);
            gridData.horizontalSpan = 4;
            dataSetGroup.setLayoutData((Object)gridData);
            dataSetGroup.setText(LocaleMessage.getString("bindtarget"));
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            dataSetGroup.setLayout((Layout)layout);
            final Text bindTargetText = new Text((Composite)dataSetGroup, 0);
            gridData = new GridData(768);
            bindTargetText.setLayoutData((Object)gridData);
            Button browseButton = new Button((Composite)dataSetGroup, 8);
            browseButton.setText(LocaleMessage.getString("openBrowse"));
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        MainConfigPage.this.dataSet = MainConfigPage.this.selectDataSet();
                    }
                    catch (ApplicationException e) {
                        DialogUtil.showExceptionMessageBox(e);
                    }
                    if (MainConfigPage.this.dataSet != null) {
                        bindTargetText.setText(MainConfigPage.this.dataSet.getString((Object)CreateFormFromDataSetAction.idColumn));
                        MainConfigPage.this.parentViewer.refresh(true);
                    }
                }
            });
            Label label = new Label(content, 256);
            label.setText(LocaleMessage.getString("please.input.id"));
            final Text idText = new Text(content, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            idText.setLayoutData((Object)gridData);
            bindTargetText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (bindTargetText.getText() != null && !bindTargetText.getText().equals("")) {
                        MainConfigPage.this.bindTarget = bindTargetText.getText();
                        if (idText.getText() == null || idText.getText().equals("")) {
                            idText.setText(String.valueOf(MainConfigPage.this.bindTarget) + "_form");
                        }
                    }
                    MainConfigPage.this.checkDialog();
                }
            });
            idText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (idText.getText() != null && !idText.getText().equals("")) {
                        MainConfigPage.this.id = idText.getText();
                    }
                    MainConfigPage.this.checkDialog();
                }
            });
            Label columnLabel = new Label(content, 256);
            columnLabel.setText(LocaleMessage.getString("please.input.column.num"));
            final Text columnText = new Text(content, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            columnText.setLayoutData((Object)gridData);
            columnText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (columnText.getText() != null && !columnText.getText().equals("")) {
                        try {
                            MainConfigPage.this.columnCount = Integer.parseInt(columnText.getText());
                        }
                        catch (NumberFormatException e2) {
                            DialogUtil.showErrorMessageBox("please.input.number");
                            columnText.setText("");
                            return;
                        }
                    }
                    MainConfigPage.this.checkDialog();
                    MainConfigPage.this.parentViewer.refresh(true);
                }
            });
            columnText.setText("1");
            final Button submitButton = new Button(content, 32);
            submitButton.setText(LocaleMessage.getString("auto.sumbit.button"));
            Label formTypeLabel = new Label(content, 0);
            final Button queryFormButton = new Button(content, 16);
            final Button sumbitFormButton = new Button(content, 16);
            submitButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (submitButton.getSelection()) {
                        MainConfigPage.this.submit = true;
                        queryFormButton.setEnabled(true);
                        sumbitFormButton.setEnabled(true);
                        content.redraw();
                    } else {
                        MainConfigPage.this.submit = false;
                        queryFormButton.setEnabled(false);
                        sumbitFormButton.setEnabled(false);
                        content.redraw();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            formTypeLabel.setText(LocaleMessage.getString("form.type"));
            sumbitFormButton.setText(LocaleMessage.getString("save"));
            sumbitFormButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (sumbitFormButton.getSelection()) {
                        MainConfigPage.this.type = "save";
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            queryFormButton.setText(LocaleMessage.getString("query"));
            queryFormButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (queryFormButton.getSelection()) {
                        MainConfigPage.this.type = "query";
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            queryFormButton.setSelection(true);
            this.type = "query";
            queryFormButton.setEnabled(false);
            sumbitFormButton.setEnabled(false);
            this.setControl((Control)content);
            bindTargetText.setText(this.dataSet.getString((Object)CreateFormFromDataSetAction.idColumn));
        }

        public CompositeMap getFields() {
            return this.fields;
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public boolean isCreateButton() {
            return this.submit;
        }

        private CompositeMap selectDataSet() throws ApplicationException {
            if (this.dataSets == null) {
                CompositeMap view = this.dataSet.getParent().getParent();
                this.dataSets = this.getQualifyDataSetList(view);
                if (this.dataSets == null || this.dataSets.getChildsNotNull().size() == 0) {
                    DialogUtil.showErrorMessageBox("no.dataSet.available");
                    return null;
                }
            }
            String[] columnProperties = new String[]{CreateFormFromDataSetAction.idColumn, CreateFormFromDataSetAction.modelColumn};
            GridViewer grid = new GridViewer(this.dataSets, columnProperties, 0);
            grid.setFilterColumn(CreateFormFromDataSetAction.idColumn);
            GridDialog dialog = new GridDialog(new Shell(), grid);
            if (dialog.open() == 0) {
                return dialog.getSelected();
            }
            return null;
        }

        private CompositeMap getQualifyDataSetList(CompositeMap parentCM) throws ApplicationException {
            CompositeMap dataSets = parentCM.getChild("dataSets");
            if (dataSets == null || dataSets.getChildsNotNull().size() == 0) {
                return null;
            }
            CommentCompositeMap qualifyDataSetList = new CommentCompositeMap(dataSets.getPrefix(), dataSets.getNamespaceURI(), "dataSets");
            for (CompositeMap child : dataSets.getChildsNotNull()) {
                String id = child.getString((Object)CreateFormFromDataSetAction.idColumn);
                if (id == null || "".equals(id) || BMUtil.getFieldsFromDS(child) == null) continue;
                qualifyDataSetList.addChild(child);
            }
            return qualifyDataSetList;
        }

        public String getId() {
            return this.id;
        }

        public CompositeMap getDataSet() {
            return this.dataSet;
        }

        private String outputErrorMessage() {
            if (this.idSet == null) {
                this.idSet = new HashSet();
                CompositeMapUtil.collectAttribueValues(this.idSet, CreateFormFromDataSetAction.idColumn, this.dataSet.getRoot());
            }
            if (this.bindTarget == null || this.bindTarget.equals("")) {
                return LocaleMessage.getString("DataSet.selection.can.not.be.null");
            }
            if (this.id == null || this.id.equals("")) {
                return LocaleMessage.getString("id.can.not.be.null");
            }
            if (this.idSet.contains(this.id)) {
                return LocaleMessage.getString("This.id.has.exists.please.change.it");
            }
            return null;
        }

        private void checkDialog() {
            String errorMessage = this.outputErrorMessage();
            this.setErrorMessage(errorMessage);
            if (errorMessage != null) {
                this.setPageComplete(false);
            } else {
                this.setPageComplete(true);
            }
        }
    }
}

