/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.component.wizard;

import aurora.ide.component.wizard.BMSelectionPage;
import aurora.ide.component.wizard.LoopupCodePage;
import aurora.ide.component.wizard.ManualDataSetPage;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.LocaleMessage;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;

public class DataSetWizard
extends Wizard {
    private CompositeMap currentNode;
    private QualifiedName childQN = new QualifiedName("http://www.aurora-framework.org/application", "dataSet");
    private final String loadDataColumn = "loadData";
    private String bmFiles;
    private NavigationPage navigationPage;
    private String nextPageName;
    static final String spliteStr = ",";

    public DataSetWizard(CompositeMap currentNode) {
        this.currentNode = currentNode;
        String prefix = CompositeMapUtil.getContextPrefix(currentNode, this.childQN);
        this.childQN.setPrefix(prefix);
    }

    public DataSetWizard(CompositeMap currentNode, String bmFiles) {
        this.currentNode = currentNode;
        String prefix = CompositeMapUtil.getContextPrefix(currentNode, this.childQN);
        this.childQN.setPrefix(prefix);
        this.bmFiles = bmFiles;
    }

    public void addPages() {
        if (this.bmFiles != null) {
            BMSelectionPage bmSelectionPage = new BMSelectionPage();
            bmSelectionPage.setSelection(this.bmFiles);
            this.nextPageName = "CreateDataSetFromBMPage";
            this.addPage((IWizardPage)bmSelectionPage);
        } else {
            this.navigationPage = new NavigationPage();
            this.navigationPage.setPageComplete(false);
            this.addPage((IWizardPage)this.navigationPage);
            this.setForcePreviousAndNextButtons(true);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if ("NavigationPage".equals(page.getName())) {
            WizardPage oldPage;
            if (this.nextPageName != null && (oldPage = (WizardPage)this.getPage(this.nextPageName)) != null) {
                oldPage.setPageComplete(true);
            }
            this.nextPageName = this.navigationPage.getNextPageName();
            WizardPage newPage = (WizardPage)this.getPage(this.nextPageName);
            if (newPage != null) {
                newPage.setPageComplete(false);
                return newPage;
            }
            if ("LookupCodePage".equals(this.nextPageName)) {
                newPage = new LoopupCodePage();
            } else if ("ManualDataSet".equals(this.nextPageName)) {
                newPage = new ManualDataSetPage(this.currentNode);
            } else if ("CreateDataSetFromBMPage".equals(this.nextPageName)) {
                newPage = new BMSelectionPage();
            }
            newPage.setPageComplete(false);
            this.addPage((IWizardPage)newPage);
            return newPage;
        }
        return null;
    }

    public void createPageControls(Composite pageContainer) {
    }

    public boolean performFinish() {
        HashSet ids = new HashSet();
        CompositeMapUtil.collectAttribueValues(ids, "id", this.currentNode.getRoot());
        WizardPage nextPage = (WizardPage)this.getPage(this.nextPageName);
        if ("LookupCodePage".equals(this.nextPageName)) {
            LoopupCodePage loopupCodePage = (LoopupCodePage)nextPage;
            CompositeMap child = CompositeMapUtil.addElement(this.currentNode, this.childQN);
            String loopupCode = loopupCodePage.getLookUpCode();
            child.put((Object)"loopupCode", (Object)loopupCodePage.getLookUpCode());
            child.put((Object)"id", (Object)this.getId(ids, loopupCode));
            return true;
        }
        if ("ManualDataSet".equals(this.nextPageName)) {
            ManualDataSetPage manualDataSetPage = (ManualDataSetPage)nextPage;
            CompositeMap child = CompositeMapUtil.addElement(this.currentNode, this.childQN);
            child.put((Object)"id", (Object)manualDataSetPage.getId());
            return true;
        }
        if ("CreateDataSetFromBMPage".equals(this.nextPageName)) {
            BMSelectionPage bmSelectionPage = (BMSelectionPage)nextPage;
            String[] names = bmSelectionPage.getSelection().split(spliteStr);
            int i = 0;
            while (i < names.length) {
                CompositeMap child = CompositeMapUtil.addElement(this.currentNode, this.childQN);
                this.configCompositeMap(child, names[i], bmSelectionPage.getJustForInput(), bmSelectionPage.getFromServer(), bmSelectionPage.getCanSave(), ids);
                ++i;
            }
        }
        return true;
    }

    public void configCompositeMap(CompositeMap data, String bmName, boolean justForInput, boolean fromServer, boolean canSave, Set ids) {
        String fileName = bmName.substring(bmName.lastIndexOf(".") + 1);
        data.put((Object)"model", (Object)bmName);
        data.put((Object)"id", (Object)this.getId(ids, fileName));
        if (justForInput) {
            data.put((Object)"canQuery", (Object)"false");
            data.put((Object)"canSubmit", (Object)"false");
            return;
        }
        if (fromServer) {
            data.put((Object)"canQuery", (Object)"true");
            data.put((Object)"loadData", (Object)"true");
        }
        if (canSave) {
            data.put((Object)"canSubmit", (Object)"true");
        }
    }

    public String getId(Set list, String bmName) {
        String suggestId = String.valueOf(bmName) + "_ds";
        int i = 1;
        while (list.contains(suggestId)) {
            suggestId = String.valueOf(bmName) + "_ds" + i;
            ++i;
        }
        list.add(suggestId);
        return suggestId;
    }

    class NavigationPage
    extends WizardPage {
        public static final String PAGE_NAME = "NavigationPage";
        private String nextPageName;

        protected NavigationPage() {
            super(PAGE_NAME);
            this.setTitle(LocaleMessage.getString("create.dataset.page"));
        }

        public void createControl(Composite parent) {
            Composite content = new Composite(parent, 0);
            content.setLayout((Layout)new GridLayout());
            final Button lookup = new Button(content, 16);
            lookup.setText(LocaleMessage.getString("create.lookup"));
            lookup.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (lookup.getSelection()) {
                        NavigationPage.this.nextPageName = "LookupCodePage";
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            final Button manual = new Button(content, 16);
            manual.setText(LocaleMessage.getString("manual.creation"));
            manual.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (manual.getSelection()) {
                        NavigationPage.this.nextPageName = "ManualDataSet";
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            final Button fromBM = new Button(content, 16);
            fromBM.setText(LocaleMessage.getString("create.from.bm.file"));
            fromBM.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (fromBM.getSelection()) {
                        NavigationPage.this.nextPageName = "CreateDataSetFromBMPage";
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.nextPageName = "ManualDataSet";
            this.getWizard().getNextPage((IWizardPage)this);
            this.setPageComplete(true);
            this.setControl((Control)content);
        }

        public String getNextPageName() {
            return this.nextPageName;
        }

        public IWizardPage getNextPage() {
            return this.getWizard().getNextPage((IWizardPage)this);
        }
    }
}

