/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlineTree {
    private OutlineTree parent;
    private String text;
    private String other;
    private IRegion startRegion;
    private IRegion endRegion;
    private IRegion region;
    private String image;
    private List<OutlineTree> children = new ArrayList<OutlineTree>();

    public int getChildrenCount() {
        return this.children.size();
    }

    public OutlineTree getParent() {
        return this.parent;
    }

    public List<OutlineTree> getChildren() {
        return this.children;
    }

    public void add(OutlineTree lt) {
        if (lt == null) {
            return;
        }
        lt.parent = this;
        this.children.add(lt);
    }

    public void add(int index, OutlineTree lt) {
        if (lt == null) {
            return;
        }
        lt.parent = this;
        this.children.add(index, lt);
    }

    public void removeAll() {
        this.children.clear();
    }

    public boolean remove(OutlineTree lt) {
        return this.children.remove(lt);
    }

    public OutlineTree remove(int index) {
        OutlineTree t = null;
        if (index < this.children.size() && index >= 0) {
            t = this.children.remove(index);
        }
        return t;
    }

    public OutlineTree getChild(int index) {
        if (index < 0 || index >= this.children.size()) {
            return null;
        }
        return this.children.get(index);
    }

    public boolean equals(Object t) {
        if (t instanceof OutlineTree) {
            OutlineTree ot = (OutlineTree)t;
            return this.eq(ot.startRegion, this.startRegion) && this.eq(ot.endRegion, this.endRegion) && this.eq(ot.text, this.text) && this.eq(ot.other, this.other) && this.eq(ot.region, this.region);
        }
        return false;
    }

    private boolean eq(Object o1, Object o2) {
        if (o1 == null) {
            return o1 == o2;
        }
        return o1.equals(o2);
    }

    public OutlineTree getRoot() {
        return this.getRoot(this);
    }

    private OutlineTree getRoot(OutlineTree lt) {
        if (lt == null) {
            return null;
        }
        if (lt.getParent() == null) {
            return lt;
        }
        return this.getRoot(lt.getParent());
    }

    public void copy(OutlineTree lt) {
        if (lt == null) {
            return;
        }
        this.startRegion = lt.startRegion;
        this.endRegion = lt.endRegion;
        this.text = lt.text;
        this.other = lt.other;
        this.region = lt.region;
    }

    public String toString() {
        return String.valueOf(this.text) + " " + this.other;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public IRegion getStartRegion() {
        return this.startRegion;
    }

    public void setStartRegion(IRegion startRegion) {
        this.startRegion = startRegion;
    }

    public IRegion getEndRegion() {
        return this.endRegion;
    }

    public void setEndRegion(IRegion endRegion) {
        this.endRegion = endRegion;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setParent(OutlineTree parent) {
        this.parent = parent;
    }

    public IRegion getRegion() {
        return this.region;
    }

    public void setRegion(IRegion region) {
        this.region = region;
    }

    public String getOther() {
        return this.other;
    }

    public void setOther(String other) {
        this.other = other;
    }
}

