/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage;

import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.editor.core.IViewer;
import aurora.ide.editor.outline.TextOutlinePage;
import aurora.ide.editor.textpage.ColorManager;
import aurora.ide.editor.textpage.XMLConfiguration;
import aurora.ide.editor.textpage.XMLDocumentProvider;
import aurora.ide.editor.textpage.action.CFormatAction;
import aurora.ide.editor.textpage.action.ExportFunctionSQLAction;
import aurora.ide.editor.textpage.action.GetFileNameAction;
import aurora.ide.editor.textpage.action.ToggleBlockCommentAction;
import aurora.ide.editor.textpage.action.ToggleCommentAction;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.refactoring.ui.action.ShowPromptsViewAction;
import aurora.ide.refactoring.ui.action.SynDBAction;
import java.io.File;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerRulerAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import uncertain.composite.CompositeMap;

public class TextPage
extends TextEditor
implements IViewer {
    public static final String EDITOR_ID = "aurora.ide.editor.textpage";
    public static final String EDITOR_CONTEXT = "aurora.ide.editor.textpage.context";
    public static final String RULER_CONTEXT = "aurora.ide.editor.textpage.context.ruler";
    public static final String textPageId = "textPage";
    public static final String textPageTitle = LocaleMessage.getString("source.file");
    private boolean syc = false;
    private ColorManager colorManager;
    private FormEditor editor;
    private boolean modify = false;
    private boolean ignorceSycOnce = false;
    private IAnnotationModel annotationModel;
    private TextOutlinePage outline;

    public TextPage() {
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId(EDITOR_CONTEXT);
        this.setRulerContextMenuId(RULER_CONTEXT);
    }

    public Object getAdapter(Class adapter) {
        if (Display.getCurrent() != null && IAnnotationModel.class.equals((Object)adapter)) {
            return this.getAnnotationModel();
        }
        if (adapter == IContentOutlinePage.class) {
            this.outline = new TextOutlinePage((IEditorPart)this);
            return this.outline;
        }
        if (adapter == StyledText.class) {
            StyledText textWidget = this.getSourceViewer().getTextWidget();
            return textWidget;
        }
        if (adapter == IDocument.class) {
            IDocument document = this.getSourceViewer().getDocument();
            return document;
        }
        return super.getAdapter(adapter);
    }

    public boolean isIgnorceSycOnce() {
        return this.ignorceSycOnce;
    }

    private IAnnotationModel getAnnotationModel() {
        if (this.annotationModel != null) {
            return this.annotationModel;
        }
        this.annotationModel = this.getDocumentProvider().getAnnotationModel((Object)this.getInput());
        if (this.annotationModel == null) {
            this.annotationModel = new AnnotationModel();
            this.annotationModel.connect(this.getInputDocument());
        }
        return this.annotationModel;
    }

    public void setIgnorceSycOnce(boolean ignorceSycOnce) {
        this.ignorceSycOnce = ignorceSycOnce;
    }

    public TextPage(FormEditor editor, String id, String title) {
        this.editor = editor;
        this.setPartName(title);
        this.setContentDescription(title);
        this.colorManager = new ColorManager();
        this.setSourceViewerConfiguration(new XMLConfiguration(this.colorManager));
        this.setDocumentProvider((IDocumentProvider)new XMLDocumentProvider());
    }

    public TextPage(FormEditor editor) {
        this(editor, textPageId, textPageTitle);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getInputDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                if (TextPage.this.syc) {
                    TextPage.this.syc = false;
                    return;
                }
                TextPage.this.refresh(true);
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        ProjectionSupport projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        projectionSupport.install();
        viewer.doOperation(19);
    }

    public void refresh(boolean dirty) {
        if (dirty) {
            this.getEditor().editorDirtyStateChanged();
            this.setModify(true);
        }
    }

    private FormEditor getEditor() {
        return this.editor;
    }

    public void refresh(String newContent) {
        if (!newContent.equals(this.getSourceViewer().getTextWidget().getText())) {
            this.syc = true;
            this.getSourceViewer().getTextWidget().setText(newContent);
        }
    }

    public void setSyc(boolean isSyc) {
        this.syc = isSyc;
    }

    public String getContent() {
        return this.getDocument().get();
    }

    public IDocument getDocument() {
        return this.getSourceViewer().getDocument();
    }

    public boolean canLeaveThePage() {
        return this.checkContentFormat();
    }

    public boolean checkContentFormat() {
        try {
            this.toCompoisteMap();
        }
        catch (ApplicationException e) {
            return false;
        }
        return true;
    }

    public CompositeMap toCompoisteMap() throws ApplicationException {
        return CompositeMapUtil.loaderFromString(this.getContent());
    }

    public int getCursorLine() {
        return this.getSourceViewer().getTextWidget().getLineAtOffset(this.getSourceViewer().getSelectedRange().x);
    }

    public Point getSelectedRange() {
        return this.getSourceViewer().getSelectedRange();
    }

    public IFile getFile() {
        if (!(this.getEditor().getEditorInput() instanceof IFileEditorInput)) {
            return null;
        }
        IFileEditorInput editorInput = (IFileEditorInput)this.getEditor().getEditorInput();
        IFile ifile = editorInput.getFile();
        return ifile;
    }

    public int getOffsetFromLine(int lineNumber) {
        int offset = 0;
        if (lineNumber < 0) {
            return offset;
        }
        try {
            offset = this.getInputDocument().getLineOffset(lineNumber);
            if (offset >= this.getInputDocument().getLength()) {
                return this.getOffsetFromLine(lineNumber - 1);
            }
        }
        catch (BadLocationException e) {
            return this.getOffsetFromLine(lineNumber - 1);
        }
        return offset;
    }

    public int getLineOfOffset(int offset) {
        try {
            return this.getInputDocument().getLineOfOffset(offset);
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    public int getLengthOfLine(int lineNumber) {
        int length = 0;
        if (lineNumber < 0) {
            return length;
        }
        try {
            length = this.getInputDocument().getLineLength(lineNumber);
        }
        catch (BadLocationException e) {
            try {
                length = this.getInputDocument().getLineLength(lineNumber - 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return length;
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    public IDocument getInputDocument() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getInput());
        return document;
    }

    public IEditorInput getInput() {
        return this.getEditorInput();
    }

    public boolean isModify() {
        return this.modify;
    }

    public void setModify(boolean modify) {
        this.modify = modify;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        viewer.getTextWidget().addCaretListener(new CaretListener(){

            public void caretMoved(CaretEvent event) {
                if (TextPage.this.outline != null) {
                    TextPage.this.outline.selectNode(event.caretOffset);
                }
            }
        });
        return viewer;
    }

    protected void createActions() {
        super.createActions();
        MarkerRulerAction action = new MarkerRulerAction(ResourceBundle.getBundle("org.eclipse.ui.texteditor.ConstructedTextEditorMessages"), "Editor.ManageBookmarks.", (ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler(), "org.eclipse.core.resources.bookmark", true);
        this.setAction("RulerDoubleClick", (IAction)action);
        this.setAction("format", (IAction)new CFormatAction());
        this.setAction("linecomment", (IAction)new ToggleCommentAction());
        this.setAction("blockcomment", (IAction)new ToggleBlockCommentAction());
        GetFileNameAction action2 = new GetFileNameAction();
        action2.setActiveEditor(null, (IEditorPart)this);
        this.setAction("copyFileName", (IAction)action2);
        this.setAction("ExportFunctionSQLAction", (IAction)new ExportFunctionSQLAction(this));
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            IFile ifile = ((IFileEditorInput)this.getEditorInput()).getFile();
            File file = new File(AuroraResourceUtil.getIfileLocalPath(ifile));
            CommentXMLOutputter.saveToFile(file, CompositeMapUtil.loaderFromString(this.getContent()));
            ifile.refreshLocal(0, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.appendToGroup("group.rest", (IAction)new ShowPromptsViewAction(this));
        if ("bm".equalsIgnoreCase(this.getFile().getFileExtension())) {
            menu.appendToGroup("group.rest", (IAction)new SynDBAction(this));
        }
    }

    protected void initializeDragAndDrop(ISourceViewer viewer) {
        super.initializeDragAndDrop(viewer);
    }
}

