/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage;

import aurora.ide.editor.textpage.IReconcileListener;
import aurora.ide.editor.textpage.xml.validate.XMLErrorHandler;
import aurora.ide.editor.textpage.xml.validate.XMLValidator;
import aurora.ide.helpers.ExceptionUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlErrorReconcile
implements IReconcileListener {
    public static final String AnnotationType = "aurora.ide.text.valid";
    private List xmlErrorAnnotatioList = new LinkedList();
    private IAnnotationModel xmlErrorAnnotationModel;
    private ISourceViewer sourceViewer;

    public XmlErrorReconcile(ISourceViewer sourceViewer) {
        this.setSourceViewer(sourceViewer);
    }

    public void reconcile() {
        this.xmlErrorAnnotationModel = this.getAnnotationModel();
        this.clearHistory();
        XMLValidator va = new XMLValidator(new XMLErrorHandler(){

            public void warning(SAXParseException exception) throws SAXException {
                XmlErrorReconcile.this.updateAnnotation(exception);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                XmlErrorReconcile.this.updateAnnotation(exception);
            }

            public void configurationError(Exception e) {
                if (e instanceof SAXParseException) {
                    XmlErrorReconcile.this.updateAnnotation((SAXParseException)e);
                }
            }
        });
        String xml = this.getSourceViewer().getDocument().get();
        va.validate(xml);
    }

    private IAnnotationModel getAnnotationModel() {
        if (this.xmlErrorAnnotationModel != null) {
            return this.xmlErrorAnnotationModel;
        }
        this.xmlErrorAnnotationModel = this.getSourceViewer().getAnnotationModel();
        if (this.xmlErrorAnnotationModel == null) {
            this.xmlErrorAnnotationModel = new AnnotationModel();
            this.xmlErrorAnnotationModel.connect(this.getSourceViewer().getDocument());
        }
        return this.xmlErrorAnnotationModel;
    }

    private void clearHistory() {
        Iterator it = this.xmlErrorAnnotatioList.iterator();
        while (it.hasNext()) {
            this.xmlErrorAnnotationModel.removeAnnotation((Annotation)it.next());
        }
        this.xmlErrorAnnotatioList.clear();
    }

    private void updateAnnotation(SAXParseException e) {
        Throwable rootCause = ExceptionUtil.getRootCause(e);
        if (rootCause == null || !(rootCause instanceof SAXParseException)) {
            return;
        }
        SAXParseException parseEx = e;
        String errorMessage = ExceptionUtil.getExceptionTraceMessage(e);
        int lineNum = parseEx.getLineNumber() - 1;
        int lineOffset = this.getOffsetFromLine(lineNum);
        int lineLength = Math.max(this.getLengthOfLine(lineNum), 1);
        Position pos = new Position(lineOffset, lineLength);
        Annotation annotation = new Annotation(AnnotationType, false, errorMessage);
        this.xmlErrorAnnotationModel.addAnnotation(annotation, pos);
        this.xmlErrorAnnotatioList.add(annotation);
    }

    public int getOffsetFromLine(int lineNumber) {
        int offset = 0;
        if (lineNumber < 0) {
            return offset;
        }
        try {
            offset = this.getSourceViewer().getDocument().getLineOffset(lineNumber);
            if (offset >= this.getSourceViewer().getDocument().getLength()) {
                return this.getOffsetFromLine(lineNumber - 1);
            }
        }
        catch (BadLocationException e) {
            return this.getOffsetFromLine(lineNumber - 1);
        }
        return offset;
    }

    public int getLengthOfLine(int lineNumber) {
        int length = 0;
        if (lineNumber < 0) {
            return length;
        }
        try {
            length = this.getSourceViewer().getDocument().getLineLength(lineNumber);
        }
        catch (BadLocationException e) {
            try {
                length = this.getSourceViewer().getDocument().getLineLength(lineNumber - 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return length;
    }

    public ISourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public void setSourceViewer(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }
}

