/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.action;

import aurora.ide.AuroraPlugin;
import aurora.ide.editor.editorInput.StringEditorInput;
import aurora.ide.editor.textpage.action.RegisterSql;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.PathUtil;
import aurora.ide.helpers.StringUtil;
import aurora.ide.javascript.Javascript4Rhino;
import aurora.ide.search.cache.CacheManager;
import aurora.ide.search.core.AbstractSearchService;
import aurora.ide.search.reference.MapFinderResult;
import aurora.ide.search.reference.MultiReferenceTypeFinder;
import aurora.ide.search.reference.NamedMapFinder;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.mozilla.javascript.ast.StringLiteral;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeMap;
import uncertain.composite.IterationHandle;
import uncertain.schema.Attribute;

public class FunctionRegisterWizard
extends Wizard {
    private static final String DEFAULT_FUNCTION_ORDER = "10";
    private WizardPage settingPage = new WizardPage(""){

        public void createControl(Composite parent) {
            parent.setLayout((Layout)new GridLayout());
            final Text m_code = this.createTextField(parent, "\u6a21\u5757Code", FunctionRegisterWizard.this.getModulesCode());
            m_code.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FunctionRegisterWizard.this.setModulesCode(m_code.getText());
                }
            });
            final Text m_name = this.createTextField(parent, "\u6a21\u5757Name", FunctionRegisterWizard.this.getModulesName());
            m_name.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FunctionRegisterWizard.this.setModulesName(m_name.getText());
                }
            });
            Label label = new Label(parent, 258);
            label.setLayoutData((Object)new GridData(768));
            final Text f_code = this.createTextField(parent, "\u529f\u80fdCode", FunctionRegisterWizard.this.getFunctionCode());
            f_code.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FunctionRegisterWizard.this.setFunctionCode(f_code.getText());
                }
            });
            final Text f_name = this.createTextField(parent, "\u529f\u80fdName", FunctionRegisterWizard.this.getFunctionName());
            f_name.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FunctionRegisterWizard.this.setFunctionName(f_name.getText());
                }
            });
            final Text f_order = this.createTextField(parent, "\u529f\u80fdOrder", FunctionRegisterWizard.this.getFunctionOrder());
            f_order.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FunctionRegisterWizard.this.setFunctionOrder(f_order.getText());
                }
            });
            this.setControl((Control)parent);
            this.setPageComplete(true);
        }

        private Text createTextField(Composite parent, String text, String defaultValue) {
            Composite c = new Composite(parent, 0);
            c.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            c.setLayout((Layout)layout);
            Label l = new Label(c, 0);
            l.setText(text);
            Text t = new Text(c, 2048);
            t.setText(defaultValue);
            t.setLayoutData((Object)new GridData(768));
            return t;
        }
    };
    private IFile hostPage;
    private String functionCode;
    private String functionName;
    private String functionOrder;
    private String modulesCode;
    private String modulesName;
    private List<IFile> files;

    public String getFunctionCode() {
        if (this.functionCode != null) {
            return this.functionCode.toUpperCase();
        }
        return "";
    }

    public void setFunctionCode(String functionCode) {
        this.functionCode = functionCode;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionOrder() {
        return this.functionOrder;
    }

    public void setFunctionOrder(String functionOrder) {
        this.functionOrder = functionOrder;
    }

    public String getModulesCode() {
        if (this.modulesCode != null) {
            return this.modulesCode.toUpperCase();
        }
        return "";
    }

    public void setModulesCode(String modulesCode) {
        this.modulesCode = modulesCode;
    }

    public String getModulesName() {
        return this.modulesName;
    }

    public void setModulesName(String modulesName) {
        this.modulesName = modulesName;
    }

    public IFile getHostPage() {
        return this.hostPage;
    }

    public void setHostPage(IFile hostPage) {
        this.hostPage = hostPage;
    }

    public FunctionRegisterWizard(IFile hostPage) {
        this.setNeedsProgressMonitor(false);
        this.setHelpAvailable(false);
        this.setWindowTitle("\u5bfc\u51fa");
        this.hostPage = hostPage;
        this.setDialogSettings(AuroraPlugin.getDefault().getDialogSettingsSection("FunctionRegisterWizard"));
        this.setFunctionCode(this.getDefaultFunctionCode());
        this.setFunctionName(this.getDefaultFunctionName());
        this.setFunctionOrder(this.getDefaultFunctionOrder());
        this.setModulesCode(this.getDefaultModuleCode());
        this.setModulesName(this.getDefaultModuleName());
    }

    private String getDefaultFunctionOrder() {
        int length;
        String functionCode = this.getFunctionCode();
        if (!StringUtil.isBlank(functionCode) && (length = functionCode.length()) - 4 > 0) {
            String substring = functionCode.substring(length - 4);
            try {
                Integer integer = Integer.valueOf(substring);
                return String.valueOf(integer);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return DEFAULT_FUNCTION_ORDER;
    }

    private String getDefaultModuleName() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        String modulesCode = this.getModulesCode();
        if (!StringUtil.isBlank(modulesCode)) {
            String string = dialogSettings.get(modulesCode);
            return StringUtil.isBlank(string) ? modulesCode : string;
        }
        return modulesCode;
    }

    private String getDefaultFunctionName() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        String functionCode = this.getFunctionCode();
        if (!StringUtil.isBlank(functionCode)) {
            String string = dialogSettings.get(functionCode);
            return StringUtil.isBlank(string) ? functionCode : string;
        }
        return functionCode;
    }

    private String getDefaultModuleCode() {
        if (this.hostPage != null) {
            return this.hostPage.getParent().getParent().getName();
        }
        return "NONE";
    }

    private String getDefaultFunctionCode() {
        if (this.hostPage != null) {
            return this.hostPage.getParent().getName();
        }
        return "NONE";
    }

    public void addPages() {
        this.settingPage.setDescription("\u5c06\u5f53\u524d\u6587\u4ef6\u5173\u8054\u7684screen\uff0csvc\uff0cbm\u6587\u4ef6\u6574\u7406\uff0c\u5bfc\u51fa\u4e3a\u529f\u80fd\u6ce8\u518c\u811a\u672c");
        this.settingPage.setTitle("\u5bfc\u51fa\u529f\u80fd\u6ce8\u518c\u811a\u672c");
        this.addPage((IWizardPage)this.settingPage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        if (this.hostPage == null) {
            return false;
        }
        try {
            IDialogSettings dialogSettings = this.getDialogSettings();
            dialogSettings.put(this.getFunctionCode(), this.getFunctionName());
            dialogSettings.put(this.getModulesCode(), this.getModulesName());
            this.files = new ArrayList<IFile>();
            this.files.add(this.hostPage);
            this.fetchAll(this.hostPage);
            String exportSql = null;
            try {
                exportSql = this.toExportSql();
            }
            catch (IOException e) {
                this.settingPage.setErrorMessage("\u627e\u4e0d\u5230\u6478\u7248");
                e.printStackTrace();
                return false;
            }
            catch (SAXException e) {
                this.settingPage.setErrorMessage("\u627e\u4e0d\u5230\u6478\u7248");
                e.printStackTrace();
                return false;
            }
            catch (TemplateException e) {
                this.settingPage.setErrorMessage("\u627e\u4e0d\u5230\u6478\u7248");
                e.printStackTrace();
                return false;
            }
            IDE.openEditor((IWorkbenchPage)AuroraPlugin.getActivePage(), (IEditorInput)new StringEditorInput(exportSql, "utf-8"), (String)"org.eclipse.ui.DefaultTextEditor");
            return true;
        }
        catch (CoreException e) {
            DialogUtil.logErrorException(e);
            e.printStackTrace();
            return false;
        }
        catch (ApplicationException e) {
            DialogUtil.logErrorException(e);
            e.printStackTrace();
            return false;
        }
    }

    private String toExportSql() throws IOException, SAXException, TemplateException {
        RegisterSql rsql = new RegisterSql(this.getFunctionCode(), this.getFunctionName(), this.getFunctionOrder(), this.getModulesCode(), this.getModulesName(), this.hostPage);
        return rsql.build(this.files);
    }

    private void fetchAll(IFile host) throws CoreException, ApplicationException {
        if (PathUtil.isAuroraFile(host)) {
            CompositeMap hostMap = CacheManager.getCompositeMap(host);
            this.iterateAttribute(host, hostMap);
            this.iterateScript(host, hostMap);
        }
    }

    private void iterateScript(IFile host, CompositeMap hostMap) throws CoreException, ApplicationException {
        if (!"screen".equalsIgnoreCase(host.getFileExtension())) {
            return;
        }
        NamedMapFinder nmf = new NamedMapFinder("script");
        hostMap.iterate((IterationHandle)nmf, false);
        List<MapFinderResult> r = nmf.getResult();
        for (MapFinderResult result : r) {
            CompositeMap map = result.getMap();
            if (!"script".equalsIgnoreCase(map.getName()) || map.getText() == null) continue;
            Javascript4Rhino e = new Javascript4Rhino(host, map);
            List<StringLiteral> stringLiteral = e.getStringLiteralNodes((IProgressMonitor)new NullProgressMonitor());
            for (StringLiteral sl : stringLiteral) {
                String value = e.getLiteralValue(sl);
                this.found(host, value);
            }
        }
    }

    private void iterateAttribute(IFile host, CompositeMap hostMap) throws CoreException, ApplicationException {
        MultiReferenceTypeFinder mrtf = new MultiReferenceTypeFinder(AbstractSearchService.bmReference).addReferenceType(AbstractSearchService.screenReference).addReferenceType(AbstractSearchService.urlReference);
        hostMap.iterate((IterationHandle)mrtf, true);
        List<MapFinderResult> results = mrtf.getResult();
        for (MapFinderResult r : results) {
            List<Attribute> attributes = r.getAttributes();
            for (Attribute attribute : attributes) {
                String value = CompositeMapUtil.getValueIgnoreCase(attribute, r.getMap());
                if (value == null || "".equals(value)) continue;
                this.found(host, value);
            }
        }
    }

    private IFile found(IFile host, String value) throws CoreException, ApplicationException {
        IFile findFile = PathUtil.findFile(host, value);
        if (findFile != null && findFile.exists() && !this.files.contains(findFile)) {
            this.files.add(findFile);
            if (!"bm".equals(findFile.getFileExtension().toLowerCase())) {
                this.fetchAll(findFile);
            }
        }
        return findFile;
    }
}

