/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.contentassist;

import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.editor.textpage.contentassist.IContentAssistStrategy;
import aurora.ide.editor.textpage.contentassist.TokenString;
import aurora.ide.editor.textpage.scanners.XMLTagScanner;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapLocatorParser;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.ImagesUtils;
import aurora.ide.helpers.SystemException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Image;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeMap;
import uncertain.schema.Attribute;
import uncertain.schema.Element;

public class AttributeStrategy
implements IContentAssistStrategy {
    private XMLTagScanner scanner;
    private TokenString tokenString;
    private ITextViewer viewer;
    private int cursorOffset;
    private IDocument document;

    public AttributeStrategy(XMLTagScanner scanner) {
        this.scanner = scanner;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int cursorOffset) throws BadLocationException {
        this.viewer = viewer;
        this.cursorOffset = cursorOffset;
        this.document = viewer.getDocument();
        try {
            this.tokenString = this.createTokenString();
            if (this.tokenString == null) {
                return null;
            }
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
            return null;
        }
        String content = this.document.get();
        CompositeMap parentCompositeMap = null;
        try {
            parentCompositeMap = this.locateCompositeMap(content, cursorOffset);
            if (parentCompositeMap != null) {
                if (this.tokenString.getLength() == 0) {
                    return this.computeNewAttr(parentCompositeMap);
                }
                return this.computeUpdateAttr(parentCompositeMap);
            }
        }
        catch (ApplicationException e) {
            String originalContent = this.document.get();
            String changedContent = String.valueOf(originalContent.substring(0, this.tokenString.getDocumentOffset())) + originalContent.substring(this.tokenString.getDocumentOffset() + this.tokenString.getLength());
            try {
                parentCompositeMap = this.locateCompositeMap(changedContent, cursorOffset);
                if (parentCompositeMap != null) {
                    return this.computeNewAttr(parentCompositeMap);
                }
            }
            catch (ApplicationException applicationException) {
                // empty catch block
            }
        }
        return this.getDefaultCompletionProposal();
    }

    private ICompletionProposal[] computeUpdateAttr(CompositeMap parentCompositeMap) {
        Element element = CompositeMapUtil.getElement(parentCompositeMap);
        if (element == null) {
            return this.getDefaultCompletionProposal();
        }
        List allAttributes = element.getAllAttributes();
        ArrayList<CompletionProposal> avaliableList = new ArrayList<CompletionProposal>();
        String preString = this.tokenString.getStrBeforeCursor();
        List existsList = null;
        try {
            existsList = this.getExistsAttrs(this.document);
        }
        catch (SystemException e) {
            DialogUtil.showExceptionMessageBox(e);
            return null;
        }
        for (Attribute attr : allAttributes) {
            String name = attr.getName();
            if (existsList.contains(name) || preString != null && !name.startsWith(preString)) continue;
            String attributeDocument = attr.getDocument();
            String description = name;
            String replaceString = name;
            if (attributeDocument != null) {
                description = String.valueOf(this.formateAttributeName(name)) + " - " + attributeDocument;
            }
            avaliableList.add(new CompletionProposal(replaceString, this.tokenString.getDocumentOffset(), this.tokenString.getLength(), replaceString.length() + 2, AttributeStrategy.getDefaultImage(), description, null, attributeDocument));
        }
        int allLength = avaliableList.size();
        if (allLength == 0) {
            return this.getDefaultCompletionProposal();
        }
        ICompletionProposal[] result = new ICompletionProposal[allLength];
        int i = 0;
        Iterator iter = avaliableList.iterator();
        while (iter.hasNext()) {
            result[i] = (CompletionProposal)iter.next();
            ++i;
        }
        return result;
    }

    private ICompletionProposal[] computeNewAttr(CompositeMap parentCompositeMap) {
        Element element = CompositeMapUtil.getElement(parentCompositeMap);
        if (element == null) {
            return this.getDefaultCompletionProposal();
        }
        List allAttributes = element.getAllAttributes();
        ArrayList<CompletionProposal> avaliableList = new ArrayList<CompletionProposal>();
        String preString = this.tokenString.getStrBeforeCursor();
        List existsList = null;
        try {
            existsList = this.getExistsAttrs(this.document);
        }
        catch (SystemException e) {
            DialogUtil.showExceptionMessageBox(e);
            return null;
        }
        for (Attribute attr : allAttributes) {
            String name = attr.getName();
            if (existsList.contains(name) || preString != null && !name.startsWith(preString)) continue;
            String attributeDocument = attr.getDocument();
            String description = name;
            String replaceString = String.valueOf(name) + "=\"\" ";
            if (attributeDocument != null) {
                description = String.valueOf(this.formateAttributeName(name)) + " - " + attributeDocument;
            }
            avaliableList.add(new CompletionProposal(replaceString, this.tokenString.getDocumentOffset(), this.tokenString.getLength(), replaceString.length() - 2, AttributeStrategy.getDefaultImage(), description, null, attributeDocument));
        }
        int allLength = avaliableList.size();
        if (allLength == 0) {
            return this.getDefaultCompletionProposal();
        }
        ICompletionProposal[] result = new ICompletionProposal[allLength];
        int i = 0;
        Iterator iter = avaliableList.iterator();
        while (iter.hasNext()) {
            result[i] = (CompletionProposal)iter.next();
            ++i;
        }
        return result;
    }

    private String formateAttributeName(String attributeName) {
        int defaultLength = 20;
        StringBuffer newAttributeName = new StringBuffer(attributeName);
        int strLength = newAttributeName.length();
        if (strLength < defaultLength) {
            int i = 0;
            while (i < defaultLength - strLength) {
                newAttributeName.append(" ");
                ++i;
            }
        }
        return newAttributeName.toString();
    }

    private List getExistsAttrs(IDocument document) throws SystemException {
        ArrayList<String> existsAttrs = new ArrayList<String>();
        IToken token = null;
        String attributeName = null;
        try {
            ITypedRegion region = document.getPartition(this.cursorOffset);
            int partitionOffset = region.getOffset();
            this.scanner.setRange(document, partitionOffset, region.getLength());
            while ((token = this.scanner.nextToken()) != Token.EOF) {
                TextAttribute text;
                if (!(token.getData() instanceof TextAttribute) || !(text = (TextAttribute)token.getData()).getForeground().getRGB().equals((Object)IColorConstants.ATTRIBUTE) || (attributeName = document.get(this.scanner.getTokenOffset(), this.scanner.getTokenLength())) == null) continue;
                existsAttrs.add(attributeName);
            }
        }
        catch (BadLocationException e) {
            throw new SystemException(e);
        }
        return existsAttrs;
    }

    private ICompletionProposal[] getDefaultCompletionProposal() {
        String text = this.tokenString.getText();
        if (text == null || text.equals("")) {
            return null;
        }
        String replaceString = String.valueOf(this.tokenString.getText()) + "=\"\" ";
        return new ICompletionProposal[]{new CompletionProposal(replaceString, this.tokenString.getDocumentOffset(), this.tokenString.getLength(), text.length() + 1, AttributeStrategy.getDefaultImage(), null, null, null)};
    }

    private static Image getDefaultImage() {
        return ImagesUtils.getImage("contentassit.gif");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TokenString createTokenString() throws ApplicationException {
        IToken token = null;
        try {
            ITypedRegion region = this.document.getPartition(this.cursorOffset);
            int partitionOffset = region.getOffset();
            this.scanner.setRange(this.document, partitionOffset, region.getLength());
            while ((token = this.scanner.nextToken()) != Token.EOF) {
                TextAttribute text;
                if (this.scanner.getTokenOffset() > this.cursorOffset || this.scanner.getTokenOffset() + this.scanner.getTokenLength() < this.cursorOffset || !(token.getData() instanceof TextAttribute) || !(text = (TextAttribute)token.getData()).getForeground().getRGB().equals((Object)IColorConstants.STRING)) continue;
                return null;
            }
        }
        catch (BadLocationException e) {
            throw new SystemException(e);
        }
        TokenString tokenString = null;
        IDocument document = this.viewer.getDocument();
        try {
            ITypedRegion partitionRegion = document.getPartition(this.cursorOffset);
            int attrStart = this.cursorOffset - partitionRegion.getOffset() - 1;
            int attrEnd = this.cursorOffset - partitionRegion.getOffset();
            String partitionText = document.get(partitionRegion.getOffset(), partitionRegion.getLength());
            int partitionLength = partitionRegion.getLength();
            char c = partitionText.charAt(attrStart);
            while (this.beginChar(c, attrStart)) {
                c = partitionText.charAt(--attrStart);
            }
            ++attrStart;
            char beginChar = c;
            c = partitionText.charAt(attrEnd);
            while (this.endChar(c, attrEnd, partitionLength)) {
                c = partitionText.charAt(++attrEnd);
            }
            if (beginChar == '\"') return null;
            if (c == '\"') {
                return null;
            }
            String attrName = partitionText.substring(attrStart, attrEnd);
            return new TokenString(attrName, partitionRegion.getOffset() + attrStart, this.cursorOffset);
        }
        catch (BadLocationException e) {
            throw new SystemException(e);
        }
    }

    private boolean beginChar(char c, int start) {
        return !Character.isWhitespace(c) && c != '<' && start >= 0 && c != '\"';
    }

    private boolean endChar(char c, int end, int partitionLength) {
        return !Character.isWhitespace(c) && c != '>' && c != '/' && c != '=' && c != '<' && end < partitionLength - 1 && c != '\"';
    }

    private CompositeMap locateCompositeMap(String content, int offset) throws ApplicationException {
        try {
            CompositeMapLocatorParser parser = new CompositeMapLocatorParser();
            ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes("UTF-8"));
            CompositeMap cm = parser.getCompositeMapFromLine(is, this.getCursorLine(offset));
            return cm;
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException(e);
        }
        catch (SAXException e) {
            throw new ApplicationException("\u8bf7\u68c0\u67e5\u6b64\u6587\u4ef6\u683c\u5f0f\u662f\u5426\u6b63\u786e.", e);
        }
        catch (IOException e) {
            throw new ApplicationException("\u8bf7\u68c0\u67e5\u6b64\u6587\u4ef6\u683c\u5f0f\u662f\u5426\u6b63\u786e.", e);
        }
    }

    private int getCursorLine(int offset) {
        return this.viewer.getTextWidget().getLineAtOffset(offset);
    }
}

