/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.hyperlinks;

import aurora.ide.editor.textpage.ColorManager;
import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.editor.textpage.hyperlinks.BMFileHyperlink;
import aurora.ide.editor.textpage.hyperlinks.ScreenFileHyperlink;
import aurora.ide.editor.textpage.scanners.XMLTagScanner;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.SystemException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class FileHyperlinkDetector
implements IHyperlinkDetector {
    private XMLTagScanner scanner;
    private static String[] buildinBMNames = new String[]{"model", "extend", "lovservice", "service"};
    private static String[] buildinScreenFile = new String[]{"service", "screen", "svc"};

    public FileHyperlinkDetector() {
        ColorManager colorManager = new ColorManager();
        this.scanner = new XMLTagScanner(colorManager);
        this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(colorManager.getColor(IColorConstants.TAG))));
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String columnName;
        IRegion token;
        block9: {
            IDocument doc;
            block8: {
                doc = textViewer.getDocument();
                token = this.getTokenString(doc, region.getOffset());
                if (token != null) break block8;
                return null;
            }
            String tokenString = doc.get(token.getOffset(), token.getLength());
            int i = 0;
            while (i < buildinScreenFile.length) {
                String extension = "." + buildinScreenFile[i];
                if (tokenString.toLowerCase().endsWith(extension)) {
                    return new IHyperlink[]{new ScreenFileHyperlink(token, textViewer)};
                }
                ++i;
            }
            columnName = this.getColumnName(region.getOffset(), doc);
            if (columnName != null) break block9;
            return null;
        }
        try {
            int i = 0;
            while (i < buildinBMNames.length) {
                String cName = buildinBMNames[i];
                if (columnName.toLowerCase().indexOf(cName) != -1) {
                    return new IHyperlink[]{new BMFileHyperlink(token, textViewer)};
                }
                ++i;
            }
        }
        catch (Exception e) {
            DialogUtil.showExceptionMessageBox(e);
        }
        return null;
    }

    private String getColumnName(int documentOffset, IDocument document) throws SystemException {
        ITypedRegion region;
        String columnName = null;
        try {
            region = document.getPartition(documentOffset);
        }
        catch (BadLocationException e) {
            throw new SystemException(e);
        }
        if (!"XML_START_TAG".equals(region.getType())) {
            return null;
        }
        int partitionOffset = region.getOffset();
        this.scanner.setRange(document, partitionOffset, region.getLength());
        IToken token = null;
        while ((token = this.scanner.nextToken()) != Token.EOF) {
            TextAttribute text;
            int offset = this.scanner.getTokenOffset();
            int length = this.scanner.getTokenLength();
            if (offset <= documentOffset && offset + length >= documentOffset) break;
            if (!(token.getData() instanceof TextAttribute) || !(text = (TextAttribute)token.getData()).getForeground().getRGB().equals((Object)IColorConstants.ATTRIBUTE)) continue;
            try {
                columnName = document.get(this.scanner.getTokenOffset(), this.scanner.getTokenLength());
            }
            catch (BadLocationException e) {
                throw new SystemException(e);
            }
        }
        return columnName;
    }

    private boolean isOK(char c) {
        if (c == '.') {
            return true;
        }
        return Character.isJavaIdentifierPart(c);
    }

    private IRegion getTokenString(IDocument document, int documentOffset) throws BadLocationException {
        ITypedRegion region = document.getPartition(documentOffset);
        int partitionOffset = region.getOffset();
        int partitionLength = region.getLength();
        int index = documentOffset - partitionOffset;
        String partitionText = document.get(partitionOffset, partitionLength);
        int start = index - 1;
        if (start >= 0) {
            char c = partitionText.charAt(start);
            while (this.isOK(c) && start > 0) {
                c = partitionText.charAt(--start);
            }
        }
        ++start;
        int end = index;
        char c = partitionText.charAt(end);
        while (this.isOK(c) && end < partitionLength - 1) {
            c = partitionText.charAt(++end);
        }
        if (end - start == 0) {
            return null;
        }
        Region currentRegion = new Region(partitionOffset + start, end - start);
        return currentRegion;
    }
}

