/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.js.validate;

import aurora.ide.editor.textpage.js.validate.AnnotationReporter;
import aurora.ide.editor.textpage.js.validate.JavascriptValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.editors.text.TextEditor;

public class JavascriptDocumentListener
implements IDocumentListener {
    private static final String SCRIPT = "<script( .*){0,1}>";
    private TextEditor sourceEditor;
    private static final String C_DATA_BEGIN = "<![CDATA[";
    private static final String C_DATA_END = "]]>";
    private AnnotationReporter reporter;

    public TextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public AnnotationReporter getReporter() {
        if (this.reporter == null) {
            this.reporter = new AnnotationReporter((IAnnotationModel)this.sourceEditor.getAdapter(IAnnotationModel.class));
        }
        return this.reporter;
    }

    public JavascriptDocumentListener(TextEditor sourceEditor) {
        Assert.isNotNull((Object)sourceEditor);
        this.sourceEditor = sourceEditor;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        int offset = event.getOffset();
        IDocument document = event.getDocument();
        try {
            ITypedRegion partition = document.getPartition(offset);
            ITypedRegion parentRegion = document.getPartition(partition.getOffset() - 1);
            String parentNode = document.get(parentRegion.getOffset(), parentRegion.getLength());
            if (parentNode == null) {
                return;
            }
            String type = partition.getType();
            if ("XML_CDATA".equals(type) && parentNode.matches(SCRIPT)) {
                this.validate(document, partition);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void validate(IDocument document, ITypedRegion partition) throws BadLocationException {
        int beginOffset = partition.getOffset() + C_DATA_BEGIN.length();
        int length = partition.getLength() - C_DATA_BEGIN.length() - C_DATA_END.length();
        int beginLine = document.getLineOfOffset(beginOffset);
        String source = document.get(beginOffset, length);
        AnnotationReporter reporter = this.getReporter();
        reporter.reset(document, beginLine, beginOffset);
        JavascriptValidator validator = new JavascriptValidator(reporter);
        validator.validate(this.sourceEditor.getPartName(), source);
    }
}

