/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.markers;

import aurora.ide.editor.textpage.markers.XMLValidationError;
import aurora.ide.editor.textpage.markers.XMLValidationErrorHandler;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.xml.sax.SAXParseException;

public class MarkingErrorHandler
extends XMLValidationErrorHandler {
    public static final String ERROR_MARKER_ID = "editorarticle.dtderror";
    private IFile file;
    private IDocument document;

    public MarkingErrorHandler(IFile file, IDocument document) {
        this.file = file;
        this.document = document;
    }

    public void removeExistingMarkers() {
        try {
            this.file.deleteMarkers(ERROR_MARKER_ID, true, 0);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    protected XMLValidationError nextError(SAXParseException e, boolean isFatal) {
        Integer charEnd;
        XMLValidationError validationError = super.nextError(e, isFatal);
        HashMap<String, Object> map = new HashMap<String, Object>();
        int lineNumber = e.getLineNumber();
        int columnNumber = e.getColumnNumber();
        MarkerUtilities.setLineNumber(map, (int)lineNumber);
        MarkerUtilities.setMessage(map, (String)e.getMessage());
        map.put("location", this.file.getFullPath().toString());
        Integer charStart = this.getCharStart(lineNumber, columnNumber);
        if (charStart != null) {
            map.put("charStart", charStart);
        }
        if ((charEnd = this.getCharEnd(lineNumber, columnNumber)) != null) {
            map.put("charEnd", charEnd);
        }
        map.put("severity", new Integer(2));
        try {
            MarkerUtilities.createMarker((IResource)this.file, map, (String)ERROR_MARKER_ID);
        }
        catch (CoreException ee) {
            ee.printStackTrace();
        }
        return validationError;
    }

    private Integer getCharEnd(int lineNumber, int columnNumber) {
        try {
            return new Integer(this.document.getLineOffset(lineNumber - 1) + columnNumber);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Integer getCharStart(int lineNumber, int columnNumber) {
        try {
            int lineStartChar = this.document.getLineOffset(lineNumber - 1);
            Integer charEnd = this.getCharEnd(lineNumber, columnNumber);
            if (charEnd != null) {
                ITypedRegion typedRegion = this.document.getPartition(charEnd - 2);
                int partitionStartChar = typedRegion.getOffset();
                return new Integer(partitionStartChar);
            }
            return new Integer(lineStartChar);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

