/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.quickfix;

import aurora.ide.AuroraPlugin;
import aurora.ide.bm.wizard.sql.BMFromSQLWizard;
import aurora.ide.bm.wizard.sql.BMFromSQLWizardPage;
import aurora.ide.builder.ResourceUtil;
import aurora.ide.editor.textpage.quickfix.AbstractProposalCreator;
import aurora.ide.editor.textpage.quickfix.CompletionProposalAction;
import aurora.ide.editor.textpage.quickfix.EmptyAction;
import aurora.ide.editor.textpage.quickfix.Messages;
import aurora.ide.editor.textpage.quickfix.QuickAssistUtil;
import aurora.ide.editor.textpage.quickfix.SortElement;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BmProposalCreator
extends AbstractProposalCreator {
    public BmProposalCreator(IDocument doc, CompositeMap rootMap, IMarker marker) {
        super(doc, rootMap, marker);
    }

    @Override
    protected boolean isFixable() {
        if (super.isFixable()) {
            String word = this.getMarkerWord();
            if (word.equals("\"\"") || word.equals("''")) {
                return false;
            }
            return this.isValidWord(word);
        }
        return false;
    }

    @Override
    protected void create(ArrayList<ICompletionProposal> result) {
        String bmPath;
        IProject project = AuroraPlugin.getActiveIFile().getProject();
        String bmHomeStr = ResourceUtil.getBMHome(project);
        if (bmHomeStr == null || bmHomeStr.length() == 0) {
            return;
        }
        String bmName = bmPath = this.getMarkerWord();
        int idx = bmPath.lastIndexOf(46);
        String prefix = "";
        if (idx != -1) {
            prefix = bmPath.substring(0, idx).replace('.', '/');
            bmName = bmPath.substring(idx + 1);
        }
        IFolder folder = project.getParent().getFolder((IPath)new Path(String.valueOf(bmHomeStr) + '/' + prefix));
        ArrayList<SortElement> list = this.getAvailableBm(bmName, folder);
        if (prefix.length() > 0) {
            prefix = String.valueOf(prefix.replace('/', '.')) + '.';
        }
        IRegion region = this.getMarkerRegion();
        for (SortElement se : list) {
            String str = String.valueOf(prefix) + se.name;
            CompletionProposal cp = new CompletionProposal(str, region.getOffset(), region.getLength(), str.length(), img_rename, NLS.bind((String)Messages.Change_to, (Object)str), null, NLS.bind((String)Messages.Suggest_change_to, (Object)str));
            result.add((ICompletionProposal)cp);
        }
        result.add(this.getCreateNewBmProposal(bmPath, bmName, region, folder));
    }

    private ICompletionProposal getCreateNewBmProposal(String bmPath, final String bmName, IRegion region, final IFolder folder) {
        CompletionProposalAction cpa = new CompletionProposalAction("", region.getOffset(), 0, 0, img_new, NLS.bind((String)Messages.Create_bm, (Object)bmPath), null, Messages.BmProposalCreator_5);
        cpa.setAction(new EmptyAction(){

            public void run() {
                BMFromSQLWizard sqlWizard = new BMFromSQLWizard();
                WizardDialog wd = new WizardDialog(new Shell(Display.getCurrent()), (IWizard)sqlWizard);
                wd.setBlockOnOpen(false);
                wd.open();
                BMFromSQLWizardPage wp = (BMFromSQLWizardPage)wd.getCurrentPage();
                wp.setFolder(folder.getFullPath().toString());
                wp.setFileName(bmName);
                wp.getSQLTextField().forceFocus();
            }
        });
        cpa.setIgnoreReplace(true);
        return cpa;
    }

    private ArrayList<SortElement> getAvailableBm(String bmName, IFolder folder) {
        ArrayList<SortElement> comp = new ArrayList<SortElement>();
        try {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IFile && "bm".equalsIgnoreCase(res.getFileExtension())) {
                    String fn = res.getName();
                    int ed = QuickAssistUtil.getApproiateEditDistance(bmName, fn = fn.substring(0, fn.length() - 3));
                    if (ed > 0) {
                        comp.add(new SortElement(fn, ed));
                    }
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        Collections.sort(comp);
        return comp;
    }
}

