/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.quickfix;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.builder.CompositeMapInfo;
import aurora.ide.editor.textpage.quickfix.AbstractProposalCreator;
import aurora.ide.editor.textpage.quickfix.Messages;
import aurora.ide.editor.textpage.quickfix.QuickAssistUtil;
import aurora.ide.editor.textpage.quickfix.SortElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.osgi.util.NLS;
import uncertain.composite.CompositeMap;
import uncertain.composite.IterationHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsProposalCreator
extends AbstractProposalCreator {
    private String LS = CommentXMLOutputter.LINE_SEPARATOR;

    public DsProposalCreator(IDocument doc, CompositeMap rootMap, IMarker marker) {
        super(doc, rootMap, marker);
    }

    @Override
    protected boolean isFixable() {
        return super.isFixable() && this.isValidWord(this.getMarkerWord());
    }

    @Override
    protected void create(ArrayList<ICompletionProposal> result) {
        IRegion region = this.getMarkerRegion();
        for (SortElement se : this.getAvailableDs()) {
            String dsn = se.name;
            CompletionProposal cp = new CompletionProposal(dsn, region.getOffset(), region.getLength(), dsn.length(), img_rename, NLS.bind((String)Messages.Change_to, (Object)dsn), null, NLS.bind((String)Messages.Suggest_change_to, (Object)dsn));
            result.add((ICompletionProposal)cp);
        }
        ICompletionProposal cp = this.getCreateNewDsPropospal();
        if (cp != null) {
            result.add(cp);
        }
    }

    private ICompletionProposal getCreateNewDsPropospal() {
        CompositeMap[] pathMap = this.getDataSetsPathMaps();
        if (pathMap[0] == null) {
            return null;
        }
        int insertOffset = 0;
        String insertTag = "";
        CommentCompositeMap dataSetMap = new CommentCompositeMap();
        Map nsMapping = this.getRootMap().getNamespaceMapping();
        CompositeMap map = this.getCursorMap();
        String word = this.getMarkerWord();
        IDocument doc = this.getDocument();
        String aPrefix = map.getString((Object)"http://www.aurora-framework.org/application");
        if (aPrefix == null) {
            aPrefix = "a";
        }
        dataSetMap.setNamespaceMapping(nsMapping);
        dataSetMap.setName("dataSet");
        dataSetMap.setPrefix(aPrefix);
        dataSetMap.put("id", word);
        int replaceLength = 0;
        if (pathMap[2] == null) {
            CommentCompositeMap dataSetsMap = new CommentCompositeMap();
            dataSetsMap.setNamespaceMapping(nsMapping);
            dataSetsMap.setName("dataSets");
            dataSetsMap.setPrefix(aPrefix);
            dataSetsMap.addChild(dataSetMap);
            String prefix = "";
            if (pathMap[1] == null) {
                CompositeMapInfo info = new CompositeMapInfo(pathMap[0], doc);
                prefix = String.valueOf(info.getLeadPrefix()) + "    ";
                IRegion region = info.getStartTagRegion();
                insertOffset = region.getOffset() + region.getLength();
                insertTag = String.valueOf(this.LS) + prefix + dataSetsMap.toXML().trim().replace(this.LS, String.valueOf(this.LS) + prefix);
            } else {
                CompositeMapInfo info = new CompositeMapInfo(pathMap[1], doc);
                prefix = info.getLeadPrefix();
                IRegion endRegion = info.getEndTagRegion();
                insertOffset = endRegion.getOffset() + endRegion.getLength();
                insertTag = String.valueOf(this.LS) + prefix + dataSetsMap.toXML().trim().replace(this.LS, String.valueOf(this.LS) + prefix);
            }
        } else {
            CompositeMap outerDsMap = this.getOuterDataSetMap(map);
            if (outerDsMap != null) {
                CompositeMapInfo info = new CompositeMapInfo(outerDsMap, doc);
                IRegion region = info.getStartTagRegion();
                String prefix = info.getLeadPrefix();
                insertOffset = region.getOffset();
                insertTag = String.valueOf(dataSetMap.toXML().trim()) + this.LS + prefix;
            } else {
                CompositeMapInfo info = new CompositeMapInfo(pathMap[2], doc);
                IRegion region = info.getMapRegion();
                String prefix = info.getLeadPrefix();
                this.clearnsURI(pathMap[2]);
                replaceLength = region.getLength();
                pathMap[2].addChild((CompositeMap)dataSetMap);
                insertOffset = region.getOffset();
                insertTag = pathMap[2].toXML().trim().replace(this.LS, String.valueOf(this.LS) + prefix);
            }
        }
        return new CompletionProposal(insertTag, insertOffset, replaceLength, insertTag.length(), img_new, NLS.bind((String)Messages.Create_ds, (Object)word), null, NLS.bind((String)Messages.Create_ds, (Object)word));
    }

    private void clearnsURI(CompositeMap map) {
        map.iterate(new IterationHandle(){

            public int process(CompositeMap map) {
                map.setNameSpaceURI(null);
                return 0;
            }
        }, true);
    }

    private CompositeMap getOuterDataSetMap(CompositeMap map) {
        while (map != null && !map.getName().equalsIgnoreCase("dataSet")) {
            map = map.getParent();
        }
        return map;
    }

    private CompositeMap[] getDataSetsPathMaps() {
        final CompositeMap[] path = new CompositeMap[3];
        this.getRootMap().iterate(new IterationHandle(){

            public int process(CompositeMap map) {
                if (map.getName().equalsIgnoreCase("view")) {
                    path[0] = map;
                } else if (map.getName().equalsIgnoreCase("script") && map.getParent().getName().equalsIgnoreCase("view")) {
                    path[1] = map;
                } else if (map.getName().equalsIgnoreCase("dataSets")) {
                    path[2] = map;
                    return 2;
                }
                return 0;
            }
        }, true);
        return path;
    }

    private Set<String> getDefinedDataSets() {
        final HashSet<String> set = new HashSet<String>();
        this.getRootMap().iterate(new IterationHandle(){

            public int process(CompositeMap map) {
                if (map == DsProposalCreator.this.getCursorMap()) {
                    return 2;
                }
                if (!map.getName().equalsIgnoreCase("dataSet")) {
                    return 0;
                }
                String ds = map.getString((Object)"id");
                if (ds != null) {
                    set.add(ds);
                }
                return 0;
            }
        }, true);
        return set;
    }

    private ArrayList<SortElement> getAvailableDs() {
        ArrayList<SortElement> comp = new ArrayList<SortElement>();
        String uds = this.getMarkerWord();
        for (String ds : this.getDefinedDataSets()) {
            int ed = QuickAssistUtil.getApproiateEditDistance(uds, ds);
            if (ed <= 0) continue;
            comp.add(new SortElement(ds, ed));
        }
        Collections.sort(comp);
        return comp;
    }
}

