/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.quickfix;

import aurora.ide.AuroraPlugin;
import aurora.ide.bm.ExtendModelFactory;
import aurora.ide.builder.processor.LocalFieldCollector;
import aurora.ide.editor.textpage.quickfix.AbstractProposalCreator;
import aurora.ide.editor.textpage.quickfix.Messages;
import aurora.ide.editor.textpage.quickfix.QuickAssistUtil;
import aurora.ide.editor.textpage.quickfix.SortElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.osgi.util.NLS;
import uncertain.composite.CompositeMap;
import uncertain.ocm.OCManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFieldProposalCreator
extends AbstractProposalCreator {
    public LocalFieldProposalCreator(IDocument doc, CompositeMap rootMap, IMarker marker) {
        super(doc, rootMap, marker);
    }

    @Override
    protected boolean isFixable() {
        return super.isFixable() && this.isValidWord(this.getMarkerWord());
    }

    @Override
    protected void create(ArrayList<ICompletionProposal> result) {
        for (SortElement se : this.getAvailableLocalFields()) {
            String name = se.name;
            result.add((ICompletionProposal)new CompletionProposal(name, this.getMarkerOffset(), this.getMarkerLength(), name.length(), img_rename, NLS.bind((String)Messages.Change_to, (Object)name), null, NLS.bind((String)Messages.Suggest_change_to, (Object)name)));
        }
    }

    private ArrayList<SortElement> getAvailableLocalFields() {
        ArrayList<SortElement> list = new ArrayList<SortElement>();
        IFile currentFile = AuroraPlugin.getActiveIFile();
        if (currentFile == null) {
            return list;
        }
        CompositeMap wholeMap = this.getRootMap();
        if (wholeMap.getString((Object)"extend") != null) {
            try {
                ExtendModelFactory factory = new ExtendModelFactory(OCManager.getInstance(), currentFile);
                wholeMap = factory.getModel(this.getRootMap()).getObjectContext();
            }
            catch (Exception e) {
                return list;
            }
        }
        Set<String> localFields = new LocalFieldCollector(wholeMap).collect();
        String locf = this.getMarkerWord();
        for (String s : localFields) {
            int ed = QuickAssistUtil.getApproiateEditDistance(locf, s);
            if (ed <= 0) continue;
            list.add(new SortElement(s, ed));
        }
        Collections.sort(list);
        return list;
    }
}

