/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.quickfix;

import aurora.ide.AuroraPlugin;
import aurora.ide.editor.BaseCompositeMapEditor;
import aurora.ide.editor.textpage.TextPage;
import aurora.ide.editor.textpage.quickfix.CompletionProposalAction;
import aurora.ide.editor.textpage.quickfix.CompletionProposalCreator;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import uncertain.composite.CompositeMap;

public class QuickFixInformationControl
extends AbstractInformationControl
implements DisposeListener {
    private Composite com;
    private MarkerAnnotation ma;
    private IMarker marker;
    private int displayWidth = 0;
    private int displayHeight = 0;
    private IDocument curDoc;
    private CompositeMap curMap;
    private TextPage textPage;
    private static Color gray_color = new Color(null, 128, 128, 128);
    private static Color link_color = new Color(null, 0, 102, 204);

    public QuickFixInformationControl(Shell parent, MarkerAnnotation ma, boolean isResizeable) {
        super(parent, isResizeable);
        this.init(ma);
    }

    public QuickFixInformationControl(Shell parent, MarkerAnnotation ma, String statusText) {
        super(parent, statusText);
        this.init(ma);
    }

    public Point computeSizeHint() {
        return new Point(this.displayWidth, this.displayHeight + 20);
    }

    public Rectangle computeTrim() {
        return Geometry.add((Rectangle)super.computeTrim(), (Rectangle)this.com.computeTrim(0, 0, 0, 0));
    }

    protected void createContent(Composite parent) {
        this.com = new Composite(parent, 0);
        this.com.setForeground(parent.getForeground());
        this.com.setBackground(parent.getBackground());
        this.com.setFont(JFaceResources.getDialogFont());
        this.com.setLayout(null);
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new QuickFixInformationControl(parent, QuickFixInformationControl.this.ma, true);
            }
        };
    }

    private int guessWidth(Control ctr, String msg) {
        GC gc = new GC((Drawable)ctr);
        Point pt = gc.textExtent(msg);
        gc.dispose();
        return pt.x;
    }

    public boolean hasContents() {
        return this.marker != null;
    }

    private void init(MarkerAnnotation ma) {
        this.ma = ma;
        this.marker = ma.getMarker();
        this.textPage = (TextPage)((BaseCompositeMapEditor)AuroraPlugin.getActivePage().getActiveEditor()).getActiveEditor();
        this.curDoc = this.textPage.getInputDocument();
        if (this.curDoc == null) {
            return;
        }
        try {
            this.curMap = CompositeMapUtil.loaderFromString(this.curDoc.get());
        }
        catch (ApplicationException e1) {
            e1.printStackTrace();
        }
        this.create();
    }

    public void setBackgroundColor(Color background) {
        super.setBackgroundColor(background);
        this.com.setBackground(background);
    }

    public void setForegroundColor(Color foreground) {
        super.setForegroundColor(foreground);
        this.com.setForeground(foreground);
    }

    public void setInformation(String content) {
        if (this.com == null) {
            return;
        }
        final Text text = new Text(this.com, 4);
        text.setMenu(new Menu((Decorations)this.getShell(), 0));
        text.setBackground(this.com.getBackground());
        text.setEditable(false);
        try {
            String msg = (String)this.marker.getAttribute("message");
            text.setText(msg);
            this.displayWidth = this.guessWidth((Control)text, msg) + 12;
        }
        catch (CoreException e) {
            e.printStackTrace();
            text.setText(e.getMessage());
        }
        text.setBounds(2, 2, this.displayWidth, 20);
        this.displayHeight = 30;
        ICompletionProposal[] cps = new CompletionProposalCreator(this.curDoc, this.curMap, this.marker).getCompletionProposal();
        if (cps == null || cps.length == 0) {
            return;
        }
        this.com.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(gray_color);
                Rectangle r = text.getBounds();
                int y = r.y + r.height + 1;
                e.gc.drawLine(0, y, ((QuickFixInformationControl)QuickFixInformationControl.this).com.getShell().getSize().x, y);
            }
        });
        int i = 0;
        while (i < cps.length) {
            Label l = new Label(this.com, 0);
            l.setBackground(this.com.getBackground());
            l.setBounds(3, this.displayHeight, 16, 20);
            l.setImage(cps[i].getImage());
            final Hyperlink hl = new Hyperlink(this.com, 0);
            hl.setBounds(20, this.displayHeight, this.guessWidth((Control)hl, cps[i].getDisplayString()) + 10, 20);
            hl.setText(cps[i].getDisplayString());
            hl.setBackground(this.com.getBackground());
            hl.setForeground(link_color);
            hl.addHyperlinkListener((IHyperlinkListener)new ProposalHyperlinkAdapter(cps[i]));
            hl.addMouseTrackListener(new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                    hl.setUnderlined(true);
                }

                public void mouseExit(MouseEvent e) {
                    hl.setUnderlined(false);
                }

                public void mouseHover(MouseEvent e) {
                }
            });
            this.displayHeight += 24;
            ++i;
        }
        this.displayHeight += 24;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public void widgetDisposed(DisposeEvent event) {
    }

    class ProposalHyperlinkAdapter
    extends HyperlinkAdapter {
        private ICompletionProposal cp;

        public ProposalHyperlinkAdapter(ICompletionProposal cp) {
            this.cp = cp;
        }

        public void linkActivated(HyperlinkEvent e) {
            CompletionProposalAction cpa;
            if (this.cp instanceof CompletionProposalAction && (cpa = (CompletionProposalAction)this.cp).isIgnoreReplace()) {
                IAction action = cpa.getAction();
                action.run();
                QuickFixInformationControl.this.getShell().close();
                return;
            }
            this.cp.apply(QuickFixInformationControl.this.curDoc);
            Point selection = this.cp.getSelection(QuickFixInformationControl.this.curDoc);
            if (selection != null) {
                QuickFixInformationControl.this.textPage.getSelectionProvider().setSelection((ISelection)new TextSelection(selection.x, selection.y));
            }
            QuickFixInformationControl.this.getShell().close();
        }
    }
}

