/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.quickfix;

import aurora.ide.builder.CompositeMapInfo;
import aurora.ide.builder.SxsdUtil;
import aurora.ide.editor.textpage.quickfix.AbstractProposalCreator;
import aurora.ide.editor.textpage.quickfix.Messages;
import aurora.ide.editor.textpage.quickfix.QuickAssistUtil;
import aurora.ide.editor.textpage.quickfix.SortElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.osgi.util.NLS;
import uncertain.composite.CompositeMap;
import uncertain.schema.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagProposalCreator
extends AbstractProposalCreator {
    public TagProposalCreator(IDocument doc, CompositeMap rootMap, IMarker marker) {
        super(doc, rootMap, marker);
    }

    @Override
    protected boolean isFixable() {
        return super.isFixable() && this.isValidWord(this.getMarkerWord());
    }

    @Override
    protected void create(ArrayList<ICompletionProposal> result) {
        CompositeMap map = this.getCursorMap();
        IDocument doc = this.getDocument();
        String tagName = map.getName();
        CompositeMapInfo info = new CompositeMapInfo(map, doc);
        IRegion mapRegion = info.getMapRegion();
        IRegion mapNameRegion = info.getMapNameRegion();
        IRegion mapEndNameRegion = info.getMapEntTagNameRegion();
        boolean isSelfClose = mapNameRegion.equals(mapEndNameRegion);
        StringBuilder mapStr = null;
        int start1 = 0;
        int start2 = 0;
        if (!isSelfClose) {
            start2 = mapEndNameRegion.getOffset() - mapRegion.getOffset();
            start1 = mapNameRegion.getOffset() - mapRegion.getOffset();
            mapStr = new StringBuilder(this.getString(doc, mapRegion));
        }
        for (SortElement se : this.getAvailableTag()) {
            String name = se.name;
            if (!isSelfClose) {
                mapStr.replace(start2, start2 + tagName.length(), name);
                mapStr.replace(start1, start1 + tagName.length(), name);
                result.add((ICompletionProposal)new CompletionProposal(mapStr.toString(), mapRegion.getOffset(), mapRegion.getLength(), mapNameRegion.getOffset() - mapRegion.getOffset() + name.length(), img_rename, NLS.bind((String)Messages.Change_to, (Object)name), null, NLS.bind((String)Messages.Suggest_change_to, (Object)name)));
                continue;
            }
            result.add((ICompletionProposal)new CompletionProposal(name, mapNameRegion.getOffset(), mapNameRegion.getLength(), name.length(), img_rename, NLS.bind((String)Messages.Change_to, (Object)name), null, NLS.bind((String)Messages.Suggest_change_to, (Object)name)));
        }
        result.add((ICompletionProposal)new CompletionProposal("", mapRegion.getOffset(), mapRegion.getLength(), 0, img_remove, NLS.bind((String)Messages.Delete_tag, (Object)tagName), null, NLS.bind((String)Messages.TagProposalCreator_2, (Object)tagName)));
    }

    private ArrayList<SortElement> getAvailableTag() {
        ArrayList<SortElement> comp = new ArrayList<SortElement>();
        CompositeMap map = this.getCursorMap();
        String tagName = map.getName();
        CompositeMap parent = map.getParent();
        List<Element> aChilds = SxsdUtil.getAvailableChildElements(parent);
        for (Element e : aChilds) {
            int ed;
            String name = e.getQName().getLocalName();
            if (name.equals(tagName) || (ed = QuickAssistUtil.getApproiateEditDistance(tagName, name)) == -1) continue;
            comp.add(new SortElement(name, ed));
        }
        Collections.sort(comp);
        return comp;
    }

    private String getString(IDocument doc, IRegion region) {
        try {
            return doc.get(region.getOffset(), region.getLength());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

