/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.scanners;

import aurora.ide.editor.textpage.ColorManager;
import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.editor.textpage.XMLWhitespaceDetector;
import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class JSEditorCodeScanner
extends RuleBasedScanner {
    private static String[] fgKeywords = new String[]{"function", "var", "abstract", "break", "case", "catch", "class", "continue", "default", "do", "else", "extends", "final", "finally", "for", "if", "implements", "import", "instanceof", "interface", "native", "new", "package", "private", "protected", "public", "return", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "volatile", "while"};
    private static String[] fgTypes = new String[]{"void", "boolean", "char", "byte", "short", "int", "long", "float", "double"};
    private static String[] fgConstants = new String[]{"false", "null", "true"};

    public JSEditorCodeScanner(ColorManager colorManager) {
        Token keyword = new Token((Object)new TextAttribute(colorManager.getColor(IColorConstants.KEYWORD), null, 1));
        Token type = new Token((Object)new TextAttribute(colorManager.getColor(IColorConstants.TYPE)));
        Token string = new Token((Object)new TextAttribute(colorManager.getColor(IColorConstants.STRING)));
        Token comment = new Token((Object)new TextAttribute(colorManager.getColor(IColorConstants.SINGLE_LINE_COMMENT)));
        Token other = new Token((Object)new TextAttribute(colorManager.getColor(IColorConstants.DEFAULT)));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", (IToken)comment));
        rules.add(new MultiLineRule("/*", "*/", (IToken)comment));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new XMLWhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new JSEditorWordDetector(), (IToken)other);
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < fgTypes.length) {
            wordRule.addWord(fgTypes[i], (IToken)type);
            ++i;
        }
        i = 0;
        while (i < fgConstants.length) {
            wordRule.addWord(fgConstants[i], (IToken)type);
            ++i;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    class JSEditorWordDetector
    implements IWordDetector {
        JSEditorWordDetector() {
        }

        public boolean isWordPart(char character) {
            return Character.isJavaIdentifierPart(character);
        }

        public boolean isWordStart(char character) {
            return Character.isJavaIdentifierStart(character);
        }
    }
}

