/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.scanners;

import aurora.ide.editor.textpage.ColorManager;
import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.editor.textpage.scanners.SQLWordDetector;
import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.widgets.Display;

public class SQLCodeScanner
extends RuleBasedScanner {
    private static String[] fgKeywords = new String[]{"ABSOLUTE", "ACQUIRE", "ACTION", "ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUDIT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT_LENGTH", "BOTH", "BUFFERPOOL", "BY", "CALL", "CAPTURE", "CASCADED", "CASE", "CAST", "CATALOG", "CCSID", "CHAR", "CHAR_LENGTH", "CHARACTER", "CHARACTER_LENGTH", "CHECK", "CLOSE", "CLUSTER", "COALESCE", "COLLATE", "COLLATION", "COLLECTION", "COLUMN", "COMMENT", "COMMIT", "CONCAT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_SERVER", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TIMEZONE", "CURRENT_USER", "CURSOR", "DATABASE", "DATE", "DAY", "DAYS", "DBA", "DBSPACE", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "EDITPROC", "ELSE", "END", "END-EXEC", "ERASE", "ESCAPE", "EXCEPT", "EXCEPTION", "EXCLUSIVE", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", "FETCH", "FIELDPROC", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "FULL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GRAPHIC", "GROUP", "HAVING", "HOUR", "HOURS", "IDENTIFIED", "IDENTITY", "IMMEDIATE", "IN", "INDEX", "INDICATOR", "INITIALLY", "INNER", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JOIN", "JOIN", "KEY", "LABEL", "LANGUAGE", "LAST", "LEADING", "LEFT", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOCK", "LOCKSIZE", "LONG", "LOWER", "MATCH", "MAX", "MICROSECOND", "MICROSECONDS", "MIN", "MINUTE", "MINUTES", "MODE", "MODULE", "MONTH", "MONTHS", "NAMED", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NHEADER", "NO", "NOT", "NULL", "NULLIF", "NUMERIC", "NUMPARTS", "OBID", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTIMIZE", "OPTION", "OR", "ORDER", "OUT", "OUTER", "OUTPUT", "OVERLAPS", "PACKAGE", "PAD", "PAGE", "PAGES", "PART", "PARTIAL", "PCTFREE", "PCTINDEX", "PLAN", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIQTY", "PRIVATE", "PRIVILEGES", "PROCEDURE", "PROGRAM", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RELEASE", "RESET", "RESOURCE", "REVOKE", "RIGHT", "RIGHT", "ROLLBACK", "ROW", "ROWS", "RRN", "RUN", "SCHEDULE", "SCHEMA", "SCROLL", "SECOND", "SECONDS", "SECQTY", "SECTION", "SELECT", "SESSION", "SESSION_USER", "SET", "SHARE", "SIMPLE", "SIZE", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "STATISTICS", "STOGROUP", "STORPOOL", "SUBPAGES", "SUBSTRING", "SUM", "SYNONYM", "SYSTEM_USER", "TABLE", "TABLESPACE", "TEMPORARY", "THEN", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATION", "TRIM", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALIDPROC", "VALUE", "VALUES", "VARCHAR", "VARIABLE", "VARYING", "VCAT", "VIEW", "VOLUMES", "WHEN", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "YEAR", "YEARS", "ZONE", "FALSE", "TRUE"};
    private static String[] fgDatatypes = new String[]{"INTEGER", "SMALLINTEGER", "BIGINT", "DECIMAL", "DOUBLE", "REAL", "TIME", "TIMESTAMP", "DATE", "DATALINK", "CHAR", "VARCHAR", "BLOB", "CLOB", "GRAPHIC", "VARGRAPHIC", "DBCLOB"};
    private static String[] fgFunctions = new String[]{"ABS", "ABSVAL", "ACOS", "ASCII", "ASIN", "ATAN", "ATAN2", "BIGINT", "BLOB", "CEILING", "CHAR", "CHR", "CLOB", "COALESCE", "CONCAT", "CORRELATION", "COS", "COT", "COUNT", "COUNT_BIG", "COVARIANCE", "DATE", "DAY", "DAYNAME", "DAYOFWEEK", "DAYOFWEEK_ISO", "DAYOFYEAR", "DAYS", "DBCLOB", "DECIMAL", "DEGREES", "DEREF", "DIFFERENCE", "DIGITS", "DLCOMMENT", "DLLINKTYPE", "DLURLCOMPLETE", "DLURLPATH", "DLURLPATHONLY", "DLURLSCHEME", "DLURLSERVER", "DLVALUE", "DOUBLE", "EVENT_MON_STATE", "EXP", "FLOAT", "FLOOR", "GENERATE_UNIQUE", "GRAPHIC", "GROUPING", "HEX", "HOUR", "INSERT", "INTEGER", "JULIAN_DAY", "LCASE", "LCASE", "LEFT", "LENGTH", "LN", "LOCATE", "LOG", "LOG10", "LONG_VARCHAR", "LONG_VARGRAPHIC", "LTRIM", "LTRIM", "MAX", "MICROSECOND", "MIDNIGHT_SECONDS", "MIN", "MINUTE", "MOD", "MONTH", "MONTHNAME", "NODENUMBER", "NULLIF", "PARTITION", "POSSTR", "POWER", "QUARTER", "RADIANS", "RAISE_ERROR", "RAND", "REAL", "REPEAT", "REPLACE", "RIGHT", "ROUND", "RTRIM", "RTRIM", "SECOND", "SIGN", "SIN", "SMALLINT", "SOUNDEX", "SPACE", "SQLCACHE_SNAPSHOT", "SQRT", "STDDEV", "SUBSTR", "SUM", "TABLE_NAME", "TABLE_SCHEMA", "TAN", "TIME", "TIMESTAMP", "TIMESTAMP_ISO", "TIMESTAMPDIFF", "TRANSLATE", "TRUNCATE", "TRUNC", "TYPE_ID", "TYPE_NAME", "TYPE_SCHEMA", "UCASE", "UPPER", "VALUE", "VARCHAR", "VARGRAPHIC", "VARIANCE", "WEEK", "WEEK_ISO", "YEAR"};
    private static Object[] fgAllWords = new Object[]{fgKeywords, fgDatatypes, fgFunctions};

    public SQLCodeScanner(ColorManager colorProvider) {
        Token commentToken = null;
        Token stringToken = null;
        Token keywordToken = null;
        Token datatypeToken = null;
        Token functionToken = null;
        Token delimitedIdentifierToken = null;
        Token otherToken = null;
        if (Display.getDefault().getHighContrast()) {
            commentToken = new Token((Object)new TextAttribute(colorProvider.getColor(IColorConstants.SQL_HC_COMMENT_COLOR)));
            stringToken = new Token((Object)new TextAttribute(colorProvider.getColor(IColorConstants.SQL_HC_QUOTED_LITERAL_COLOR)));
            keywordToken = new Token((Object)new TextAttribute(colorProvider.getColor(IColorConstants.SQL_HC_KEYWORD_COLOR)));
            datatypeToken = new Token((Object)new TextAttribute(colorProvider.getColor(IColorConstants.SQL_HC_KEYWORD_COLOR)));
            functionToken = new Token((Object)new TextAttribute(colorProvider.getColor(IColorConstants.SQL_HC_KEYWORD_COLOR)));
            delimitedIdentifierToken = new Token((Object)new TextAttribute(colorProvider.getColor(IColorConstants.SQL_HC_DELIMITED_IDENTIFIER_COLOR)));
            otherToken = new Token((Object)new TextAttribute(colorProvider.getColor(IColorConstants.SQL_HC_DEFAULT_COLOR)));
        } else {
            commentToken = new Token((Object)new TextAttribute(colorProvider.getColor(IColorConstants.SQL_COMMENT_COLOR)));
            stringToken = new Token((Object)new TextAttribute(colorProvider.getColor(IColorConstants.SQL_QUOTED_LITERAL_COLOR)));
            keywordToken = new Token((Object)new TextAttribute(colorProvider.getColor(IColorConstants.SQL_KEYWORD_COLOR)));
            datatypeToken = new Token((Object)new TextAttribute(colorProvider.getColor(IColorConstants.SQL_KEYWORD_COLOR)));
            functionToken = new Token((Object)new TextAttribute(colorProvider.getColor(IColorConstants.SQL_KEYWORD_COLOR)));
            delimitedIdentifierToken = new Token((Object)new TextAttribute(colorProvider.getColor(IColorConstants.SQL_DELIMITED_IDENTIFIER_COLOR)));
            otherToken = new Token((Object)new TextAttribute(colorProvider.getColor(IColorConstants.SQL_DEFAULT_COLOR)));
        }
        this.setDefaultReturnToken((IToken)otherToken);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("--", (IToken)commentToken));
        rules.add(new MultiLineRule("/*", "*/", (IToken)commentToken));
        rules.add(new SingleLineRule("'", "'", (IToken)stringToken, '\\'));
        rules.add(new SingleLineRule("\"", "\"", (IToken)delimitedIdentifierToken, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new SQLWhiteSpaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new SQLWordDetector(), (IToken)otherToken);
        String[] reservedWords = SQLCodeScanner.getSQLKeywords();
        int i = 0;
        while (i < reservedWords.length) {
            wordRule.addWord(reservedWords[i], (IToken)keywordToken);
            wordRule.addWord(reservedWords[i].toLowerCase(), (IToken)keywordToken);
            ++i;
        }
        String[] datatypes = SQLCodeScanner.getSQLDatatypes();
        int i2 = 0;
        while (i2 < datatypes.length) {
            wordRule.addWord(datatypes[i2], (IToken)datatypeToken);
            wordRule.addWord(datatypes[i2].toLowerCase(), (IToken)datatypeToken);
            ++i2;
        }
        String[] functions = SQLCodeScanner.getSQLFunctionNames();
        int i3 = 0;
        while (i3 < functions.length) {
            wordRule.addWord(functions[i3], (IToken)functionToken);
            wordRule.addWord(functions[i3].toLowerCase(), (IToken)functionToken);
            ++i3;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    public static String[] getSQLKeywords() {
        return fgKeywords;
    }

    public static String[] getSQLDatatypes() {
        return fgDatatypes;
    }

    public static String[] getSQLFunctionNames() {
        return fgFunctions;
    }

    public static Object[] getSQLAllWords() {
        return fgAllWords;
    }

    public class SQLWhiteSpaceDetector
    implements IWhitespaceDetector {
        public boolean isWhitespace(char c) {
            return Character.isWhitespace(c);
        }
    }
}

