/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.widgets;

import aurora.ide.celleditor.CellEditorFactory;
import aurora.ide.celleditor.ICellEditor;
import aurora.ide.editor.PropertyViewer;
import aurora.ide.editor.core.ICategoryTableViewer;
import aurora.ide.editor.core.IViewer;
import aurora.ide.editor.widgets.PropertyHashCellModifier;
import aurora.ide.editor.widgets.PropertyHashContentProvider;
import aurora.ide.editor.widgets.PropertyHashLabelProvider;
import aurora.ide.editor.widgets.PropertyHashSorter;
import aurora.ide.editor.widgets.core.CategoryLabel;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.node.action.AddPropertyAction;
import aurora.ide.node.action.CategroyAction;
import aurora.ide.node.action.CharSortAction;
import aurora.ide.node.action.RefreshAction;
import aurora.ide.node.action.RemovePropertyAction;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.schema.Attribute;
import uncertain.schema.Element;
import uncertain.schema.editor.AttributeValue;

public class PropertyHashViewer
extends PropertyViewer
implements ICategoryTableViewer {
    public static final String COLUMN_PROPERTY = "PROPERTY";
    public static final String COLUMN_VALUE = "VALUE";
    public static final String COLUMN_DOCUMENT = "DOCUMENT";
    public static final String[] TABLE_COLUMN_PROPERTIES = new String[]{"PROPERTY", "VALUE", "DOCUMENT"};
    private boolean isCategory;
    private Composite parent;
    private TableViewer tableViewer;
    protected IViewer page;
    private SashForm sashForm;
    private HashMap customerEditors = new HashMap();
    private Label elementDocument;

    public PropertyHashViewer(IViewer page, Composite parent) {
        this.page = page;
        this.parent = parent;
    }

    public void setData(CompositeMap data) throws ApplicationException {
        String document;
        Assert.isTrue((this.tableViewer != null ? 1 : 0) != 0, (String)"The viewer has not been created!");
        this.tableViewer.setInput((Object)data);
        int xWidth = this.parent.getBounds().width;
        if (xWidth < 100) {
            xWidth = 800;
        }
        this.setCellEditors();
        Element em = CompositeMapUtil.getElement(data);
        this.elementDocument.setText("");
        if (em != null && (document = em.getDocument()) != null) {
            this.elementDocument.setText(document);
        }
    }

    public String clear(boolean validation) {
        if (this.tableViewer != null) {
            String errorMessage = this.clearCellEditor(validation);
            if (errorMessage != null) {
                return errorMessage;
            }
            this.tableViewer.getTable().removeAll();
            this.elementDocument.setText("");
        }
        return null;
    }

    public void createEditor() {
        Assert.isTrue((this.tableViewer == null ? 1 : 0) != 0, (String)"The viewer has been created!");
        this.sashForm = new SashForm(this.parent, 512);
        ViewForm viewForm = new ViewForm((Composite)this.sashForm, 0);
        this.elementDocument = new Label((Composite)this.sashForm, 16384);
        viewForm.setLayout((Layout)new FillLayout());
        this.createToolbar(viewForm);
        this.createMainContent(viewForm);
        this.sashForm.setWeights(new int[]{92, 8});
    }

    public void createEditor(boolean showElementDocument) {
        Assert.isTrue((this.tableViewer == null ? 1 : 0) != 0, (String)"The viewer has been created!");
        this.sashForm = new SashForm(this.parent, 512);
        ViewForm viewForm = new ViewForm((Composite)this.sashForm, 0);
        this.elementDocument = new Label((Composite)this.sashForm, 16384);
        viewForm.setLayout((Layout)new FillLayout());
        this.createToolbar(viewForm);
        this.createMainContent(viewForm);
        if (!showElementDocument) {
            this.sashForm.SASH_WIDTH = 0;
            int[] nArray = new int[2];
            nArray[0] = 100;
            this.sashForm.setWeights(nArray);
        } else {
            this.sashForm.setWeights(new int[]{92, 8});
        }
    }

    private void createMainContent(ViewForm viewForm) {
        this.tableViewer = new TableViewer((Composite)viewForm, 67584);
        Table mTable = this.tableViewer.getTable();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PropertyHashLabelProvider());
        PropertyHashContentProvider contentProvider = new PropertyHashContentProvider(this);
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.tableViewer.setCellModifier((ICellModifier)new PropertyHashCellModifier(this));
        this.tableViewer.setColumnProperties(TABLE_COLUMN_PROPERTIES);
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = new TextCellEditor((Composite)mTable);
        this.tableViewer.setCellEditors(cellEditorArray);
        mTable.setLinesVisible(true);
        mTable.setHeaderVisible(true);
        TableColumn propertycolumn = new TableColumn(mTable, 16384);
        propertycolumn.setWidth(150);
        propertycolumn.setText(LocaleMessage.getString("property.name"));
        TableColumn valueColumn = new TableColumn(mTable, 16384);
        valueColumn.setText(LocaleMessage.getString("value"));
        valueColumn.setWidth(150);
        TableColumn descColumn = new TableColumn(mTable, 16384);
        descColumn.setText(LocaleMessage.getString("description"));
        descColumn.setWidth(250);
        viewForm.setContent(this.tableViewer.getControl());
        this.addKeyListener();
        this.tableViewer.setSorter((ViewerSorter)new PropertyHashSorter(this, contentProvider));
        propertycolumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((PropertyHashSorter)PropertyHashViewer.this.tableViewer.getSorter()).doSort(0);
                PropertyHashViewer.this.repaint();
                PropertyHashViewer.this.refresh();
            }
        });
        this.refresh();
    }

    private void createToolbar(ViewForm viewForm) {
        ToolBar toolBar = new ToolBar((Composite)viewForm, 0x820000);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        this.fillActionToolBars(toolBarManager);
        viewForm.setTopLeft((Control)toolBar);
    }

    public void createEditor(CompositeMap data) throws ApplicationException {
        this.createEditor();
        this.setData(data);
    }

    public boolean isCategory() {
        return this.isCategory;
    }

    public void setCategory(boolean isCategory) {
        this.isCategory = isCategory;
        this.repaint();
    }

    private void repaint() {
        try {
            this.clear(false);
            this.setData(this.getInput());
        }
        catch (Exception e) {
            DialogUtil.showExceptionMessageBox(e);
        }
    }

    public void refresh() {
        if (this.tableViewer != null && !this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.refresh();
        }
    }

    public void refresh(boolean dirty) {
        if (dirty) {
            this.repaint();
            this.page.refresh(dirty);
        } else {
            this.refresh();
        }
    }

    public CompositeMap getInput() {
        return (CompositeMap)this.tableViewer.getInput();
    }

    private void fillActionToolBars(ToolBarManager actionBarManager) {
        AddPropertyAction addAction = new AddPropertyAction(this, 2);
        RemovePropertyAction removeAction = new RemovePropertyAction(this, 2);
        RefreshAction refreshAction = new RefreshAction(this, 2);
        CategroyAction categroyAction = new CategroyAction(this);
        CharSortAction charSortAction = new CharSortAction(this);
        actionBarManager.add((IContributionItem)this.createActionContributionItem((IAction)addAction));
        actionBarManager.add((IContributionItem)this.createActionContributionItem((IAction)refreshAction));
        actionBarManager.add((IContributionItem)this.createActionContributionItem((IAction)removeAction));
        actionBarManager.add((IContributionItem)this.createActionContributionItem((IAction)categroyAction));
        actionBarManager.add((IContributionItem)this.createActionContributionItem((IAction)charSortAction));
        actionBarManager.update(true);
    }

    private ActionContributionItem createActionContributionItem(IAction action) {
        ActionContributionItem aci = new ActionContributionItem(action);
        aci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        return aci;
    }

    private void addKeyListener() {
        this.tableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    PropertyHashViewer.this.removePropertyAction();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public Control getControl() {
        return this.sashForm;
    }

    public Object getFocus() {
        ISelection selection = this.tableViewer.getSelection();
        if (selection == null) {
            return null;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        AttributeValue av = (AttributeValue)obj;
        return av;
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    public void addEditor(String property, ICellEditor cellEditor) {
        this.customerEditors.put(property, cellEditor);
    }

    public String clearCellEditor(boolean validation) {
        ICellEditor ed;
        Object[] editors = this.customerEditors.values().toArray();
        int i = 0;
        while (i < editors.length) {
            ed = (ICellEditor)editors[i];
            if (validation && !ed.validValue(ed.getSelection())) {
                return ed.getErrorMessage();
            }
            ++i;
        }
        i = 0;
        while (i < editors.length) {
            ed = (ICellEditor)editors[i];
            ed.dispose();
            ++i;
        }
        this.customerEditors.clear();
        return null;
    }

    public void setCellEditors() throws ApplicationException {
        Table table = this.tableViewer.getTable();
        TableItem[] items = table.getItems();
        int i = 0;
        while (i < items.length) {
            ICellEditor cellEditor;
            TableItem item = items[i];
            AttributeValue av = (AttributeValue)item.getData();
            if (!(av instanceof CategoryLabel) && (cellEditor = CellEditorFactory.getInstance().createCellEditor(this, av.getAttribute(), this.getInput(), item)) != null) {
                this.addEditor(av.getAttribute().getLocalName(), cellEditor);
                this.fillTableCellEditor(table, item, av.getAttribute().getQName(), cellEditor);
            }
            ++i;
        }
    }

    private void fillTableCellEditor(Table table, TableItem item, QualifiedName attributeQName, ICellEditor cellEditor) {
        TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.setEditor(cellEditor.getCellControl(), item, 1);
    }

    public Attribute getSelection() {
        ISelection selection = this.tableViewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj == null) {
            return null;
        }
        AttributeValue av = (AttributeValue)obj;
        return av.getAttribute();
    }
}

