/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.fake.uncertain.engine;

import aurora.datasource.DatabaseConnection;
import aurora.ide.fake.uncertain.engine.FakeDataSource;
import aurora.ide.fake.uncertain.engine.InternalPackageManager;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.DriverManagerDataSource;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.sql.DataSource;
import uncertain.cache.CacheFactoryConfig;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.composite.IterationHandle;
import uncertain.core.DirectoryConfig;
import uncertain.core.IContainer;
import uncertain.core.ILifeCycle;
import uncertain.core.UncertainEngine;
import uncertain.event.Configuration;
import uncertain.event.IContextListener;
import uncertain.event.IEventDispatcher;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.BasicConsoleHandler;
import uncertain.logging.BasicFileHandler;
import uncertain.logging.ILogger;
import uncertain.logging.ILoggerProvider;
import uncertain.logging.LoggerProvider;
import uncertain.logging.LoggingTopic;
import uncertain.ocm.ClassRegistry;
import uncertain.ocm.IClassLocator;
import uncertain.ocm.IObjectCreator;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.ocm.ObjectRegistryImpl;
import uncertain.pkg.IInstanceCreationListener;
import uncertain.pkg.IPackageManager;
import uncertain.pkg.PackageManager;
import uncertain.pkg.PackagePath;
import uncertain.proc.IProcedureManager;
import uncertain.proc.ParticipantRegistry;
import uncertain.proc.ProcedureManager;
import uncertain.schema.ISchemaManager;
import uncertain.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeUncertainEngine {
    private SchemaManager mSchemaManager;
    private CompositeLoader compositeLoader;
    private OCManager oc_manager;
    private ClassRegistry classRegistry;
    private InternalPackageManager internalPackageManager;
    private ObjectRegistryImpl objectRegistry;
    private DirectoryConfig directoryConfig;
    private ParticipantRegistry mParticipantRegistry;
    private boolean mIsRunning;
    private Set<String> mLoadedFiles = new HashSet<String>();
    private List<ILifeCycle> mLoadedLifeCycleList = new LinkedList<ILifeCycle>();
    private Set mContextListenerSet = new HashSet();
    private Configuration mConfig;
    private File mConfigDir;
    private static final String mDefaultLogLevel = "WARNING";
    private ILogger mLogger;
    private InnerUncertainEngine engine;
    private ProcedureManager mProcedureManager;
    Map<String, DataSource> datasources;

    public FakeUncertainEngine() {
        this.init();
        this.loadPackageManager();
    }

    public FakeUncertainEngine(String base_dir, String config_dir) {
        this.init();
        this.directoryConfig.setBaseDirectory(base_dir);
        this.directoryConfig.setConfigDirectory(config_dir);
        this.loadPackageManager();
    }

    private InternalPackageManager loadPackageManager() {
        this.internalPackageManager = new InternalPackageManager(this.compositeLoader, this.oc_manager, this.mSchemaManager);
        try {
            this.internalPackageManager.loadPackgeDirectory(AuroraResourceUtil.getClassPathFile("uncertain_builtin_package").getCanonicalPath());
            this.internalPackageManager.loadPackgeDirectory(AuroraResourceUtil.getClassPathFile("aurora_builtin_package").getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            DialogUtil.logErrorException(e);
        }
        return this.internalPackageManager;
    }

    private void init() {
        this.mSchemaManager = new SchemaManager();
        this.mSchemaManager.addSchema(SchemaManager.getSchemaForSchema());
        this.compositeLoader = CompositeLoader.createInstanceForOCM();
        this.objectRegistry = new ObjectRegistryImpl();
        this.oc_manager = new OCManager((IObjectCreator)this.objectRegistry);
        this.classRegistry = this.oc_manager.getClassRegistry();
        this.directoryConfig = DirectoryConfig.createDirectoryConfig();
        this.mParticipantRegistry = new ParticipantRegistry();
        this.setDefaultClassRegistry(this.classRegistry);
        this.registerBuiltinInstances();
    }

    public Configuration createConfig(CompositeMap cfg) {
        Configuration conf = new Configuration(this.mParticipantRegistry, this.oc_manager);
        conf.loadConfig(cfg);
        return conf;
    }

    protected ILoggerProvider createDefaultLoggerProvider() {
        LoggerProvider clp = new LoggerProvider();
        clp.setDefaultLogLevel(mDefaultLogLevel);
        clp.addTopics(new LoggingTopic[]{new LoggingTopic("uncertain.core", Level.INFO), new LoggingTopic("uncertain.ocm", Level.WARNING)});
        String log_path = this.directoryConfig.getLogDirectory();
        if (log_path == null) {
            clp.addHandle((Handler)new BasicConsoleHandler());
        } else {
            BasicFileHandler fh = new BasicFileHandler();
            fh.setLogPath(log_path);
            fh.setLogFilePrefix("Aurora IDE FakeUncertainEngine");
            clp.addHandle((Handler)fh);
        }
        return clp;
    }

    protected void checkLogger() {
        ILoggerProvider logger_provider = (ILoggerProvider)this.objectRegistry.getInstanceOfType(ILoggerProvider.class);
        if (logger_provider == null) {
            logger_provider = this.createDefaultLoggerProvider();
            this.objectRegistry.registerInstance(ILoggerProvider.class, (Object)logger_provider);
            this.oc_manager.setLoggerProvider(logger_provider);
        }
        this.mLogger = logger_provider.getLogger("uncertain.core");
    }

    private void loadInstanceFromPackage() {
        this.internalPackageManager.createInstances((IObjectRegistry)this.objectRegistry, new IInstanceCreationListener(){

            public void onInstanceCreate(Object instance, File config_file) {
                if (!FakeUncertainEngine.this.loadInstance(instance)) {
                    throw BuiltinExceptionFactory.createInstanceStartError((Object)instance, (String)config_file.getAbsolutePath(), null);
                }
                FakeUncertainEngine.this.mLoadedFiles.add(config_file.getAbsolutePath());
            }
        }, true);
    }

    private boolean loadInstance(Object inst) {
        this.mConfig.addParticipant(inst);
        if (inst instanceof IContextListener) {
            this.addContextListener((IContextListener)inst);
        }
        if (inst instanceof ILifeCycle) {
            ILifeCycle c = (ILifeCycle)inst;
            if (c instanceof CacheFactoryConfig) {
                return false;
            }
            if (c.startup()) {
                this.mLoadedLifeCycleList.add(c);
                return true;
            }
            return false;
        }
        return true;
    }

    public void addContextListener(IContextListener listener) {
        this.mContextListenerSet.add(listener);
    }

    public void addPackages(PackagePath[] paths) throws IOException {
        int i = 0;
        while (i < paths.length) {
            this.internalPackageManager.loadPackage(paths[i]);
            ++i;
        }
    }

    private void registerBuiltinInstances() {
        this.engine = new InnerUncertainEngine();
        this.objectRegistry.registerInstanceOnce(IContainer.class, (Object)this.engine);
        this.objectRegistry.registerInstanceOnce(UncertainEngine.class, (Object)this.engine);
        this.objectRegistry.registerInstance(CompositeLoader.class, (Object)this.compositeLoader);
        this.objectRegistry.registerInstance(IClassLocator.class, (Object)this.classRegistry);
        this.objectRegistry.registerInstance(ClassRegistry.class, (Object)this.classRegistry);
        this.objectRegistry.registerInstance(OCManager.class, (Object)this.oc_manager);
        this.objectRegistry.registerInstance(DirectoryConfig.class, (Object)this.directoryConfig);
        this.objectRegistry.registerInstanceOnce(IObjectRegistry.class, (Object)this.objectRegistry);
        this.objectRegistry.registerInstanceOnce(IObjectCreator.class, (Object)this.objectRegistry);
        this.objectRegistry.registerInstance(IPackageManager.class, (Object)this.internalPackageManager);
        this.objectRegistry.registerInstanceOnce(ISchemaManager.class, (Object)this.mSchemaManager);
        this.objectRegistry.registerInstance(ParticipantRegistry.class, (Object)this.mParticipantRegistry);
    }

    private void setDefaultClassRegistry(ClassRegistry mClassRegistry) {
        mClassRegistry.registerPackage("uncertain.proc");
        mClassRegistry.registerPackage("uncertain.ocm");
        mClassRegistry.registerPackage("uncertain.logging");
        mClassRegistry.registerPackage("uncertain.core");
        mClassRegistry.registerPackage("uncertain.core.admin");
        mClassRegistry.registerPackage("uncertain.event");
        mClassRegistry.registerPackage("uncertain.pkg");
        mClassRegistry.registerPackage("uncertain.cache");
        mClassRegistry.registerPackage("uncertain.cache.action");
        mClassRegistry.registerClass("class-registry", "uncertain.ocm", "ClassRegistry");
        mClassRegistry.registerClass("package-mapping", "uncertain.ocm", "PackageMapping");
        mClassRegistry.registerClass("class-mapping", "uncertain.ocm", "ClassMapping");
        mClassRegistry.registerClass("feature-attach", "uncertain.ocm", "FeatureAttach");
        mClassRegistry.registerClass("package-path", "uncertain.pkg", "PackagePath");
    }

    public SchemaManager getmSchemaManager() {
        return this.mSchemaManager;
    }

    public CompositeLoader getCompositeLoader() {
        return this.compositeLoader;
    }

    public OCManager getOc_manager() {
        return this.oc_manager;
    }

    public ClassRegistry getClassRegistry() {
        return this.classRegistry;
    }

    public InternalPackageManager getInternalPackageManager() {
        return this.internalPackageManager;
    }

    public ObjectRegistryImpl getObjectRegistry() {
        return this.objectRegistry;
    }

    private List<DatabaseConnection> loadDataSourceConfig() {
        File configDirectory = new File(this.directoryConfig.getConfigDirectory());
        File config = new File(configDirectory, "/aurora.database/datasource.config");
        if (!config.exists()) {
            config = new File(configDirectory, "0.datasource.config");
        }
        final ArrayList<DatabaseConnection> dss = new ArrayList<DatabaseConnection>();
        if (!config.exists()) {
            return dss;
        }
        CompositeMap loadFile = CompositeMapUtil.loadFile(config);
        loadFile.iterate(new IterationHandle(){

            public int process(CompositeMap map) {
                if ("database-connection".equalsIgnoreCase(map.getName())) {
                    DatabaseConnection dc = new DatabaseConnection();
                    dc.setName(CompositeMapUtil.getValueIgnoreCase(map, "name"));
                    dc.setDriverClass(CompositeMapUtil.getValueIgnoreCase(map, "driverClass"));
                    dc.setUrl(CompositeMapUtil.getValueIgnoreCase(map, "url"));
                    dc.setUserName(CompositeMapUtil.getValueIgnoreCase(map, "userName"));
                    dc.setPassword(CompositeMapUtil.getValueIgnoreCase(map, "password"));
                    dss.add(dc);
                }
                return 0;
            }
        }, true);
        return dss;
    }

    public void startup() {
        long tick = System.currentTimeMillis();
        this.mIsRunning = false;
        this.mConfig = this.createConfig();
        this.checkLogger();
        this.mConfig.setLogger(this.mLogger);
        this.setProcedureManager(new ProcedureManager((UncertainEngine)this.engine));
        this.loadInstanceFromPackage();
        this.datasources = new HashMap<String, DataSource>();
        List<DatabaseConnection> loadDataSourceConfig = this.loadDataSourceConfig();
        this.createDatasource2(loadDataSourceConfig);
        this.mIsRunning = this.isSuccess();
        tick = System.currentTimeMillis() - tick;
    }

    public void createDatasource2(List<DatabaseConnection> loadDataSourceConfig) {
        for (DatabaseConnection dbConfig : loadDataSourceConfig) {
            DataSource ds = null;
            ds = FakeDataSource.createDataSource(dbConfig);
            this.datasources.put(dbConfig.getName(), ds);
        }
    }

    public void createDatasource1(List<DatabaseConnection> loadDataSourceConfig) {
        for (DatabaseConnection dc : loadDataSourceConfig) {
            try {
                DriverManagerDataSource ds = (DriverManagerDataSource)DataSources.unpooledDataSource();
                ds.setDriverClass(dc.getDriverClass());
                ds.setDescription(dc.getName());
                ds.setJdbcUrl(dc.getUrl());
                ds.setPassword(dc.getPassword());
                ds.setUser(dc.getUserName());
                this.datasources.put(dc.getName(), (DataSource)ds);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isSuccess() {
        return this.datasources.size() > 0;
    }

    public void initialize(CompositeMap config) {
    }

    public File getConfigDirectory() {
        String dir;
        if (this.mConfigDir == null && (dir = this.directoryConfig.getConfigDirectory()) != null) {
            this.mConfigDir = new File(dir);
        }
        return this.mConfigDir;
    }

    public void shutdown() {
        for (ILifeCycle l : this.mLoadedLifeCycleList) {
            try {
                l.shutdown();
            }
            catch (Throwable thr) {
                this.mLogger.log(Level.WARNING, "Error when shuting down instance " + l, thr);
            }
        }
        this.mIsRunning = false;
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    public Configuration createConfig() {
        Configuration conf = new Configuration(this.mParticipantRegistry, this.oc_manager);
        return conf;
    }

    public IEventDispatcher getEventDispatcher() {
        return this.mConfig;
    }

    public ProcedureManager getProcedureManager() {
        return this.mProcedureManager;
    }

    public void setProcedureManager(ProcedureManager mProcedureManager) {
        this.mProcedureManager = mProcedureManager;
    }

    public DataSource getDatasource(String string) {
        if (this.datasources == null) {
            return null;
        }
        return this.datasources.get(string);
    }

    public DataSource getDefaultDatasource() {
        if (this.datasources == null) {
            return null;
        }
        return this.datasources.get(null);
    }

    private class InnerUncertainEngine
    extends UncertainEngine {
        private InnerUncertainEngine() {
        }

        protected void bootstrap() {
        }

        public void initialize(CompositeMap config) {
        }

        protected ILoggerProvider createDefaultLoggerProvider() {
            return null;
        }

        protected void checkLogger() {
        }

        public void addLoggingConfig(ILoggerProvider logging_config) {
            super.addLoggingConfig(logging_config);
        }

        public ILogger getLogger(String topic) {
            return FakeUncertainEngine.this.mLogger;
        }

        public void logException(String message, Throwable thr) {
        }

        public void loadConfigFile(String full_path) {
        }

        public Configuration createConfig() {
            return FakeUncertainEngine.this.createConfig();
        }

        public Configuration createConfig(CompositeMap cfg) {
            return FakeUncertainEngine.this.createConfig(cfg);
        }

        public void initContext(CompositeMap context) {
        }

        public void destroyContext(CompositeMap context) {
        }

        public void addPackages(PackagePath[] paths) throws IOException {
            FakeUncertainEngine.this.addPackages(paths);
        }

        public Throwable getInitializeException() {
            return null;
        }

        public boolean isRunning() {
            return FakeUncertainEngine.this.isRunning();
        }

        public void setConfigDirectory(File dir) {
        }

        public void addClassRegistry(ClassRegistry reg) {
        }

        public void addClassRegistry(ClassRegistry reg, boolean override) {
        }

        public ClassRegistry getClassRegistry() {
            return FakeUncertainEngine.this.getClassRegistry();
        }

        public CompositeLoader getCompositeLoader() {
            return FakeUncertainEngine.this.getCompositeLoader();
        }

        public OCManager getOcManager() {
            return FakeUncertainEngine.this.getOc_manager();
        }

        public IObjectCreator getObjectCreator() {
            return FakeUncertainEngine.this.getObjectRegistry();
        }

        public IObjectRegistry getObjectRegistry() {
            return FakeUncertainEngine.this.getObjectRegistry();
        }

        public IEventDispatcher getEventDispatcher() {
            return FakeUncertainEngine.this.getEventDispatcher();
        }

        public ParticipantRegistry getParticipantRegistry() {
            return null;
        }

        public CompositeMap getGlobalContext() {
            return null;
        }

        public File getConfigDirectory() {
            return FakeUncertainEngine.this.getConfigDirectory();
        }

        public boolean getIsRunning() {
            return FakeUncertainEngine.this.isRunning();
        }

        public void addContextListener(IContextListener listener) {
            FakeUncertainEngine.this.addContextListener(listener);
        }

        public void startup() {
        }

        public void startup(boolean scan_config_files) {
        }

        public void shutdown() {
        }

        public DirectoryConfig getDirectoryConfig() {
            return FakeUncertainEngine.this.directoryConfig;
        }

        public IProcedureManager getProcedureManager() {
            return FakeUncertainEngine.this.getProcedureManager();
        }

        public String getName() {
            return "Aurora IDE FakeUncertainEngine";
        }

        public String getMBeanName(String category, String sub_name) {
            return "";
        }

        public void setName(String name) {
        }

        public String getDefaultLogLevel() {
            return super.getDefaultLogLevel();
        }

        public void setDefaultLogLevel(String defaultLogLevel) {
            super.setDefaultLogLevel(defaultLogLevel);
        }

        public PackageManager getPackageManager() {
            return FakeUncertainEngine.this.getInternalPackageManager();
        }

        public ISchemaManager getSchemaManager() {
            return FakeUncertainEngine.this.getmSchemaManager();
        }

        public void registerMBean() {
        }

        public boolean isContinueLoadConfigWithException() {
            return super.isContinueLoadConfigWithException();
        }

        public void setContinueLoadConfigWithException(boolean continueLoadConfigWithException) {
            super.setContinueLoadConfigWithException(continueLoadConfigWithException);
        }
    }
}

