/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.helpers;

import aurora.ide.helpers.StringUtil;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class BundleUtil {
    private static String NL_TAG = "$nl$/";

    public static boolean bundleHasValidState(Bundle bundle) {
        if (bundle == null || bundle.getState() == 1 || bundle.getState() == 2) {
            if (bundle != null) {
                String string = StringUtil.concat("Universal Welcome tried accessing Bundle: ", BundleUtil.getBundleHeader(bundle, "Bundle-Name"), " vendor: ", BundleUtil.getBundleHeader(bundle, "Bundle-Vendor"), " bundle state: ", String.valueOf(bundle.getState())).toString();
            }
            return false;
        }
        return true;
    }

    public static String getBundleHeader(Bundle bundle, String key) {
        return (String)bundle.getHeaders().get(key);
    }

    public static Bundle getBundleFromConfigurationElement(IConfigurationElement cfg) {
        return Platform.getBundle((String)cfg.getNamespaceIdentifier());
    }

    public static String getResourceLocation(String resource, IConfigurationElement element) {
        Bundle bundle = BundleUtil.getBundleFromConfigurationElement(element);
        return BundleUtil.getResolvedResourceLocation(resource, bundle, false);
    }

    public static String getResolvedResourceLocation(String resource, String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        return BundleUtil.getResolvedResourceLocation(resource, bundle, true);
    }

    public static String getResolvedResourceLocation(String resource, Bundle bundle) {
        return BundleUtil.getResolvedResourceLocation(resource, bundle, true);
    }

    public static String getResolvedResourceLocation(String base, String resource, Bundle bundle) {
        if (resource == null) {
            return null;
        }
        String fullResource = new Path(base).append(resource).toString();
        String resolvedResource = BundleUtil.getResolvedResourceLocation(fullResource, bundle, true);
        if (resolvedResource.equals(fullResource)) {
            return resource;
        }
        return resolvedResource;
    }

    public static String getResolvedResourceLocation(String resource, Bundle bundle, boolean forceNLResolve) {
        if (resource == null) {
            return null;
        }
        if (bundle == null || !BundleUtil.bundleHasValidState(bundle)) {
            return resource;
        }
        URL localLocation = null;
        try {
            Path resourcePath;
            String copyResource = resource;
            if (forceNLResolve && !copyResource.startsWith(NL_TAG)) {
                if (copyResource.startsWith("/") || copyResource.startsWith("\\")) {
                    copyResource = resource.substring(1);
                }
                copyResource = String.valueOf(NL_TAG) + copyResource;
            }
            if ((localLocation = FileLocator.find((Bundle)bundle, (IPath)(resourcePath = new Path(copyResource)), null)) == null) {
                String msg = StringUtil.concat("Could not find resource: ", resource, " in ", BundleUtil.getBundleHeader(bundle, "Bundle-Name")).toString();
                return resource;
            }
            return BundleUtil.toExternalForm(localLocation);
        }
        catch (Exception e) {
            String msg = StringUtil.concat("Failed to load resource: ", resource, " from ", BundleUtil.getBundleHeader(bundle, "Bundle-Name")).toString();
            return resource;
        }
    }

    private static String toExternalForm(URL localURL) {
        try {
            localURL = FileLocator.toFileURL((URL)localURL);
            String result = localURL.toExternalForm();
            if (result.startsWith("file:/") && !result.startsWith("file:///")) {
                result = "file:///" + result.substring(6);
            }
            return result;
        }
        catch (IOException e) {
            String msg = "Failed to resolve URL: " + localURL.toString();
            return localURL.toString();
        }
    }

    public static URL getResourceAsURL(String resource, String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        URL localLocation = FileLocator.find((Bundle)bundle, (IPath)new Path(resource), null);
        return localLocation;
    }

    public static String getResolvedBundleLocation(Bundle bundle) {
        URL bundleLocation;
        block3: {
            try {
                bundleLocation = bundle.getEntry("");
                if (bundleLocation != null) break block3;
                return null;
            }
            catch (IllegalStateException e) {
                return null;
            }
        }
        return BundleUtil.toExternalForm(bundleLocation);
    }

    public static String getResolvedBundleLocation(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            return null;
        }
        return BundleUtil.getResolvedBundleLocation(bundle);
    }
}

