/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.helpers;

import aurora.ide.helpers.ExceptionUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.LogUtil;
import aurora.ide.helpers.SystemException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class DialogUtil {
    public static final String MESSAGEBOX_WARNING = DialogUtil.getLocaleMessage("messagebox.warning");
    public static final String MESSAGEBOX_ERROR = DialogUtil.getLocaleMessage("messagebox.error");
    public static final String MESSAGEBOX_QUESTION = DialogUtil.getLocaleMessage("messagebox.question");

    public static void showMessageBox(int style, String title, String message) {
        Shell shell = DialogUtil.getShell();
        MessageBox messageBox = new MessageBox(shell, style);
        messageBox.setText(title);
        messageBox.setMessage(DialogUtil.getLocaleMessage(message));
        messageBox.open();
    }

    public static void showWarningMessageBox(String message) {
        DialogUtil.showWarningMessageBox(MESSAGEBOX_WARNING, message);
    }

    public static void showWarningMessageBox(String title, String message) {
        Shell shell = DialogUtil.getShell();
        MessageBox messageBox = new MessageBox(shell, 65576);
        message = LocaleMessage.getString(message);
        messageBox.setText(title);
        messageBox.setMessage(DialogUtil.getLocaleMessage(message));
        messageBox.open();
    }

    public static void showErrorMessageBox(String message) {
        DialogUtil.showErrorMessageBox(MESSAGEBOX_ERROR, message);
    }

    public static void showErrorMessageBox(String title, String message) {
        Shell shell = DialogUtil.getShell();
        MessageBox messageBox = new MessageBox(shell, 65569);
        messageBox.setText(title);
        messageBox.setMessage(DialogUtil.getLocaleMessage(message));
        messageBox.open();
    }

    public static void logErrorException(Throwable e) {
        DialogUtil.logErrorException(MESSAGEBOX_ERROR, e);
    }

    public static void showExceptionMessageBox(Throwable e) {
        DialogUtil.logErrorException(e);
        DialogUtil.showExceptionMessageBox(MESSAGEBOX_ERROR, e);
    }

    public static void showExceptionMessageBox(final String title, final Throwable e) {
        Display current = Display.getCurrent();
        (current == null ? Display.getDefault() : current).asyncExec(new Runnable(){

            public void run() {
                Shell shell = DialogUtil.getShell();
                MessageBox messageBox = new MessageBox(shell, 65569);
                messageBox.setText(title);
                String message = ExceptionUtil.getExceptionTraceMessage(e);
                messageBox.setMessage(message);
                messageBox.open();
            }
        });
    }

    public static void logErrorException(String title, Throwable e) {
        SystemException full = new SystemException(e);
        LogUtil.getInstance().logError("aurora ide ", full);
    }

    public static int showConfirmDialogBox(String message) {
        return DialogUtil.showConfirmDialogBox(MESSAGEBOX_QUESTION, message);
    }

    public static int showConfirmDialogBox(String title, String message) {
        Shell shell = DialogUtil.getShell();
        MessageBox messageBox = new MessageBox(shell, 65828);
        messageBox.setText(title);
        messageBox.setMessage(DialogUtil.getLocaleMessage(message));
        int buttonID = messageBox.open();
        return buttonID;
    }

    private static String getLocaleMessage(String message) {
        return LocaleMessage.getString(message);
    }

    private static Shell getShell() {
        Display current = Display.getCurrent();
        Shell shell = (current == null ? Display.getDefault() : current).getActiveShell();
        if (shell == null) {
            shell = new Shell(current);
        }
        return shell;
    }
}

