/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.helpers;

import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraResourceUtil;

public class ExceptionUtil {
    public static Throwable getRootCause(Throwable e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            return e;
        }
        return ExceptionUtil.getRootCause(cause);
    }

    public static String getExceptionTraceMessage(Throwable e) {
        Throwable child;
        if (e == null) {
            return null;
        }
        String messageSeparator = "\u7cfb\u7edf\u63d0\u793a\uff1a" + AuroraResourceUtil.LineSeparator;
        String causeMessage = "";
        String tipMessage = "";
        if (e instanceof ApplicationException) {
            tipMessage = String.valueOf(tipMessage) + ExceptionUtil.getMessage(e) + AuroraResourceUtil.LineSeparator;
        } else {
            causeMessage = String.valueOf(ExceptionUtil.getMessage(e)) + AuroraResourceUtil.LineSeparator;
        }
        Throwable parent = e;
        while ((child = parent.getCause()) != null) {
            if (child instanceof ApplicationException) {
                tipMessage = String.valueOf(tipMessage) + ExceptionUtil.getMessage(child) + AuroraResourceUtil.LineSeparator;
            } else {
                causeMessage = String.valueOf(ExceptionUtil.getMessage(child)) + AuroraResourceUtil.LineSeparator;
            }
            parent = child;
        }
        String message = String.valueOf(causeMessage) + (!"".equals(tipMessage) ? String.valueOf(messageSeparator) + tipMessage : "");
        return message;
    }

    private static String getMessage(Throwable e) {
        if (e instanceof ApplicationException) {
            return e.getLocalizedMessage();
        }
        return e.toString();
    }
}

