/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileCopyer {
    private static final int BUFFER_SIZE = 16384;

    public static boolean copyDirectory(File from, File to) {
        return FileCopyer.copyDirectory(from, to, null, null);
    }

    public static boolean copyDirectory(String from, String to) {
        return FileCopyer.copyDirectory(new File(from), new File(to));
    }

    public static boolean copyDirectory(File from, File to, byte[] buffer, String[] filter) {
        if (from == null) {
            return false;
        }
        if (!from.exists()) {
            return true;
        }
        if (!from.isDirectory()) {
            return false;
        }
        if (to.exists()) {
            return false;
        }
        if (!to.mkdirs()) {
            return false;
        }
        String[] list = from.list();
        if (list != null) {
            if (buffer == null) {
                buffer = new byte[16384];
            }
            int i = 0;
            while (i < list.length) {
                File entry;
                String fileName = list[i];
                if (filter != null) {
                    int j = 0;
                    while (j < filter.length) {
                        if (!fileName.equals(filter[j])) {
                            ++j;
                            continue;
                        }
                        break;
                    }
                } else if ((entry = new File(from, fileName)).isDirectory() ? !FileCopyer.copyDirectory(entry, new File(to, fileName), buffer, filter) : !FileCopyer.copyFile(entry, new File(to, fileName), buffer)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean copyFile(File from, File to) {
        return FileCopyer.copyFile(from, to, null);
    }

    public static boolean copyFile(File from, File to, byte[] buf) {
        if (buf == null) {
            buf = new byte[16384];
        }
        FileInputStream from_s = null;
        FileOutputStream to_s = null;
        try {
            try {
                from_s = new FileInputStream(from);
                to_s = new FileOutputStream(to);
                int bytesRead = from_s.read(buf);
                while (bytesRead != -1) {
                    to_s.write(buf, 0, bytesRead);
                    bytesRead = from_s.read(buf);
                }
                from_s.close();
                from_s = null;
                to_s.getFD().sync();
                to_s.close();
                to_s = null;
            }
            catch (IOException iOException) {
                if (from_s != null) {
                    try {
                        from_s.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                if (to_s != null) {
                    try {
                        to_s.close();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (from_s != null) {
                try {
                    from_s.close();
                }
                catch (IOException iOException) {}
            }
            if (to_s != null) {
                try {
                    to_s.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }
}

