/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.helpers;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;

public class FileExplorer {
    private static String defaultTarget = "shell_open_command {0}";

    static {
        String osName = System.getProperty("os.name");
        if (osName.indexOf("Windows") != -1) {
            defaultTarget = "explorer.exe {0}";
        } else if (osName.indexOf("Mac") != -1) {
            defaultTarget = "open {0}";
        }
    }

    public static void open(String directory) {
        String target = MessageFormat.format(defaultTarget, directory);
        try {
            Runtime.getRuntime().exec(target);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void open(File selected) {
        try {
            File directory = selected.getParentFile();
            FileExplorer.open(directory.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void open(IFile selected) {
        try {
            File directory = selected.getProjectRelativePath().toFile().getParentFile();
            FileExplorer.open(directory.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

