/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.helpers;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ImageUtil {
    public static final String DEFAULT_ROOT_LINK = "rootLink";
    public static final String DEFAULT_SMALL_ROOT_LINK = "rootLinkSmall";
    public static final String DEFAULT_FORM_BG = "formBg";
    public static final String DEFAULT_LINK = "link";
    public static final String BACK = "back";
    public static final String HELP_TOPIC = "helpTopic";
    public static final String RESTORE_WELCOME = "restoreWelcome";
    public static final String INTRO_MODEL_LEAF = "leaf";
    public static final String INTRO_MODEL_CONTAINER = "container";
    public static final String OPEN_ITNRO_VIEW = "introView";
    public static final String CONFIG_EXTENSION = "configExtension";
    public static final String ICONS_PATH = "$nl$/icons/";

    public static ImageDescriptor createImageDescriptor(String imageName) {
        return ImageUtil.createImageDescriptor(Platform.getBundle((String)""), ICONS_PATH + imageName);
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, String imageName) {
        try {
            URL imageUrl = FileLocator.find((Bundle)bundle, (IPath)new Path(imageName), null);
            if (imageUrl != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)imageUrl);
                return desc;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public static ImageDescriptor createImageDescriptor(IPath base, String imageName) {
        try {
            URL imageUrl = new URL(base.append(imageName).toOSString());
            if (imageUrl != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)imageUrl);
                return desc;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public static Image createImage(String imageName) {
        try {
            ImageDescriptor imageDsc = ImageUtil.createImageDescriptor(imageName);
            return imageDsc.createImage();
        }
        catch (Exception e) {
            return ImageDescriptor.getMissingImageDescriptor().createImage();
        }
    }

    public static boolean isHighContrast() {
        if (PlatformUI.isWorkbenchRunning()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (Display.getCurrent() == display) {
                return display.getHighContrast();
            }
        }
        return false;
    }
}

