/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.javascript.search;

import aurora.ide.javascript.Javascript4JSDT;
import aurora.ide.javascript.search.JavascriptSearchService;
import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.core.CompositeMapIteator;
import aurora.ide.search.core.Util;
import aurora.ide.search.reference.MapFinderResult;
import aurora.ide.search.reference.NamedMapFinder;
import aurora.ide.search.ui.LineElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Javascript4JSDTSearchService
extends JavascriptSearchService {
    private List<LineElement> lines = new LinkedList<LineElement>();
    private List<IFile> sources;

    public void setSources(List<IFile> sources) {
        this.sources = sources;
    }

    @Override
    public List<IFile> getSources() {
        return this.sources == null ? (this.sources = new ArrayList<IFile>()) : this.sources;
    }

    @Override
    public void addSource(IFile source) {
        this.getSources().add(source);
    }

    @Override
    public CompositeMapIteator createIterationHandle(IFile file) {
        return new NamedMapFinder("script");
    }

    @Override
    public Collection<? extends AbstractMatch> buildMatchLines(IFile file, List<MapFinderResult> r, Object pattern) {
        return this.buildMatchLines(file, r);
    }

    private Collection<? extends AbstractMatch> buildMatchLines(IFile file, List<MapFinderResult> r) {
        ArrayList<Javascript4JSDT> js = new ArrayList<Javascript4JSDT>();
        for (MapFinderResult result : r) {
            CompositeMap map = result.getMap();
            if (!"script".equalsIgnoreCase(map.getName()) || map.getText() == null) continue;
            js.add(new Javascript4JSDT(map));
        }
        return this.buildMatchLines(file, js.toArray(new Javascript4JSDT[js.size()]));
    }

    private Collection<? extends AbstractMatch> buildMatchLines(IFile file, Javascript4JSDT[] js) {
        ArrayList<AbstractMatch> matchs = new ArrayList<AbstractMatch>();
        Javascript4JSDT[] javascript4JSDTArray = js;
        int n = js.length;
        int n2 = 0;
        while (n2 < n) {
            Javascript4JSDT j = javascript4JSDTArray[n2];
            matchs.addAll(this.buildMatchLines(file, j));
            ++n2;
        }
        return matchs;
    }

    private List<AbstractMatch> buildMatchLines(IFile file, Javascript4JSDT j) {
        ArrayList<AbstractMatch> matchs = new ArrayList<AbstractMatch>();
        return matchs;
    }

    private String isMatch(IFile file, String subString) {
        IFile findScreenFile = Util.findScreenFile(file, subString);
        boolean isScreen = this.getSources().contains(findScreenFile);
        if (isScreen) {
            return (String)this.createPattern(null, findScreenFile);
        }
        for (IFile f : this.getSources()) {
            Object createPattern;
            boolean bmRefMatch;
            if (!"bm".equalsIgnoreCase(f.getFileExtension()) || !(bmRefMatch = Util.bmRefMatch(createPattern = this.createPattern(null, f), subString))) continue;
            return createPattern.toString();
        }
        return null;
    }

    private LineElement getLineElement(IFile file, int ln, int offset, String content) {
        for (LineElement l : this.lines) {
            if (!file.equals((Object)l.getParent()) || l.getLine() != ln) continue;
            return l;
        }
        LineElement le = new LineElement((IResource)file, ln, offset, content);
        this.lines.add(le);
        return le;
    }

    protected Object createPattern(IResource scope, Object source) {
        if (source instanceof IFile) {
            IFile file = (IFile)source;
            String fileExtension = file.getFileExtension();
            if ("bm".equalsIgnoreCase(fileExtension)) {
                return this.getBMPKG(scope, file);
            }
            if ("screen".equalsIgnoreCase(fileExtension) || "svc".equalsIgnoreCase(fileExtension)) {
                return this.getScreenPKG(scope, file);
            }
        }
        return null;
    }

    private Object getScreenPKG(IResource scope, IFile file) {
        return file.getName();
    }

    private Object getBMPKG(IResource scope, IFile file) {
        return Util.toBMPKG(file);
    }
}

