/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.navigator;

import aurora.ide.bm.BMUtil;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.ImagesUtils;
import aurora.ide.navigator.BMFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;
import uncertain.composite.CompositeMap;

public class BMFileLabelProvider
extends LabelProvider {
    public final int LimitDescLength = 15;
    private ResourceManager resourceManager;

    public String getText(Object element) {
        IResource resource = this.resolveObject(element);
        if (resource != null) {
            String resourceName = resource.getName();
            if (!resourceName.toLowerCase().endsWith(".bm")) {
                return resourceName;
            }
            try {
                String text = this.getBMDescription(resource);
                if (text != null) {
                    resourceName = String.valueOf(resourceName) + text;
                }
                return resourceName;
            }
            catch (ApplicationException e) {
                return resourceName;
            }
        }
        return element == null ? "" : element.toString();
    }

    private ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }

    protected final Object getAdapter(Object sourceObject) {
        Object result;
        IAdaptable adaptable;
        Object result2;
        Class<IWorkbenchAdapter> adapterType = IWorkbenchAdapter.class;
        if (sourceObject == null) {
            return null;
        }
        if (adapterType.isInstance(sourceObject)) {
            return sourceObject;
        }
        if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapterType)) != null) {
            Assert.isTrue((boolean)adapterType.isInstance(result2));
            return result2;
        }
        if (!(sourceObject instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(sourceObject, adapterType)) != null) {
            return result;
        }
        return null;
    }

    public Image getImage(Object element) {
        IResource resource = this.resolveObject(element);
        if (resource == null) {
            return null;
        }
        if ("bm".equalsIgnoreCase(resource.getFileExtension())) {
            try {
                if (this.isHasOperation(resource)) {
                    return ImagesUtils.getImage("sql.gif");
                }
            }
            catch (ApplicationException e) {
                return ImagesUtils.getImage("bm.gif");
            }
            return ImagesUtils.getImage("bm.gif");
        }
        if (element instanceof IResource) {
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)this.getAdapter(element);
            if (adapter == null) {
                return null;
            }
            ImageDescriptor descriptor = adapter.getImageDescriptor(element);
            if (descriptor == null) {
                return null;
            }
            return (Image)this.getResourceManager().get((DeviceResourceDescriptor)descriptor);
        }
        return null;
    }

    private IResource resolveObject(Object element) {
        IResource resource = null;
        if (element instanceof BMFile) {
            BMFile file = (BMFile)((Object)element);
            resource = ResourcesPlugin.getWorkspace().getRoot().findMember(file.getPath());
        }
        if (element instanceof IResource) {
            resource = (IResource)element;
        }
        return resource;
    }

    private String getBMDescription(IResource file) throws ApplicationException {
        String bmDesc = BMUtil.getBMDescription(file);
        if (bmDesc == null) {
            return null;
        }
        if (15 >= bmDesc.length()) {
            return this.formatDesc(bmDesc);
        }
        return this.formatDesc(String.valueOf(bmDesc.substring(0, 12)) + "...");
    }

    private boolean isHasOperation(IResource file) throws ApplicationException {
        String OperationsNode = "operations";
        CompositeMap bmData = AuroraResourceUtil.loadFromResource(file);
        if (bmData == null) {
            return false;
        }
        return bmData.getChild(OperationsNode) != null;
    }

    private String formatDesc(String desc) {
        if (desc == null) {
            return null;
        }
        return " {" + desc + "}";
    }
}

