/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.navigator.action;

import aurora.ide.fake.uncertain.engine.InstanceFactory;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import uncertain.pkg.PackageManager;

public class SxsdPackageValidAction
implements IObjectActionDelegate {
    ISelection selection;
    private static final String CONFIG_PATH = "config";

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structured = (IStructuredSelection)this.selection;
        IResource type = (IResource)structured.getFirstElement();
        File selectedFile = type.getLocation().toFile();
        String fileList = "";
        try {
            PackageManager pkgManager = InstanceFactory.getPackageManager();
            pkgManager.loadPackgeDirectory(selectedFile.getAbsolutePath());
            File[] files = selectedFile.listFiles();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isDirectory() && PackageManager.isPackageDirectory((File)file)) {
                    File mConfigPathFile = new File(file.getPath(), CONFIG_PATH);
                    if (mConfigPathFile == null) {
                        return;
                    }
                    String extension = ".sxsd";
                    File[] sxsdFiles = mConfigPathFile.listFiles();
                    if (sxsdFiles == null) {
                        return;
                    }
                    int k = 0;
                    while (k < sxsdFiles.length) {
                        String projectName = type.getProject().getName();
                        String sxsdFile = sxsdFiles[k].getName().toLowerCase();
                        String projectBaseName = String.valueOf(projectName) + "/" + type.getProjectRelativePath().toString() + file.getName() + "/" + mConfigPathFile.getName() + "/" + sxsdFiles[k].getName();
                        if (sxsdFile.endsWith(extension)) {
                            fileList = String.valueOf(fileList) + projectBaseName + "\r\n";
                        }
                        ++k;
                    }
                }
                ++i;
            }
            fileList = !fileList.equals("") ? String.valueOf(LocaleMessage.getString("valid.sxsd.file.window.title")) + "\r\n" + fileList : LocaleMessage.getString("no.file.is.valid");
            DialogUtil.showMessageBox(2, "Result", fileList);
        }
        catch (Exception e) {
            DialogUtil.showExceptionMessageBox(e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

