/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.refactoring;

import aurora.ide.search.core.Util;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderRefactorParticipant {
    private IFolder currentFolder;
    private ScopeVisitor visitor;
    private boolean isBMFolder = false;

    public boolean initialize(Object element) {
        if (element instanceof IFolder) {
            this.currentFolder = (IFolder)element;
            this.isBMFolder = false;
            this.visitor = new ScopeVisitor();
            return this.isTakeIn(this.currentFolder);
        }
        return false;
    }

    public boolean isTakeIn(IFolder currentFolder) {
        IContainer webInf = Util.findWebInf((IResource)currentFolder);
        if (webInf == null) {
            return false;
        }
        IPath webInfPath = webInf.getProjectRelativePath();
        IPath classesPath = webInfPath.append("classes");
        IPath webPath = webInf.getParent().getProjectRelativePath();
        IPath deletePath = currentFolder.getProjectRelativePath();
        boolean webPathPrefixOf = webPath.isPrefixOf(deletePath);
        boolean webInfPathPrefixOf = webInfPath.isPrefixOf(deletePath);
        boolean classesPathPrefixOf = classesPath.isPrefixOf(deletePath);
        if (classesPathPrefixOf) {
            this.isBMFolder = true;
            try {
                currentFolder.accept((IResourceVisitor)this.visitor);
            }
            catch (CoreException e) {
                return false;
            }
            return true;
        }
        if (!webInfPathPrefixOf && webPathPrefixOf) {
            this.isBMFolder = false;
            try {
                currentFolder.accept((IResourceVisitor)this.visitor);
            }
            catch (CoreException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getName() {
        return "Folder Refactor Participant";
    }

    public List<IFile> getFiles() {
        return this.visitor.getResult();
    }

    public boolean isBMFolder() {
        return this.isBMFolder;
    }

    public IFolder getCurrentFolder() {
        return this.currentFolder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScopeVisitor
    implements IResourceVisitor {
        private List<IFile> result = new ArrayList<IFile>();

        private ScopeVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1) {
                boolean checkExtension = this.checkExtension(resource);
                if (checkExtension) {
                    this.result.add((IFile)resource);
                }
                return false;
            }
            return true;
        }

        public List<IFile> getResult() {
            return this.result;
        }

        private boolean checkExtension(IResource resource) {
            String fileExtension = resource.getFileExtension();
            return FolderRefactorParticipant.this.isBMFolder ? "bm".equalsIgnoreCase(fileExtension) : "screen".equalsIgnoreCase(fileExtension) || "svc".equalsIgnoreCase(fileExtension);
        }
    }
}

