/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.refactoring;

import aurora.ide.preferencepages.RefactorSettingPreferencePage;
import aurora.ide.refactoring.FolderRefactorParticipant;
import aurora.ide.refactoring.ScreenRefactoring;
import aurora.ide.refactoring.TextFileChangeManager;
import aurora.ide.search.cache.CacheManager;
import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.core.Util;
import aurora.ide.search.reference.MultiSourceReferenceSearchService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class FolderRenameParticipant
extends RenameParticipant {
    private FolderRefactorParticipant folderRefactorParticipant;
    private Map<String, String> pkgMap;
    private TextFileChangeManager changeManager;
    private boolean check;

    protected boolean initialize(Object element) {
        String newName = this.getArguments().getNewName();
        if ("web-inf".equalsIgnoreCase(newName) || "classes".equalsIgnoreCase(newName)) {
            return false;
        }
        this.folderRefactorParticipant = new FolderRefactorParticipant();
        this.changeManager = new TextFileChangeManager();
        return this.folderRefactorParticipant.initialize(element);
    }

    public String getName() {
        return "Folder Rename Participant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        this.check = true;
        RefactoringStatus result = new RefactoringStatus();
        boolean refactorStatus = RefactorSettingPreferencePage.getRefactorStatus("refactor_setting_folder_rename");
        if (!refactorStatus) {
            this.check = false;
            result.merge(RefactoringStatus.createInfoStatus((String)"IDE\u8bbe\u7f6e\u4fee\u6539\u76ee\u5f55\u540d\u4e0d\u542f\u7528\u91cd\u6784."));
            return result;
        }
        IFolder currentFolder = this.folderRefactorParticipant.getCurrentFolder();
        if (currentFolder.equals((Object)Util.findWebInf((IResource)currentFolder).getParent())) {
            this.check = false;
            result.merge(RefactoringStatus.createInfoStatus((String)"\u91cd\u6784\u76ee\u5f55\u662fWeb\u4e3b\u76ee\u5f55\uff0cAurora\u91cd\u6784\u4e0d\u4f1a\u8fdb\u884c\u3002"));
        }
        if (currentFolder.equals((Object)Util.findBMHome((IResource)currentFolder))) {
            this.check = false;
            result.merge(RefactoringStatus.createInfoStatus((String)"\u91cd\u6784\u76ee\u5f55\u662fBM\u4e3b\u76ee\u5f55\uff0cAurora\u91cd\u6784\u4e0d\u4f1a\u8fdb\u884c\u3002"));
        }
        if (this.getArguments().getNewName().contains(".")) {
            this.check = false;
            result.merge(RefactoringStatus.createInfoStatus((String)"\u65b0\u76ee\u5f55\u540d\u5b57\u9519\u8bef\uff0cAurora\u91cd\u6784\u4e0d\u4f1a\u8fdb\u884c\u3002"));
        }
        return result;
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.check) {
            return null;
        }
        if (this.folderRefactorParticipant.isBMFolder()) {
            this.createPKGMap();
            return this.createBMChange(pm);
        }
        return this.createScreenChange(pm);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    private Change createScreenChange(IProgressMonitor pm) throws CoreException {
        List<IFile> result = this.folderRefactorParticipant.getFiles();
        IResource scope = Util.getScope((IResource)this.folderRefactorParticipant.getCurrentFolder());
        if (scope == null) {
            return null;
        }
        MultiSourceReferenceSearchService seachService = new MultiSourceReferenceSearchService(scope, result.toArray(new IFile[result.size()]), null, this.folderRefactorParticipant.isBMFolder());
        seachService.setPostException(false);
        List<AbstractMatch> relations = seachService.service(pm);
        CompositeChange changes = new CompositeChange("aurora changes");
        changes.markAsSynthetic();
        int i = 0;
        while (i < relations.size()) {
            AbstractMatch object = relations.get(i);
            IFile file = (IFile)object.getElement();
            TextFileChange textFileChange = this.changeManager.getTextFileChangeInProcessor(this.getProcessor(), file);
            if (textFileChange == null) {
                textFileChange = this.changeManager.getTextFileChange(file);
            }
            try {
                TextEdit edit = this.createScreenEdit(object);
                if (edit != null) {
                    textFileChange.addEdit(edit);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            ++i;
        }
        changes.addAll((Change[])this.changeManager.getAllChangesHasEdit());
        return changes;
    }

    private TextEdit createScreenEdit(AbstractMatch match) throws CoreException, BadLocationException {
        int length;
        int offset;
        IFile file = (IFile)match.getElement();
        if (this.changeManager.isOverlapping(file, offset = match.getOriginalOffset(), length = match.getOriginalLength())) {
            return null;
        }
        String string = ScreenRefactoring.findAttributeValue(match);
        IFile findScreenFile = Util.findScreenFile(file, string);
        if (findScreenFile == null) {
            return null;
        }
        if (findScreenFile.getParent().equals((Object)file.getParent())) {
            return null;
        }
        IPath folderPath = this.folderRefactorParticipant.getCurrentFolder().getProjectRelativePath();
        IPath newPath = folderPath.removeLastSegments(1).append(this.getArguments().getNewName()).append(findScreenFile.getProjectRelativePath().makeRelativeTo(folderPath));
        return ScreenRefactoring.createMoveTOScreenTextEdit(match, newPath);
    }

    private void createPKGMap() {
        this.pkgMap = new HashMap<String, String>();
        List<IFile> result = this.folderRefactorParticipant.getFiles();
        for (IFile file : result) {
            String oldPkg = Util.toBMPKG(file);
            IPath folderPath = this.folderRefactorParticipant.getCurrentFolder().getProjectRelativePath();
            IPath filePath = file.getProjectRelativePath();
            IPath raelativeTo = filePath.makeRelativeTo(folderPath);
            IPath newPath = folderPath.removeLastSegments(1).append(this.getArguments().getNewName());
            IPath oo = newPath.append(raelativeTo).removeFileExtension();
            String newPkg = Util.toPKG(oo);
            this.pkgMap.put(oldPkg, newPkg);
        }
    }

    private Change createBMChange(IProgressMonitor pm) throws CoreException {
        List<IFile> result = this.folderRefactorParticipant.getFiles();
        IResource scope = Util.getScope((IResource)this.folderRefactorParticipant.getCurrentFolder());
        if (scope == null) {
            return null;
        }
        MultiSourceReferenceSearchService seachService = new MultiSourceReferenceSearchService(scope, result.toArray(new IFile[result.size()]), null, this.folderRefactorParticipant.isBMFolder());
        seachService.setPostException(false);
        List<AbstractMatch> relations = seachService.service(pm);
        CompositeChange changes = new CompositeChange("aurora changes");
        changes.markAsSynthetic();
        int i = 0;
        while (i < relations.size()) {
            int length;
            int offset;
            AbstractMatch object = relations.get(i);
            IFile file = (IFile)object.getElement();
            IDocument document = this.getDocument(file);
            TextFileChange textFileChange = this.changeManager.getTextFileChangeInProcessor(this.getProcessor(), file);
            if (textFileChange == null) {
                textFileChange = this.changeManager.getTextFileChange(file);
            }
            if (!this.changeManager.isOverlapping(file, offset = object.getOriginalOffset(), length = object.getOriginalLength())) {
                try {
                    String string = document.get(offset, length);
                    ReplaceEdit edit = new ReplaceEdit(offset, length, this.pkgMap.get(string));
                    textFileChange.addEdit((TextEdit)edit);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            ++i;
        }
        changes.addAll((Change[])this.changeManager.getAllChanges());
        return changes;
    }

    public IDocument getDocument(IFile file) throws CoreException {
        return CacheManager.getDocument(file);
    }
}

