/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.refactoring;

import aurora.ide.refactoring.RefactoringReplaceInfo;
import aurora.ide.refactoring.TextFileChangeManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ReplaceRefactoring
extends Refactoring {
    private RefactoringReplaceInfo[] infos;
    private TextFileChangeManager changeManager;

    public ReplaceRefactoring(RefactoringReplaceInfo[] infos) {
        this.infos = infos;
        this.changeManager = new TextFileChangeManager();
        this.init(infos);
    }

    private void init(RefactoringReplaceInfo[] lines) {
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange changes = new CompositeChange("aurora changes");
        changes.markAsSynthetic();
        RefactoringReplaceInfo[] refactoringReplaceInfoArray = this.infos;
        int n = this.infos.length;
        int n2 = 0;
        while (n2 < n) {
            RefactoringReplaceInfo info = refactoringReplaceInfoArray[n2];
            IFile file = info.getFile();
            TextFileChange textFileChange = this.getTextFileChange(file);
            IRegion region = info.getRegion();
            boolean overlapping = this.changeManager.isOverlapping(file, region.getOffset(), region.getLength());
            if (!overlapping) {
                ReplaceEdit child = new ReplaceEdit(region.getOffset(), region.getLength(), info.getReplaceWith());
                try {
                    textFileChange.addEdit((TextEdit)child);
                }
                catch (MalformedTreeException malformedTreeException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        changes.addAll((Change[])this.changeManager.getAllChanges());
        return changes;
    }

    private TextFileChange getTextFileChange(IFile file) {
        return this.changeManager.getTextFileChange(file);
    }

    public String getName() {
        return "Replace Refactoring";
    }
}

