/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.refactoring;

import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.search.cache.CacheManager;
import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.core.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ScreenRefactoring {
    public static final IPath requestPath = new Path("${/request/@context_path}");

    public static IDocument getDocument(IFile file) throws CoreException {
        return CacheManager.getDocument(file);
    }

    public static TextEdit createMoveTOScreenTextEdit(AbstractMatch match, IPath newPath) throws CoreException, BadLocationException {
        int offset = match.getOriginalOffset();
        IFile mf = (IFile)match.getElement();
        IDocument document = ScreenRefactoring.getDocument(mf);
        ITypedRegion partition = document.getPartition(offset);
        IRegion valueRegion = Util.getValueRegion(partition.getOffset(), partition.getLength(), offset, document, IColorConstants.STRING);
        String value = document.get(valueRegion.getOffset() + 1, valueRegion.getLength() - 2);
        String newPkg = ScreenRefactoring.createMoveTOScreenPkg(value, mf, newPath);
        ReplaceEdit edit = new ReplaceEdit(valueRegion.getOffset() + 1, valueRegion.getLength() - 2, newPkg);
        return edit;
    }

    public static String findAttributeValue(AbstractMatch match) throws CoreException, BadLocationException {
        IFile mf = (IFile)match.getElement();
        IRegion valueRegion = ScreenRefactoring.findAttributeValueRegion(match);
        IDocument document = ScreenRefactoring.getDocument(mf);
        String value = document.get(valueRegion.getOffset() + 1, valueRegion.getLength() - 2);
        return value;
    }

    public static IRegion findAttributeValueRegion(AbstractMatch match) throws CoreException, BadLocationException {
        int offset = match.getOriginalOffset();
        IFile mf = (IFile)match.getElement();
        IDocument document = ScreenRefactoring.getDocument(mf);
        ITypedRegion partition = document.getPartition(offset);
        IRegion valueRegion = Util.getValueRegion(partition.getOffset(), partition.getLength(), offset, document, IColorConstants.STRING);
        return valueRegion;
    }

    public static String createMoveTOScreenPkg(String changeValue, IFile targetFile, IPath newPath) {
        boolean prefixOfRequest;
        IContainer webInf = Util.findWebInf((IResource)targetFile);
        if (webInf == null) {
            return "";
        }
        IContainer webRoot = webInf.getParent();
        Path path = new Path(changeValue);
        String qPath = "";
        String[] split = changeValue.split("\\?");
        if (changeValue.length() > 1) {
            int i = 1;
            while (i < split.length) {
                qPath = "?" + split[i];
                ++i;
            }
        }
        if (prefixOfRequest = requestPath.isPrefixOf((IPath)(path = new Path(split[0])))) {
            path = path.makeRelativeTo(requestPath);
            newPath = newPath.makeRelativeTo(webRoot.getProjectRelativePath());
            newPath = requestPath.append(newPath);
        } else {
            newPath = newPath.makeRelativeTo(targetFile.getParent().getProjectRelativePath());
        }
        if (qPath.length() > 0) {
            return String.valueOf(newPath.toString()) + qPath;
        }
        return newPath.toString();
    }
}

