/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.screen.editor;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.component.wizard.DataSetWizard;
import aurora.ide.editor.CompositeMapTreePage;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraConstant;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.ProjectUtil;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.part.ResourceTransfer;
import uncertain.composite.CompositeMap;
import uncertain.schema.Element;

public class ServiceTreePage
extends CompositeMapTreePage {
    protected static final String PageId = "ServicePage";
    protected static final String PageTitle = LocaleMessage.getString("screen.file");

    public ServiceTreePage(FormEditor editor) {
        super(editor, PageId, PageTitle);
    }

    protected void createContent(Composite shell) throws ApplicationException {
        super.createContent(shell);
        this.fillDNDListener();
    }

    public void fillDNDListener() {
        DragSource ds = new DragSource(this.getControl(), 3);
        ds.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        ds.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
            }
        });
        DropTarget dt = new DropTarget(this.getControl(), 3);
        final LocalSelectionTransfer localSelectionTransfer = LocalSelectionTransfer.getTransfer();
        final ResourceTransfer resourceTransfer = ResourceTransfer.getInstance();
        dt.setTransfer(new Transfer[]{localSelectionTransfer, resourceTransfer});
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
                int i = 0;
                while (i < event.dataTypes.length) {
                    if (resourceTransfer.isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                        if (event.detail == 1) break;
                        event.detail = 0;
                        break;
                    }
                    ++i;
                }
            }

            public void drop(DropTargetEvent event) {
                if (resourceTransfer.isSupportedType(event.currentDataType)) {
                    Object data = event.data;
                    if (data != null) {
                        DataSetWizard wizard;
                        WizardDialog dialog;
                        CompositeMap dataSets;
                        Element element = CompositeMapUtil.getElement(this.getInput());
                        if (element == null || !element.getQName().equals((Object)AuroraConstant.ScreenQN)) {
                            DialogUtil.showErrorMessageBox("this.is.not.screen.file");
                            return;
                        }
                        IResource[] resources = (IResource[])data;
                        String bmfile_dir = null;
                        String bmFiles = "";
                        try {
                            bmfile_dir = ServiceTreePage.this.getFullPath();
                        }
                        catch (Exception e) {
                            DialogUtil.showExceptionMessageBox(e);
                        }
                        int i = 0;
                        while (i < resources.length) {
                            IResource resource = resources[i];
                            String filePath = resource.getLocation().toOSString();
                            if (filePath.toLowerCase().endsWith("bm")) {
                                String className = ServiceTreePage.this.getClassName(new File(filePath), bmfile_dir);
                                bmFiles = String.valueOf(bmFiles) + className + ",";
                            }
                            ++i;
                        }
                        CompositeMap input = this.getInput();
                        CompositeMap view = input.getChild(AuroraConstant.ViewQN.getLocalName());
                        if (view == null) {
                            String prefix = CompositeMapUtil.getContextPrefix(input, AuroraConstant.ViewQN);
                            view = new CommentCompositeMap(prefix, AuroraConstant.ViewQN.getNameSpace(), AuroraConstant.ViewQN.getLocalName());
                            view.setParent(input);
                            input.addChild(view);
                        }
                        if ((dataSets = view.getChild(AuroraConstant.DataSetSQN.getLocalName())) == null) {
                            String prefix = CompositeMapUtil.getContextPrefix(input, AuroraConstant.DataSetSQN);
                            dataSets = new CommentCompositeMap(prefix, AuroraConstant.DataSetSQN.getNameSpace(), AuroraConstant.DataSetSQN.getLocalName());
                            view.addChild(dataSets);
                            dataSets.setParent(view);
                        }
                        if ((dialog = new WizardDialog(new Shell(), (IWizard)(wizard = new DataSetWizard(dataSets, bmFiles)))).open() == 0) {
                            ServiceTreePage.this.refresh(true);
                        }
                    }
                } else if (localSelectionTransfer.isSupportedType(event.currentDataType)) {
                    CompositeMap sourceCm = ServiceTreePage.this.baseCompositeMapPage.getSelection();
                    if (sourceCm == null) {
                        return;
                    }
                    CompositeMap objectCm = (CompositeMap)event.item.getData();
                    if (objectCm == null) {
                        return;
                    }
                    if (objectCm.equals((Object)sourceCm) && objectCm.toXML().equals(sourceCm.toXML())) {
                        return;
                    }
                    if (!CompositeMapUtil.validNextNodeLegalWithAction(objectCm, sourceCm)) {
                        return;
                    }
                    CommentCompositeMap childCm = new CommentCompositeMap(sourceCm);
                    if (childCm != null) {
                        objectCm.addChild((CompositeMap)childCm);
                        if (sourceCm.getParent() != null) {
                            sourceCm.getParent().removeChild(sourceCm);
                        }
                    }
                    ServiceTreePage.this.refresh(true);
                }
            }

            private CompositeMap getInput() {
                return ServiceTreePage.this.baseCompositeMapPage.getData();
            }
        });
    }

    private Control getControl() {
        return this.baseCompositeMapPage.getControl();
    }

    private String getClassName(File file, String fullpath) {
        String path = file.getPath();
        int end = path.lastIndexOf(".");
        path = path.substring(fullpath.length() + 1, end);
        path = path.replace(File.separatorChar, '.');
        return path;
    }

    private String getFullPath() throws ApplicationException {
        IEditorInput input = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        IFile ifile = ((IFileEditorInput)input).getFile();
        IProject project = ifile.getProject();
        String bmFilesDir = ProjectUtil.getBMHomeLocalPath(project);
        File baseDir = new File(bmFilesDir);
        String fullPath = baseDir.getAbsolutePath();
        return fullPath;
    }
}

