/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.action;

import aurora.ide.refactoring.RefactoringReplaceInfo;
import aurora.ide.refactoring.ReplaceRefactoring;
import aurora.ide.search.action.AbstractSearchResultPageAction;
import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.core.AuroraMatch;
import aurora.ide.search.core.AuroraSearchResult;
import aurora.ide.search.core.Util;
import aurora.ide.search.ui.LineElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceAttributeAction
extends AbstractSearchResultPageAction {
    public static final String NAME = "name";
    public static final String VALUE = "value";
    private String s_replace;
    private String s_with;
    private ArrayList<RefactoringReplaceInfo> infos;
    private IFile c_file;
    private String type;

    public ReplaceAttributeAction(Shell shell, String type) {
        super(shell);
        this.type = type;
    }

    public void setControl(final Text replace, final Text with) {
        this.s_replace = replace.getText().trim();
        this.s_with = with.getText().trim();
        replace.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReplaceAttributeAction.this.s_replace = replace.getText().trim();
                ReplaceAttributeAction.this.notifyActionChanged();
            }
        });
        with.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReplaceAttributeAction.this.s_with = with.getText().trim();
                ReplaceAttributeAction.this.notifyActionChanged();
            }
        });
    }

    @Override
    protected int getInfoSize() {
        return this.infos == null ? 0 : this.infos.size();
    }

    @Override
    protected String getSubTaskName() {
        return this.c_file == null ? "" : this.c_file.getName();
    }

    @Override
    protected Refactoring createRefactoring(List lines, IProgressMonitor monitor) {
        this.createInfo(lines, monitor);
        return new ReplaceRefactoring(this.infos.toArray(new RefactoringReplaceInfo[this.infos.size()]));
    }

    @Override
    public boolean isRefactorSelectionEnabled() {
        return !"".equals(this.s_replace) && super.isRefactorSelectionEnabled();
    }

    @Override
    public boolean isRefactorAllEnabled() {
        return !"".equals(this.s_replace) && super.isRefactorAllEnabled();
    }

    private void createInfo(List lines, IProgressMonitor monitor) {
        this.infos = new ArrayList();
        Iterator it = lines.iterator();
        while (it.hasNext()) {
            RefactoringReplaceInfo info;
            if (monitor.isCanceled()) {
                return;
            }
            Object next = it.next();
            if (!(next instanceof LineElement)) continue;
            LineElement line = (LineElement)next;
            this.c_file = (IFile)line.getParent();
            if (NAME.equals(this.type) && (info = this.createNameReplaceInfo(line)) != null) {
                this.infos.add(info);
            }
            if (!VALUE.equals(this.type)) continue;
            List<RefactoringReplaceInfo> is = this.createValueReplaceInfo(line);
            this.infos.addAll(is);
        }
    }

    private List<RefactoringReplaceInfo> createValueReplaceInfo(LineElement line) {
        AuroraSearchResult result = this.getSearchResult();
        AbstractMatch[] matches = line.getMatches(result);
        ArrayList<RefactoringReplaceInfo> infos = new ArrayList<RefactoringReplaceInfo>();
        if (matches.length > 0) {
            AuroraMatch am = (AuroraMatch)matches[0];
            IFile file = (IFile)line.getParent();
            try {
                IDocument document = this.getDocument(file);
                ITypedRegion partition = document.getPartition(am.getOffset());
                List<IRegion> valueRegions = Util.getValueRegions(partition.getOffset(), partition.getLength(), document);
                for (IRegion r : valueRegions) {
                    String text = document.get(r.getOffset() + 1, r.getLength() - 2);
                    boolean stringMatch = Util.stringMatch(this.s_replace, text, false, false);
                    if (!stringMatch) continue;
                    RefactoringReplaceInfo info = new RefactoringReplaceInfo((IRegion)new Region(r.getOffset() + 1, r.getLength() - 2), this.getReplaceWith());
                    info.setFile(file);
                    infos.add(info);
                }
            }
            catch (CoreException document) {
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return infos;
    }

    private RefactoringReplaceInfo createNameReplaceInfo(LineElement line) {
        AuroraSearchResult result = this.getSearchResult();
        AbstractMatch[] matches = line.getMatches(result);
        if (matches.length > 0) {
            AuroraMatch am = (AuroraMatch)matches[0];
            CompositeMap map = am.getMatchs().getMap();
            Object value = map.get((Object)this.s_replace);
            if (value == null) {
                return null;
            }
            IFile file = (IFile)line.getParent();
            try {
                IDocument document = this.getDocument(file);
                ITypedRegion partition = document.getPartition(am.getOffset());
                IRegion attRegion = Util.getAttributeRegion(partition.getOffset(), partition.getLength(), this.s_replace, document);
                RefactoringReplaceInfo info = new RefactoringReplaceInfo(attRegion, this.getReplaceWith());
                info.setFile(file);
                return info;
            }
            catch (CoreException document) {
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String getReplaceWith() {
        return this.s_with;
    }
}

