/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.condition;

import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.search.condition.MatchInfo;
import aurora.ide.search.condition.SearchCondition;
import aurora.ide.search.core.Util;
import aurora.ide.search.ui.LineElement;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import uncertain.composite.CompositeMap;

public class NameSpaceCondition
extends SearchCondition {
    private String nameSpace;

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public MatchInfo match(CompositeMap map, IDocument document, LineElement l) {
        if ("".equals(this.nameSpace)) {
            return MatchInfo.Not_Match;
        }
        boolean stringMatch = Util.stringMatch(this.nameSpace, map.getNamespaceURI(), this.isCaseSensitive(), this.isRegularExpression());
        if (stringMatch) {
            MatchInfo info = new MatchInfo();
            String rawName = map.getRawName();
            info.setMap(map);
            try {
                IRegion documentRegion = Util.getDocumentRegion(l.getOffset(), l.getLength(), rawName, document, IColorConstants.TAG_NAME);
                info.addRegion(documentRegion);
                return info;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return MatchInfo.Not_Match;
    }

    public SearchCondition read(IDialogSettings s) {
        this.setCaseSensitive(s.getBoolean("isCaseSensitive"));
        this.setNameSpace(s.get("namespace"));
        return this;
    }

    public void store(IDialogSettings s) {
        s.put("isCaseSensitive", this.isCaseSensitive());
        if (this.nameSpace != null) {
            s.put("namespace", this.nameSpace);
        }
    }

    public boolean isEquals(SearchCondition condition) {
        if (condition instanceof NameSpaceCondition) {
            String _name = this.nameSpace == null ? "" : this.nameSpace;
            return _name.equals(((NameSpaceCondition)condition).nameSpace);
        }
        return super.isEquals(condition);
    }
}

