/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.core;

import aurora.ide.search.condition.AuroraSearchPattern;
import aurora.ide.search.condition.MatchInfo;
import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.core.AbstractSearchService;
import aurora.ide.search.core.AuroraMatch;
import aurora.ide.search.core.AuroraSearchQuery;
import aurora.ide.search.core.CompositeMapIteator;
import aurora.ide.search.core.SearchForMapIteator;
import aurora.ide.search.reference.IDataFilter;
import aurora.ide.search.reference.MapFinderResult;
import aurora.ide.search.ui.LineElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuroraSearchService
extends AbstractSearchService {
    private AuroraSearchPattern pattern;

    public AuroraSearchService(IResource[] roots, AuroraSearchPattern pattern) {
        super(roots, null);
        this.pattern = pattern;
    }

    public AuroraSearchService(IResource[] roots, AuroraSearchPattern pattern, AuroraSearchQuery auroraSearchQuery) {
        super(roots, null, auroraSearchQuery);
        this.pattern = pattern;
    }

    @Override
    protected CompositeMapIteator createIterationHandle(IFile resource) {
        return new SearchForMapIteator(this.pattern.getSearchFor());
    }

    @Override
    protected IDataFilter getDataFilter(IResource[] roots, Object source) {
        return null;
    }

    @Override
    protected List<AbstractMatch> createLineMatches(MapFinderResult r, LineElement l, IFile file, Object _pattern) throws CoreException {
        IDocument document;
        ArrayList<AbstractMatch> matches = new ArrayList<AbstractMatch>();
        CompositeMap map = r.getMap();
        MatchInfo matchInfo = this.pattern.match(map, document = this.getDocument(file), l);
        if (matchInfo.isMatch()) {
            List<IRegion> regions = matchInfo.getRegions();
            for (IRegion region : regions) {
                AuroraMatch match = new AuroraMatch(file, region.getOffset(), region.getLength(), l);
                match.setMatchs(r);
                matches.add(match);
            }
        }
        return matches;
    }

    @Override
    protected Object createPattern(IResource[] roots, Object source) {
        return "Aurora Search";
    }
}

