/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.core;

import aurora.ide.bm.BMUtil;
import aurora.ide.editor.textpage.ColorManager;
import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.editor.textpage.scanners.XMLTagScanner;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.project.propertypage.ProjectPropertyPage;
import aurora.ide.search.core.AbstractSearchService;
import aurora.ide.search.core.PatternConstructor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.RGB;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uncertain.composite.CompositeMap;
import uncertain.schema.Attribute;
import uncertain.schema.Element;
import uncertain.schema.IType;
import uncertain.schema.SimpleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static XMLTagScanner tagScanner;

    public static XMLTagScanner getXMLTagScanner() {
        if (tagScanner == null) {
            ColorManager manager = new ColorManager();
            tagScanner = new XMLTagScanner(manager);
            tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(manager.getColor(IColorConstants.TAG))));
        }
        return tagScanner;
    }

    public static List getMapAttributes(CompositeMap map) {
        Element element = CompositeMapUtil.getElement(map);
        if (element != null) {
            return element.getAllAttributes();
        }
        return null;
    }

    public static IRegion getAttributeRegion(int offset, int length, String name, IDocument document) throws BadLocationException {
        return Util.getDocumentRegion(offset, length, name, document, IColorConstants.ATTRIBUTE);
    }

    public static boolean checkXMLForm(String s) {
        SAXParserFactory parser_factory = SAXParserFactory.newInstance();
        parser_factory.setNamespaceAware(false);
        parser_factory.setValidating(false);
        SAXParser parser = null;
        InputStream is = null;
        try {
            parser = parser_factory.newSAXParser();
            is = new ByteArrayInputStream(s.getBytes("UTF-8"));
            parser.parse(is, new DefaultHandler());
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static IRegion getDocumentRegion(int offset, int length, String name, IDocument document, RGB reginRGB) throws BadLocationException {
        XMLTagScanner scanner = Util.getXMLTagScanner();
        IToken token = null;
        scanner.setRange(document, offset, length);
        while ((token = scanner.nextToken()) != Token.EOF) {
            if (!(token.getData() instanceof TextAttribute)) continue;
            TextAttribute text = (TextAttribute)token.getData();
            int tokenOffset = scanner.getTokenOffset();
            int tokenLength = scanner.getTokenLength();
            if (!text.getForeground().getRGB().equals((Object)reginRGB) || !name.equalsIgnoreCase(document.get(tokenOffset, tokenLength))) continue;
            return new Region(tokenOffset, tokenLength);
        }
        return null;
    }

    public static IRegion getValueRegion(int offset, int length, String value, IDocument document, RGB reginRGB) throws BadLocationException {
        XMLTagScanner scanner = Util.getXMLTagScanner();
        IToken token = null;
        scanner.setRange(document, offset, length);
        while ((token = scanner.nextToken()) != Token.EOF) {
            if (!(token.getData() instanceof TextAttribute)) continue;
            TextAttribute text = (TextAttribute)token.getData();
            int tokenOffset = scanner.getTokenOffset();
            int tokenLength = scanner.getTokenLength();
            if (!text.getForeground().getRGB().equals((Object)reginRGB) || !value.equals(document.get(tokenOffset + 1, tokenLength - 2))) continue;
            return new Region(tokenOffset, tokenLength);
        }
        return null;
    }

    public static List<IRegion> getValueRegions(int offset, int length, IDocument document) throws BadLocationException {
        ArrayList<IRegion> result = new ArrayList<IRegion>();
        XMLTagScanner scanner = Util.getXMLTagScanner();
        IToken token = null;
        scanner.setRange(document, offset, length);
        while ((token = scanner.nextToken()) != Token.EOF) {
            if (!(token.getData() instanceof TextAttribute)) continue;
            TextAttribute text = (TextAttribute)token.getData();
            int tokenOffset = scanner.getTokenOffset();
            int tokenLength = scanner.getTokenLength();
            if (!text.getForeground().getRGB().equals((Object)IColorConstants.STRING)) continue;
            result.add((IRegion)new Region(tokenOffset, tokenLength));
        }
        return result;
    }

    public static IRegion getValueRegion(int offset, int length, int hintOffset, IDocument document, RGB reginRGB) throws BadLocationException {
        XMLTagScanner scanner = Util.getXMLTagScanner();
        IToken token = null;
        scanner.setRange(document, offset, length);
        while ((token = scanner.nextToken()) != Token.EOF) {
            if (!(token.getData() instanceof TextAttribute)) continue;
            TextAttribute text = (TextAttribute)token.getData();
            int tokenOffset = scanner.getTokenOffset();
            int tokenLength = scanner.getTokenLength();
            if (!text.getForeground().getRGB().equals((Object)reginRGB) || tokenOffset > hintOffset || hintOffset > tokenOffset + tokenLength) continue;
            return new Region(tokenOffset, tokenLength);
        }
        return null;
    }

    public static IRegion getValuePartRegion(int offset, int length, String name, IDocument document, RGB reginRGB) throws BadLocationException {
        XMLTagScanner scanner = Util.getXMLTagScanner();
        IToken token = null;
        scanner.setRange(document, offset, length);
        while ((token = scanner.nextToken()) != Token.EOF) {
            if (!(token.getData() instanceof TextAttribute)) continue;
            TextAttribute text = (TextAttribute)token.getData();
            int tokenOffset = scanner.getTokenOffset();
            int tokenLength = scanner.getTokenLength();
            if (!text.getForeground().getRGB().equals((Object)reginRGB)) continue;
            if (name.length() == 0) {
                return new Region(tokenOffset, tokenLength);
            }
            int index = document.get(tokenOffset, tokenLength).indexOf(name);
            if (index == -1) continue;
            return new Region(tokenOffset + index, name.length());
        }
        return null;
    }

    public static IRegion getFirstWhitespaceRegion(int offset, int length, IDocument document) throws BadLocationException {
        XMLTagScanner scanner = Util.getXMLTagScanner();
        IToken token = null;
        Region c_region = null;
        scanner.setRange(document, offset, length);
        while ((token = scanner.nextToken()) != Token.EOF) {
            TextAttribute text;
            int tokenOffset = scanner.getTokenOffset();
            int tokenLength = scanner.getTokenLength();
            if (Token.WHITESPACE.equals(token)) {
                c_region = new Region(tokenOffset, tokenLength);
            }
            if (!(token.getData() instanceof TextAttribute) || !(text = (TextAttribute)token.getData()).getForeground().getRGB().equals((Object)IColorConstants.ATTRIBUTE)) continue;
            return c_region;
        }
        return null;
    }

    public static Object getReferenceModelPKG(CompositeMap map) {
        if (map == null) {
            return null;
        }
        Element element = CompositeMapUtil.getElement(map);
        if (element != null) {
            List attrib_list = element.getAllAttributes();
            for (Attribute attrib : attrib_list) {
                IType attributeType = attrib.getAttributeType();
                boolean referenceOf = Util.isBMReference(attributeType);
                if (!referenceOf) continue;
                return CompositeMapUtil.getValueIgnoreCase(attrib, map);
            }
        }
        return null;
    }

    public static boolean isBMReference(IType attributeType) {
        if (attributeType instanceof SimpleType) {
            return AbstractSearchService.bmReference.equals((Object)((SimpleType)attributeType).getReferenceTypeQName());
        }
        return false;
    }

    public static IContainer findWebInf(IResource resource) {
        if (resource == null) {
            return null;
        }
        IFolder webINF = null;
        IProject project = resource.getProject();
        try {
            String web = project.getPersistentProperty(ProjectPropertyPage.WebQN);
            if (web != null) {
                IPath webINFPath = new Path(web).append("WEB-INF");
                webINF = project.getParent().getFolder(webINFPath);
            }
        }
        catch (CoreException web) {
            // empty catch block
        }
        if (webINF != null && webINF.exists()) {
            return webINF;
        }
        try {
            WebInfFinder finder = new WebInfFinder();
            project.accept((IResourceVisitor)finder);
            return finder.getFolder();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IContainer findBMHome(IResource resource) {
        if (resource == null) {
            return null;
        }
        IFolder bmHome = null;
        IProject project = resource.getProject();
        try {
            String bm = project.getPersistentProperty(ProjectPropertyPage.BMQN);
            Path bmPath = new Path(bm);
            bmHome = project.getParent().getFolder((IPath)bmPath);
        }
        catch (CoreException bm) {
            // empty catch block
        }
        if (bmHome != null && bmHome.exists()) {
            return bmHome;
        }
        IContainer webINF = Util.findWebInf(resource);
        if (webINF != null && webINF.exists()) {
            IFolder classes = webINF.getFolder((IPath)new Path("classes"));
            return classes.exists() ? classes : null;
        }
        return null;
    }

    public static IResource getScope(IResource sourceFile) {
        if (sourceFile == null) {
            return null;
        }
        IProject project = sourceFile.getProject();
        Object scope = Util.findWebInf(sourceFile);
        scope = scope == null ? project : scope.getParent();
        return scope;
    }

    public static IFile findBMFile(CompositeMap map) {
        Object pkg = Util.getReferenceModelPKG(map);
        if (pkg == null) {
            pkg = Util.getReferenceModelPKG(map.getParent());
        }
        if (pkg == null) {
            pkg = Util.getReferenceModelPKG(map.getParent().getParent());
        }
        if (pkg instanceof String) {
            return Util.findBMFileByPKG(pkg);
        }
        return null;
    }

    public static IFile findBMFileByPKG(Object pkg) {
        try {
            IResource file = BMUtil.getBMResourceFromClassPath((String)pkg);
            if (file instanceof IFile && "bm".equalsIgnoreCase(file.getFileExtension())) {
                return (IFile)file;
            }
        }
        catch (ApplicationException applicationException) {
            // empty catch block
        }
        return null;
    }

    public static IFile findScreenFile(IFile file, Object pkg) {
        if (pkg instanceof String) {
            IFile sourceFile;
            IPath sourceFilePath;
            String[] split;
            IContainer webInf = Util.findWebInf((IResource)file);
            if (webInf == null) {
                return null;
            }
            IContainer webRoot = webInf.getParent();
            IContainer parent = file.getParent();
            IPath parentPath = parent.getFullPath();
            IPath rootPath = webRoot.getFullPath();
            Path requestPath = new Path("${/request/@context_path}");
            Path path = new Path((String)pkg);
            boolean prefixOfRequest = requestPath.isPrefixOf((IPath)path);
            if (prefixOfRequest) {
                path = path.makeRelativeTo((IPath)requestPath);
            }
            if ((split = path.toString().split("\\?")) == null || split.length == 0) {
                return null;
            }
            path = new Path(split[0]);
            if (path.segmentCount() == 0) {
                return null;
            }
            IPath relativePath = parentPath.makeRelativeTo(rootPath);
            boolean prefixOf = relativePath.isPrefixOf((IPath)path);
            if (prefixOf || prefixOfRequest) {
                sourceFilePath = rootPath.append((IPath)path);
                if (sourceFilePath.segmentCount() < 2) {
                    return null;
                }
                sourceFile = file.getProject().getParent().getFile(sourceFilePath);
                if (sourceFile.exists()) {
                    return sourceFile;
                }
            } else {
                IFile sourceFile2 = parent.getFile((IPath)path);
                if (sourceFile2.exists()) {
                    return sourceFile2;
                }
            }
            if ((sourceFilePath = rootPath.append((IPath)path)).segmentCount() < 2) {
                return null;
            }
            sourceFile = file.getProject().getParent().getFile(sourceFilePath);
            if (sourceFile.exists()) {
                return sourceFile;
            }
        }
        return null;
    }

    public static String findScreenUrl(IFile file, Object pkg) {
        if (pkg instanceof String) {
            String[] split;
            Path requestPath = new Path("${/request/@context_path}");
            Path path = new Path((String)pkg);
            boolean prefixOfRequest = requestPath.isPrefixOf((IPath)path);
            if (prefixOfRequest) {
                path = path.makeRelativeTo((IPath)requestPath);
            }
            if ((split = path.toString().split("\\?")) == null || split.length == 0) {
                return "";
            }
            path = new Path(split[0]);
            if (path.segmentCount() == 0) {
                return "";
            }
            return path.toString();
        }
        return "";
    }

    public static boolean stringMatch(String pattern, String text, boolean isCaseSensitive, boolean isRegularExpression) {
        if (text == null) {
            return false;
        }
        Pattern jdkPattern = PatternConstructor.createPattern(pattern, isCaseSensitive, isRegularExpression);
        Matcher matcher = jdkPattern.matcher(text);
        return matcher.matches();
    }

    public static String toBMPKG(IFile file) {
        IPath path = file.getProjectRelativePath().removeFileExtension();
        return Util.toPKG(path);
    }

    public static String toPKG(IPath path) {
        String[] segments = path.segments();
        StringBuilder result = new StringBuilder();
        StringBuilder _result = new StringBuilder();
        int classes_idx = -1;
        int i = 0;
        while (i < segments.length) {
            _result.append(segments[i]);
            if (i != segments.length - 1) {
                _result.append(".");
            }
            if (classes_idx != -1) {
                result.append(segments[i]);
                if (i != segments.length - 1) {
                    result.append(".");
                }
            }
            if ("classes".equals(segments[i])) {
                classes_idx = i;
            }
            ++i;
        }
        if (result.length() == 0) {
            result = _result;
        }
        return result.toString();
    }

    public static String toRelativeClassesPKG(IPath path) {
        String[] segments = path.segments();
        StringBuilder result = new StringBuilder();
        int classes_idx = -1;
        int i = 0;
        while (i < segments.length) {
            if (classes_idx != -1) {
                result.append(segments[i]);
                if (i != segments.length - 1) {
                    result.append(".");
                }
            }
            if ("classes".equals(segments[i])) {
                classes_idx = i;
            }
            ++i;
        }
        return result.toString();
    }

    public static boolean bmRefMatch(Object bmPattern, String url) {
        String[] segments;
        Path path = new Path(url);
        String[] stringArray = segments = path.segments();
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] split = s.split("\\?");
            if (split == null || split.length == 0) {
                return false;
            }
            s = split[0];
            if (s.equals(bmPattern)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getBmAction(Object bmPattern, String url) {
        String[] segments;
        boolean findModel = false;
        Path path = new Path(url);
        String[] stringArray = segments = path.segments();
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] split = s.split("\\?");
            if (split == null || split.length == 0) {
                return "";
            }
            s = split[0];
            if (findModel) {
                return s;
            }
            if (s.equals(bmPattern)) {
                findModel = true;
            }
            ++n2;
        }
        return "";
    }

    public static String getUrlLeftString(Object bmPattern, String url) {
        int indexOf = url.indexOf("?");
        if (indexOf != -1) {
            return "'" + url.substring(indexOf) + "'";
        }
        return "";
    }

    public static String getUrlComment(Object bmPattern, String url) {
        int indexOf = url.indexOf("?");
        if (indexOf != -1) {
            return "/*" + url.substring(0, indexOf) + "*/";
        }
        return "/*" + url + "*/";
    }

    public static String convertJS(String source) {
        if (source == null) {
            return null;
        }
        Pattern ptn = Pattern.compile("\\$\\{[^}]+\\}");
        Matcher m = ptn.matcher(source);
        char[] charArray = source.toCharArray();
        while (m.find()) {
            Arrays.fill(charArray, m.start(), m.end(), '1');
        }
        return new String(charArray);
    }

    public static String getPKG(IPath path) {
        String fileExtension = path.getFileExtension();
        if ("bm".equalsIgnoreCase(fileExtension)) {
            return Util.toPKG(path.removeFileExtension());
        }
        if ("screen".equalsIgnoreCase(fileExtension)) {
            return path.toString();
        }
        return "";
    }

    private static class WebInfFinder
    implements IResourceVisitor {
        private IFolder folder = null;

        private WebInfFinder() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.folder != null) {
                return false;
            }
            if (resource.getType() == 2) {
                if ("WEB-INF".equals(resource.getName())) {
                    this.folder = (IFolder)resource;
                    return false;
                }
                return true;
            }
            return resource.getType() != 1;
        }

        public IFolder getFolder() {
            return this.folder;
        }
    }
}

