/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.reference;

import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.search.core.CompositeMapIteator;
import aurora.ide.search.reference.IDataFilter;
import aurora.ide.search.reference.MapFinderResult;
import java.util.ArrayList;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.schema.Attribute;
import uncertain.schema.Element;

public class TypeFinder
extends CompositeMapIteator {
    private QualifiedName type;

    public int process(CompositeMap map) {
        try {
            List match = this.getMatch(map);
            if (match != null) {
                this.getResult().add(new MapFinderResult(map, match));
            }
        }
        catch (ApplicationException e) {
            e.printStackTrace();
        }
        return 0;
    }

    protected List getMatch(CompositeMap map) throws ApplicationException {
        ArrayList<Attribute> matchs = new ArrayList<Attribute>();
        boolean isMacth = false;
        Element element = CompositeMapUtil.getElement(map);
        if (element != null) {
            List attrib_list = element.getAllAttributes();
            for (Attribute attrib : attrib_list) {
                boolean referenceOf = this.isType(attrib);
                if (!referenceOf) continue;
                boolean found = true;
                IDataFilter filter = this.getFilter();
                if (filter != null) {
                    found = filter.found(map, attrib);
                }
                if (!found) continue;
                isMacth = true;
                matchs.add(attrib);
            }
            if (isMacth) {
                return matchs;
            }
        }
        return null;
    }

    protected boolean isType(Attribute attribute) {
        return this.type.equals((Object)attribute.getTypeQName());
    }

    public TypeFinder(QualifiedName referenceType) {
        this.type = referenceType;
    }
}

