/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.ui;

import aurora.ide.search.core.AbstractMatch;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

public class LineElement {
    private final IResource fParent;
    private final int fLineNumber;
    private final int fLineStartOffset;
    private final String fLineContents;

    public LineElement(IResource parent, int lineNumber, int lineStartOffset, String lineContents) {
        this.fParent = parent;
        this.fLineNumber = lineNumber;
        this.fLineStartOffset = lineStartOffset;
        this.fLineContents = lineContents;
    }

    public IResource getParent() {
        return this.fParent;
    }

    public int getLine() {
        return this.fLineNumber;
    }

    public String getContents() {
        return this.fLineContents;
    }

    public int getOffset() {
        return this.fLineStartOffset;
    }

    public boolean contains(int offset) {
        return this.fLineStartOffset <= offset && offset < this.fLineStartOffset + this.fLineContents.length();
    }

    public int getLength() {
        return this.fLineContents.length();
    }

    public AbstractMatch[] getMatches(AbstractTextSearchResult result) {
        ArrayList<AbstractMatch> res = new ArrayList<AbstractMatch>();
        Match[] matches = result.getMatches((Object)this.fParent);
        int i = 0;
        while (i < matches.length) {
            AbstractMatch curr = (AbstractMatch)matches[i];
            if (curr.getLineElement() == this) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new AbstractMatch[res.size()]);
    }

    public int getNumberOfMatches(AbstractTextSearchResult result) {
        int count = 0;
        Match[] matches = result.getMatches((Object)this.fParent);
        int i = 0;
        while (i < matches.length) {
            AbstractMatch curr = (AbstractMatch)matches[i];
            if (curr.getLineElement() == this) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

