/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.statistics.repo;

import aurora.ide.api.statistics.cvs.CVSEntryLineTag;
import aurora.ide.api.statistics.cvs.CVSTag;
import aurora.ide.api.statistics.cvs.FolderSyncInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

public class CVSFileReader {
    public static final String CVS_DIRNAME = "CVS";
    public static final String REPOSITORY = "Repository";
    public static final String ROOT = "Root";
    public static final String STATIC = "Entries.Static";
    public static final String TAG = "Tag";
    public static final String ENTRIES = "Entries";
    public static final String ENTRIES_LOG = "Entries.Log";
    public static final String NOTIFY = "Notify";
    public static final String BASE_DIRNAME = "Base";
    public static final String BASEREV = "Baserev";
    public static final String IGNORE_FILE = ".cvsignore";
    private static final String FOLDER_TAG = "D";
    private static final String ADD_TAG = "A ";
    private static final String REMOVE_TAG = "R ";
    public static final QualifiedName MODSTAMP_KEY = new QualifiedName("org.eclipse.team.cvs.core", "meta-file-modtime");

    private static boolean folderExists(IFolder cvsSubDir) {
        try {
            IFileStore store;
            URI uri = cvsSubDir.getLocationURI();
            if (uri != null && (store = EFS.getStore((URI)uri)) != null) {
                return store.fetchInfo().exists();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    public static FolderSyncInfo readFolderSync(IContainer folder) {
        String root;
        IFolder cvsSubDir = CVSFileReader.getCVSSubdirectory(folder);
        if (!CVSFileReader.folderExists(cvsSubDir)) {
            return null;
        }
        if (!cvsSubDir.isTeamPrivateMember() && cvsSubDir.exists()) {
            try {
                cvsSubDir.setTeamPrivateMember(true);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if ((root = CVSFileReader.readFirstLine(cvsSubDir.getFile(ROOT))) == null) {
            return null;
        }
        String repository = CVSFileReader.readFirstLine(cvsSubDir.getFile(REPOSITORY));
        if (repository == null) {
            return null;
        }
        String tag = CVSFileReader.readFirstLine(cvsSubDir.getFile(TAG));
        CVSEntryLineTag cvsTag = tag != null ? new CVSEntryLineTag(tag) : null;
        String staticDir = CVSFileReader.readFirstLine(cvsSubDir.getFile(STATIC));
        boolean isStatic = staticDir != null;
        return new FolderSyncInfo(repository, root, (CVSTag)cvsTag, isStatic);
    }

    private static IFolder getCVSSubdirectory(IContainer folder) {
        return folder.getFolder((IPath)new Path(CVS_DIRNAME));
    }

    protected static boolean existsInFileSystem(IFolder cvsSubDir) {
        URI uri = cvsSubDir.getLocationURI();
        if (uri != null) {
            try {
                IFileStore store = EFS.getStore((URI)uri);
                if (store != null) {
                    return store.fetchInfo().exists();
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readFirstLine(IFile file) {
        try {
            InputStream in = CVSFileReader.getInputStream(file);
            if (in == null) return null;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in), 512);
            try {
                String line = reader.readLine();
                if (line == null) {
                    return "";
                }
                String string = line;
                return string;
            }
            finally {
                reader.close();
            }
        }
        catch (IOException in) {
            return null;
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 368) return null;
            if (e.getStatus().getCode() != 271) return null;
            return null;
        }
    }

    private static InputStream getInputStream(IFile file) throws CoreException, FileNotFoundException {
        File ioFile;
        IFileStore store;
        if (file.exists()) {
            return file.getContents(true);
        }
        URI uri = file.getLocationURI();
        if (uri != null && (store = EFS.getStore((URI)uri)) != null) {
            return store.openInputStream(0, null);
        }
        IPath location = file.getLocation();
        if (location != null && (ioFile = location.toFile()) != null && ioFile.exists()) {
            return new FileInputStream(ioFile);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] readLines(IFile file) {
        String[] stringArray;
        InputStream in2 = CVSFileReader.getInputStream(file);
        if (in2 == null) return null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in2), 512);
        ArrayList<String> fileContentStore = new ArrayList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                fileContentStore.add(line);
            }
            stringArray = fileContentStore.toArray(new String[fileContentStore.size()]);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException in2) {
                return null;
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() != 368 && e.getStatus().getCode() != 271) return null;
                return null;
            }
        }
        reader.close();
        return stringArray;
    }

    private static IFolder getBaseDirectory(IFile file) {
        IFolder cvsFolder = CVSFileReader.getCVSSubdirectory(file.getParent());
        IFolder baseFolder = cvsFolder.getFolder((IPath)new Path(BASE_DIRNAME));
        return baseFolder;
    }

    public static boolean isEdited(IFile file) {
        IFolder baseFolder = CVSFileReader.getBaseDirectory(file);
        IFile baseFile = baseFolder.getFile(file.getName());
        return baseFile.exists();
    }
}

