/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.statistics.viewer;

import aurora.ide.statistics.viewer.ObjectNode;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class ObjectViewerSorter
extends ViewerSorter {
    private static final int FILENAME = 1;
    private static final int PATH = 2;
    private static final int FILESIZE = 3;
    private static final int SCRIPTSIZE = 4;
    private static final int TAGCOUNT = 5;
    private static final int REFINCOUNT = 6;
    private static final int REFOUTCOUNT = 7;
    public static final ObjectViewerSorter FILENAME_ASC = new ObjectViewerSorter(1);
    public static final ObjectViewerSorter FILENAME_DESC = new ObjectViewerSorter(-1);
    public static final ObjectViewerSorter PATH_ASC = new ObjectViewerSorter(2);
    public static final ObjectViewerSorter PATH_DESC = new ObjectViewerSorter(-2);
    public static final ObjectViewerSorter FILESIZE_ASC = new ObjectViewerSorter(3);
    public static final ObjectViewerSorter FILESIZE_DESC = new ObjectViewerSorter(-3);
    public static final ObjectViewerSorter SCRIPTSIZE_ASC = new ObjectViewerSorter(4);
    public static final ObjectViewerSorter SCRIPTSIZE_DESC = new ObjectViewerSorter(-4);
    public static final ObjectViewerSorter TAGCOUNT_ASC = new ObjectViewerSorter(5);
    public static final ObjectViewerSorter TAGCOUNT_DESC = new ObjectViewerSorter(-5);
    public static final ObjectViewerSorter REFINCOUNT_ASC = new ObjectViewerSorter(6);
    public static final ObjectViewerSorter REFINCOUNT_DESC = new ObjectViewerSorter(-6);
    public static final ObjectViewerSorter REFOUTCOUNT_ASC = new ObjectViewerSorter(7);
    public static final ObjectViewerSorter REFOUTCOUNT_DESC = new ObjectViewerSorter(-7);
    private int sortType;

    private ObjectViewerSorter(int sortType) {
        this.sortType = sortType;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (!(e1 instanceof ObjectNode) || !(e2 instanceof ObjectNode)) {
            return 0;
        }
        ObjectNode o1 = (ObjectNode)e1;
        ObjectNode o2 = (ObjectNode)e2;
        switch (this.sortType) {
            case 1: {
                String s1 = o1.fileName;
                String s2 = o2.fileName;
                if (s1 != null && s2 != null) {
                    return s1.compareTo(s2);
                }
            }
            case -1: {
                String s1 = o1.fileName;
                String s2 = o2.fileName;
                if (s1 != null && s2 != null) {
                    return s2.compareTo(s1);
                }
            }
            case 2: {
                String s1 = o1.path;
                String s2 = o2.path;
                if (s1 != null && s2 != null) {
                    return s1.compareTo(s2);
                }
            }
            case -2: {
                String s1 = o1.path;
                String s2 = o2.path;
                if (s1 != null && s2 != null) {
                    return s2.compareTo(s1);
                }
            }
            case 3: {
                String s1 = o1.fileSize;
                String s2 = o2.fileSize;
                if (s1 != null && s2 != null) {
                    if (Integer.parseInt(s1) > Integer.parseInt(s2)) {
                        return 1;
                    }
                    if (Integer.parseInt(s1) < Integer.parseInt(s2)) {
                        return -1;
                    }
                    return 0;
                }
            }
            case -3: {
                String s1 = o1.fileSize;
                String s2 = o2.fileSize;
                if (s1 != null && s2 != null) {
                    if (Integer.parseInt(s2) > Integer.parseInt(s1)) {
                        return 1;
                    }
                    if (Integer.parseInt(s2) < Integer.parseInt(s1)) {
                        return -1;
                    }
                    return 0;
                }
            }
            case 4: {
                String s1 = o1.scriptSize;
                String s2 = o2.scriptSize;
                if (s1 != null && s2 != null) {
                    if (Integer.parseInt(s1) > Integer.parseInt(s2)) {
                        return 1;
                    }
                    if (Integer.parseInt(s1) < Integer.parseInt(s2)) {
                        return -1;
                    }
                    return 0;
                }
            }
            case -4: {
                String s1 = o1.scriptSize;
                String s2 = o2.scriptSize;
                if (s1 != null && s2 != null) {
                    if (Integer.parseInt(s2) > Integer.parseInt(s1)) {
                        return 1;
                    }
                    if (Integer.parseInt(s2) < Integer.parseInt(s1)) {
                        return -1;
                    }
                    return 0;
                }
            }
            case 5: {
                String s1 = o1.tagCount;
                String s2 = o2.tagCount;
                if (s1 != null && s2 != null) {
                    if (Integer.parseInt(s1) > Integer.parseInt(s2)) {
                        return 1;
                    }
                    if (Integer.parseInt(s1) < Integer.parseInt(s2)) {
                        return -1;
                    }
                    return 0;
                }
            }
            case -5: {
                String s1 = o1.tagCount;
                String s2 = o2.tagCount;
                if (s1 != null && s2 != null) {
                    if (Integer.parseInt(s2) > Integer.parseInt(s1)) {
                        return 1;
                    }
                    if (Integer.parseInt(s2) < Integer.parseInt(s1)) {
                        return -1;
                    }
                    return 0;
                }
            }
            case 6: {
                String s1 = o1.refInCount;
                String s2 = o2.refInCount;
                if (s1 != null && s2 != null) {
                    if (Integer.parseInt(s1) > Integer.parseInt(s2)) {
                        return 1;
                    }
                    if (Integer.parseInt(s1) < Integer.parseInt(s2)) {
                        return -1;
                    }
                    return 0;
                }
            }
            case -6: {
                String s1 = o1.refInCount;
                String s2 = o2.refInCount;
                if (s1 != null && s2 != null) {
                    if (Integer.parseInt(s2) > Integer.parseInt(s1)) {
                        return 1;
                    }
                    if (Integer.parseInt(s2) < Integer.parseInt(s1)) {
                        return -1;
                    }
                    return 0;
                }
            }
            case 7: {
                String s1 = o1.refOutCount;
                String s2 = o2.refOutCount;
                if (s1 != null && s2 != null) {
                    if (Integer.parseInt(s1) > Integer.parseInt(s2)) {
                        return 1;
                    }
                    if (Integer.parseInt(s1) < Integer.parseInt(s2)) {
                        return -1;
                    }
                    return 0;
                }
            }
            case -7: {
                String s1 = o1.refOutCount;
                String s2 = o2.refOutCount;
                if (s1 == null || s2 == null) break;
                if (Integer.parseInt(s2) > Integer.parseInt(s1)) {
                    return 1;
                }
                if (Integer.parseInt(s2) < Integer.parseInt(s1)) {
                    return -1;
                }
                return 0;
            }
        }
        return 0;
    }
}

