/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.statistics.viewer;

import aurora.ide.api.statistics.map.ObjectStatisticsResult;
import aurora.ide.api.statistics.model.StatisticsProject;
import aurora.ide.statistics.viewer.ProjectNode;
import java.text.DecimalFormat;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

class ProjectViewLabelProvider
implements ITableLabelProvider {
    ProjectViewLabelProvider() {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof StatisticsProject && columnIndex == 0) {
            String s = ((StatisticsProject)element).getProjectName();
            if ("no project".equals(s)) {
                return "\u7a7a\u9879\u76ee";
            }
            return s;
        }
        if (element instanceof ObjectStatisticsResult && columnIndex == 0) {
            return ((ObjectStatisticsResult)element).getType();
        }
        if (element instanceof ProjectNode) {
            ProjectNode node = (ProjectNode)element;
            switch (columnIndex) {
                case 0: {
                    if ("file size".equals(node.name)) {
                        return "\u6587\u4ef6\u5927\u5c0f";
                    }
                    if ("files".equals(node.name)) {
                        return "\u6587\u4ef6\u6570\u91cf";
                    }
                    if ("script size".equals(node.name)) {
                        return "\u811a\u672c\u5927\u5c0f";
                    }
                    if ("tags".equals(node.name)) {
                        return "\u6807\u7b7e\u6570\u91cf";
                    }
                    if ("projectName".equals(node.name)) {
                        return "\u9879\u76ee\u540d";
                    }
                    if ("storer".equals(node.name)) {
                        return "\u4fdd\u5b58\u4eba";
                    }
                    if ("storeDate".equals(node.name)) {
                        return "\u4fdd\u5b58\u65f6\u95f4";
                    }
                    if ("repositoryType".equals(node.name)) {
                        return "\u8d44\u6e90\u5e93\u7c7b\u578b";
                    }
                    if ("repositoryRevesion".equals(node.name)) {
                        return "\u8d44\u6e90\u5e93\u7248\u672c";
                    }
                    if ("repositoryPath".equals(node.name)) {
                        return "\u8d44\u6e90\u5e93\u8def\u5f84";
                    }
                    return node.name;
                }
                case 1: {
                    if (node.name.indexOf("size") >= 0) {
                        return this.conversion(node.value);
                    }
                    if ("no project".equals(node.value)) {
                        return "\u7a7a\u9879\u76ee";
                    }
                    return node.value;
                }
                case 2: {
                    if (node.name.indexOf("size") >= 0) {
                        return this.conversion(node.max);
                    }
                    return node.max;
                }
                case 3: {
                    if (node.name.indexOf("size") >= 0) {
                        return this.conversion(node.min);
                    }
                    return node.min;
                }
                case 4: {
                    if (node.name.indexOf("size") >= 0) {
                        return this.conversion(node.average);
                    }
                    return node.average;
                }
            }
        }
        return null;
    }

    private String conversion(String value) {
        if (value.matches("\\d+")) {
            DecimalFormat df = new DecimalFormat("0.00");
            double v = Double.parseDouble(value);
            if (value.length() > 3 && value.length() <= 6) {
                return String.valueOf(df.format(v /= 1024.0)) + " KB";
            }
            if (value.length() > 6) {
                return String.valueOf(df.format(v /= 1048576.0)) + " MB";
            }
            return String.valueOf((int)v) + " Byte";
        }
        return value;
    }
}

